/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.mendax.datainput;

import java.io.DataInput;
import java.io.IOException;
import net.md_5.mendax.datainput.BulkChunk;
import net.md_5.mendax.datainput.ByteHeader;
import net.md_5.mendax.datainput.IntHeader;
import net.md_5.mendax.datainput.Item;
import net.md_5.mendax.datainput.Jump;
import net.md_5.mendax.datainput.MetaData;
import net.md_5.mendax.datainput.OptionalMotion;
import net.md_5.mendax.datainput.ShortHeader;
import net.md_5.mendax.datainput.UnsignedByteByte;

abstract class Instruction {
    static final Instruction BOOLEAN = new Jump(1);
    static final Instruction BULK_CHUNK = new BulkChunk();
    static final Instruction BYTE = new Jump(1);
    static final Instruction DOUBLE = new Jump(8);
    static final Instruction FLOAT = new Jump(4);
    static final Instruction INT = new Jump(4);
    static final Instruction INT_3 = new IntHeader(new Jump(3));
    static final Instruction INT_BYTE = new IntHeader(BYTE);
    static final Instruction ITEM = new Item();
    static final Instruction LONG = new Jump(8);
    static final Instruction METADATA = new MetaData();
    static final Instruction OPTIONAL_MOTION = new OptionalMotion();
    static final Instruction SHORT = new Jump(2);
    static final Instruction SHORT_BYTE = new ShortHeader(BYTE);
    static final Instruction SHORT_ITEM = new ShortHeader(ITEM);
    static final Instruction STRING = new ShortHeader(new Jump(2));
    static final Instruction UBYTE_BYTE = new UnsignedByteByte();
    static final Instruction BYTE_INT = new ByteHeader(INT);

    Instruction() {
    }

    abstract void read(DataInput var1) throws IOException;

    final void skip(DataInput in, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            in.readUnsignedByte();
        }
    }
}

