/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.AchievementList;
import net.minecraft.server.Block;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.LocaleI18n;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.World;

public class EntityItem
extends Entity {
    public ItemStack itemStack;
    public int age = 0;
    public int pickupDelay;
    private int e = 5;
    public float d = (float)(Math.random() * Math.PI * 2.0);

    public EntityItem(World world, double d, double d2, double d3, ItemStack itemStack) {
        super(world);
        this.a(0.25f, 0.25f);
        this.height = this.length / 2.0f;
        this.setPosition(d, d2, d3);
        this.itemStack = itemStack;
        this.yaw = (float)(Math.random() * 360.0);
        this.motX = (float)(Math.random() * (double)0.2f - (double)0.1f);
        this.motY = 0.2f;
        this.motZ = (float)(Math.random() * (double)0.2f - (double)0.1f);
    }

    protected boolean e_() {
        return false;
    }

    public EntityItem(World world) {
        super(world);
        this.a(0.25f, 0.25f);
        this.height = this.length / 2.0f;
    }

    protected void a() {
    }

    public void h_() {
        boolean bl;
        super.h_();
        if (this.pickupDelay > 0) {
            --this.pickupDelay;
        }
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        this.motY -= (double)0.04f;
        this.i(this.locX, (this.boundingBox.b + this.boundingBox.e) / 2.0, this.locZ);
        this.move(this.motX, this.motY, this.motZ);
        boolean bl2 = bl = (int)this.lastX != (int)this.locX || (int)this.lastY != (int)this.locY || (int)this.lastZ != (int)this.locZ;
        if (bl) {
            if (this.world.getMaterial(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ)) == Material.LAVA) {
                this.motY = 0.2f;
                this.motX = (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
                this.motZ = (this.random.nextFloat() - this.random.nextFloat()) * 0.2f;
                this.world.makeSound(this, "random.fizz", 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
            }
            if (!this.world.isStatic) {
                for (EntityItem entityItem : this.world.a(EntityItem.class, this.boundingBox.grow(0.5, 0.0, 0.5))) {
                    this.a(entityItem);
                }
            }
        }
        float f = 0.98f;
        if (this.onGround) {
            f = 0.58800006f;
            int n = this.world.getTypeId(MathHelper.floor(this.locX), MathHelper.floor(this.boundingBox.b) - 1, MathHelper.floor(this.locZ));
            if (n > 0) {
                f = Block.byId[n].frictionFactor * 0.98f;
            }
        }
        this.motX *= (double)f;
        this.motY *= (double)0.98f;
        this.motZ *= (double)f;
        if (this.onGround) {
            this.motY *= -0.5;
        }
        ++this.age;
        if (this.age >= 6000) {
            this.die();
        }
    }

    public boolean a(EntityItem entityItem) {
        if (entityItem == this) {
            return false;
        }
        if (!entityItem.isAlive() || !this.isAlive()) {
            return false;
        }
        if (entityItem.itemStack.getItem() != this.itemStack.getItem()) {
            return false;
        }
        if (entityItem.itemStack.getItem().k() && entityItem.itemStack.getData() != this.itemStack.getData()) {
            return false;
        }
        if (entityItem.itemStack.count < this.itemStack.count) {
            return entityItem.a(this);
        }
        if (entityItem.itemStack.count + this.itemStack.count > entityItem.itemStack.getMaxStackSize()) {
            return false;
        }
        entityItem.itemStack.count += this.itemStack.count;
        entityItem.pickupDelay = Math.max(entityItem.pickupDelay, this.pickupDelay);
        entityItem.age = Math.min(entityItem.age, this.age);
        this.die();
        return true;
    }

    public void d() {
        this.age = 4800;
    }

    public boolean I() {
        return this.world.a(this.boundingBox, Material.WATER, (Entity)this);
    }

    protected void burn(int n) {
        this.damageEntity(DamageSource.FIRE, n);
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        this.K();
        this.e -= n;
        if (this.e <= 0) {
            this.die();
        }
        return false;
    }

    public void b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.setShort("Health", (byte)this.e);
        nBTTagCompound.setShort("Age", (short)this.age);
        if (this.itemStack != null) {
            nBTTagCompound.setCompound("Item", this.itemStack.save(new NBTTagCompound()));
        }
    }

    public void a(NBTTagCompound nBTTagCompound) {
        this.e = nBTTagCompound.getShort("Health") & 0xFF;
        this.age = nBTTagCompound.getShort("Age");
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.getCompound("Item");
        this.itemStack = ItemStack.a(nBTTagCompound2);
        if (this.itemStack == null) {
            this.die();
        }
    }

    public void b_(EntityHuman entityHuman) {
        if (this.world.isStatic) {
            return;
        }
        int n = this.itemStack.count;
        if (this.pickupDelay == 0 && entityHuman.inventory.pickup(this.itemStack)) {
            if (this.itemStack.id == Block.LOG.id) {
                entityHuman.a(AchievementList.g);
            }
            if (this.itemStack.id == Item.LEATHER.id) {
                entityHuman.a(AchievementList.t);
            }
            if (this.itemStack.id == Item.DIAMOND.id) {
                entityHuman.a(AchievementList.w);
            }
            if (this.itemStack.id == Item.BLAZE_ROD.id) {
                entityHuman.a(AchievementList.z);
            }
            this.world.makeSound(this, "random.pop", 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityHuman.receive(this, n);
            if (this.itemStack.count <= 0) {
                this.die();
            }
        }
    }

    public String getLocalizedName() {
        return LocaleI18n.get("item." + this.itemStack.a());
    }

    public boolean an() {
        return false;
    }
}

