/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.server.AxisAlignedBB;
import net.minecraft.server.Block;
import net.minecraft.server.BlockFluids;
import net.minecraft.server.DamageSource;
import net.minecraft.server.DataWatcher;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityLightning;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.EntityTypes;
import net.minecraft.server.EnumEntitySize;
import net.minecraft.server.ItemStack;
import net.minecraft.server.LocaleI18n;
import net.minecraft.server.Material;
import net.minecraft.server.MathHelper;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagDouble;
import net.minecraft.server.NBTTagFloat;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.StepSound;
import net.minecraft.server.Vec3D;
import net.minecraft.server.World;

public abstract class Entity {
    private static int entityCount = 0;
    public int id = entityCount++;
    public double l = 1.0;
    public boolean m = false;
    public Entity passenger;
    public Entity vehicle;
    public World world;
    public double lastX;
    public double lastY;
    public double lastZ;
    public double locX;
    public double locY;
    public double locZ;
    public double motX;
    public double motY;
    public double motZ;
    public float yaw;
    public float pitch;
    public float lastYaw;
    public float lastPitch;
    public final AxisAlignedBB boundingBox = AxisAlignedBB.a(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public boolean onGround = false;
    public boolean positionChanged;
    public boolean G;
    public boolean H = false;
    public boolean velocityChanged = false;
    protected boolean J;
    public boolean K = true;
    public boolean dead = false;
    public float height = 0.0f;
    public float width = 0.6f;
    public float length = 1.8f;
    public float P = 0.0f;
    public float Q = 0.0f;
    public float fallDistance = 0.0f;
    private int b = 1;
    public double S;
    public double T;
    public double U;
    public float V = 0.0f;
    public float W = 0.0f;
    public boolean X = false;
    public float Y = 0.0f;
    protected Random random = new Random();
    public int ticksLived = 0;
    public int maxFireTicks = 1;
    private int fireTicks = 0;
    protected boolean ac = false;
    public int noDamageTicks = 0;
    private boolean justCreated = true;
    protected boolean fireProof = false;
    protected DataWatcher datawatcher = new DataWatcher();
    private double e;
    private double f;
    public boolean ag = false;
    public int ah;
    public int ai;
    public int aj;
    public boolean ak;
    public boolean al;
    public EnumEntitySize am = EnumEntitySize.SIZE_2;

    public Entity(World world) {
        this.world = world;
        this.setPosition(0.0, 0.0, 0.0);
        this.datawatcher.a(0, (byte)0);
        this.datawatcher.a(1, (short)300);
        this.a();
    }

    protected abstract void a();

    public DataWatcher getDataWatcher() {
        return this.datawatcher;
    }

    public boolean equals(Object object) {
        if (object instanceof Entity) {
            return ((Entity)object).id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public void die() {
        this.dead = true;
    }

    protected void a(float f, float f2) {
        this.width = f;
        this.length = f2;
        float f3 = f % 2.0f;
        this.am = (double)f3 < 0.375 ? EnumEntitySize.SIZE_1 : ((double)f3 < 0.75 ? EnumEntitySize.SIZE_2 : ((double)f3 < 1.0 ? EnumEntitySize.SIZE_3 : ((double)f3 < 1.375 ? EnumEntitySize.SIZE_4 : ((double)f3 < 1.75 ? EnumEntitySize.SIZE_5 : EnumEntitySize.SIZE_6))));
    }

    protected void b(float f, float f2) {
        this.yaw = f % 360.0f;
        this.pitch = f2 % 360.0f;
    }

    public void setPosition(double d, double d2, double d3) {
        this.locX = d;
        this.locY = d2;
        this.locZ = d3;
        float f = this.width / 2.0f;
        float f2 = this.length;
        this.boundingBox.b(d - (double)f, d2 - (double)this.height + (double)this.V, d3 - (double)f, d + (double)f, d2 - (double)this.height + (double)this.V + (double)f2, d3 + (double)f);
    }

    public void h_() {
        this.z();
    }

    public void z() {
        int n;
        int n2;
        int n3;
        int n4;
        this.world.methodProfiler.a("entityBaseTick");
        if (this.vehicle != null && this.vehicle.dead) {
            this.vehicle = null;
        }
        ++this.ticksLived;
        this.P = this.Q;
        this.lastX = this.locX;
        this.lastY = this.locY;
        this.lastZ = this.locZ;
        this.lastPitch = this.pitch;
        this.lastYaw = this.yaw;
        if (this.isSprinting() && !this.H() && (n4 = this.world.getTypeId(n3 = MathHelper.floor(this.locX), n2 = MathHelper.floor(this.locY - (double)0.2f - (double)this.height), n = MathHelper.floor(this.locZ))) > 0) {
            this.world.a("tilecrack_" + n4, this.locX + ((double)this.random.nextFloat() - 0.5) * (double)this.width, this.boundingBox.b + 0.1, this.locZ + ((double)this.random.nextFloat() - 0.5) * (double)this.width, -this.motX * 4.0, 1.5, -this.motZ * 4.0);
        }
        if (this.I()) {
            if (!this.ac && !this.justCreated) {
                float f;
                float f2 = MathHelper.sqrt(this.motX * this.motX * (double)0.2f + this.motY * this.motY + this.motZ * this.motZ * (double)0.2f) * 0.2f;
                if (f2 > 1.0f) {
                    f2 = 1.0f;
                }
                this.world.makeSound(this, "random.splash", f2, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                float f3 = MathHelper.floor(this.boundingBox.b);
                n = 0;
                while ((float)n < 1.0f + this.width * 20.0f) {
                    float f4 = (this.random.nextFloat() * 2.0f - 1.0f) * this.width;
                    f = (this.random.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.world.a("bubble", this.locX + (double)f4, f3 + 1.0f, this.locZ + (double)f, this.motX, this.motY - (double)(this.random.nextFloat() * 0.2f), this.motZ);
                    ++n;
                }
                n = 0;
                while ((float)n < 1.0f + this.width * 20.0f) {
                    float f5 = (this.random.nextFloat() * 2.0f - 1.0f) * this.width;
                    f = (this.random.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.world.a("splash", this.locX + (double)f5, f3 + 1.0f, this.locZ + (double)f, this.motX, this.motY, this.motZ);
                    ++n;
                }
            }
            this.fallDistance = 0.0f;
            this.ac = true;
            this.fireTicks = 0;
        } else {
            this.ac = false;
        }
        if (this.world.isStatic) {
            this.fireTicks = 0;
        } else if (this.fireTicks > 0) {
            if (this.fireProof) {
                this.fireTicks -= 4;
                if (this.fireTicks < 0) {
                    this.fireTicks = 0;
                }
            } else {
                if (this.fireTicks % 20 == 0) {
                    this.damageEntity(DamageSource.BURN, 1);
                }
                --this.fireTicks;
            }
        }
        if (this.J()) {
            this.A();
            this.fallDistance *= 0.5f;
        }
        if (this.locY < -64.0) {
            this.C();
        }
        if (!this.world.isStatic) {
            this.a(0, this.fireTicks > 0);
            this.a(2, this.vehicle != null);
        }
        this.justCreated = false;
        this.world.methodProfiler.b();
    }

    protected void A() {
        if (!this.fireProof) {
            this.damageEntity(DamageSource.LAVA, 4);
            this.setOnFire(15);
        }
    }

    public void setOnFire(int n) {
        int n2 = n * 20;
        if (this.fireTicks < n2) {
            this.fireTicks = n2;
        }
    }

    public void extinguish() {
        this.fireTicks = 0;
    }

    protected void C() {
        this.die();
    }

    public boolean c(double d, double d2, double d3) {
        AxisAlignedBB axisAlignedBB = this.boundingBox.c(d, d2, d3);
        List list = this.world.getCubes(this, axisAlignedBB);
        if (!list.isEmpty()) {
            return false;
        }
        return !this.world.containsLiquid(axisAlignedBB);
    }

    public void move(double d, double d2, double d3) {
        int n;
        double d4;
        double d5;
        boolean bl;
        if (this.X) {
            this.boundingBox.d(d, d2, d3);
            this.locX = (this.boundingBox.a + this.boundingBox.d) / 2.0;
            this.locY = this.boundingBox.b + (double)this.height - (double)this.V;
            this.locZ = (this.boundingBox.c + this.boundingBox.f) / 2.0;
            return;
        }
        this.world.methodProfiler.a("move");
        this.V *= 0.4f;
        double d6 = this.locX;
        double d7 = this.locZ;
        if (this.J) {
            this.J = false;
            d *= 0.25;
            d2 *= (double)0.05f;
            d3 *= 0.25;
            this.motX = 0.0;
            this.motY = 0.0;
            this.motZ = 0.0;
        }
        double d8 = d;
        double d9 = d2;
        double d10 = d3;
        AxisAlignedBB axisAlignedBB = this.boundingBox.clone();
        boolean bl2 = bl = this.onGround && this.isSneaking() && this instanceof EntityHuman;
        if (bl) {
            double d11 = 0.05;
            while (d != 0.0 && this.world.getCubes(this, this.boundingBox.c(d, -1.0, 0.0)).isEmpty()) {
                d = d < d11 && d >= -d11 ? 0.0 : (d > 0.0 ? (d -= d11) : (d += d11));
                d8 = d;
            }
            while (d3 != 0.0 && this.world.getCubes(this, this.boundingBox.c(0.0, -1.0, d3)).isEmpty()) {
                d3 = d3 < d11 && d3 >= -d11 ? 0.0 : (d3 > 0.0 ? (d3 -= d11) : (d3 += d11));
                d10 = d3;
            }
            while (d != 0.0 && d3 != 0.0 && this.world.getCubes(this, this.boundingBox.c(d, -1.0, d3)).isEmpty()) {
                d = d < d11 && d >= -d11 ? 0.0 : (d > 0.0 ? (d -= d11) : (d += d11));
                d3 = d3 < d11 && d3 >= -d11 ? 0.0 : (d3 > 0.0 ? (d3 -= d11) : (d3 += d11));
                d8 = d;
                d10 = d3;
            }
        }
        List list = this.world.getCubes(this, this.boundingBox.a(d, d2, d3));
        for (Iterator iterator : list) {
            d2 = ((AxisAlignedBB)((Object)iterator)).b(this.boundingBox, d2);
        }
        this.boundingBox.d(0.0, d2, 0.0);
        if (!this.K && d9 != d2) {
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
        }
        boolean bl3 = this.onGround || d9 != d2 && d9 < 0.0;
        for (AxisAlignedBB axisAlignedBB2 : list) {
            d = axisAlignedBB2.a(this.boundingBox, d);
        }
        this.boundingBox.d(d, 0.0, 0.0);
        if (!this.K && d8 != d) {
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
        }
        for (AxisAlignedBB axisAlignedBB2 : list) {
            d3 = axisAlignedBB2.c(this.boundingBox, d3);
        }
        this.boundingBox.d(0.0, 0.0, d3);
        if (!this.K && d10 != d3) {
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
        }
        if (this.W > 0.0f && bl3 && (bl || this.V < 0.05f) && (d8 != d || d10 != d3)) {
            d5 = d;
            d4 = d2;
            double d12 = d3;
            d = d8;
            d2 = this.W;
            d3 = d10;
            AxisAlignedBB axisAlignedBB3 = this.boundingBox.clone();
            this.boundingBox.c(axisAlignedBB);
            list = this.world.getCubes(this, this.boundingBox.a(d, d2, d3));
            for (AxisAlignedBB axisAlignedBB4 : list) {
                d2 = axisAlignedBB4.b(this.boundingBox, d2);
            }
            this.boundingBox.d(0.0, d2, 0.0);
            if (!this.K && d9 != d2) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            }
            for (AxisAlignedBB axisAlignedBB4 : list) {
                d = axisAlignedBB4.a(this.boundingBox, d);
            }
            this.boundingBox.d(d, 0.0, 0.0);
            if (!this.K && d8 != d) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            }
            for (AxisAlignedBB axisAlignedBB4 : list) {
                d3 = axisAlignedBB4.c(this.boundingBox, d3);
            }
            this.boundingBox.d(0.0, 0.0, d3);
            if (!this.K && d10 != d3) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            }
            if (!this.K && d9 != d2) {
                d3 = 0.0;
                d2 = 0.0;
                d = 0.0;
            } else {
                d2 = -this.W;
                for (AxisAlignedBB axisAlignedBB4 : list) {
                    d2 = axisAlignedBB4.b(this.boundingBox, d2);
                }
                this.boundingBox.d(0.0, d2, 0.0);
            }
            if (d5 * d5 + d12 * d12 >= d * d + d3 * d3) {
                d = d5;
                d2 = d4;
                d3 = d12;
                this.boundingBox.c(axisAlignedBB3);
            } else {
                double d13 = this.boundingBox.b - (double)((int)this.boundingBox.b);
                if (d13 > 0.0) {
                    this.V = (float)((double)this.V + (d13 + 0.01));
                }
            }
        }
        this.world.methodProfiler.b();
        this.world.methodProfiler.a("rest");
        this.locX = (this.boundingBox.a + this.boundingBox.d) / 2.0;
        this.locY = this.boundingBox.b + (double)this.height - (double)this.V;
        this.locZ = (this.boundingBox.c + this.boundingBox.f) / 2.0;
        this.positionChanged = d8 != d || d10 != d3;
        this.G = d9 != d2;
        this.onGround = d9 != d2 && d9 < 0.0;
        this.H = this.positionChanged || this.G;
        this.a(d2, this.onGround);
        if (d8 != d) {
            this.motX = 0.0;
        }
        if (d9 != d2) {
            this.motY = 0.0;
        }
        if (d10 != d3) {
            this.motZ = 0.0;
        }
        d5 = this.locX - d6;
        d4 = this.locZ - d7;
        if (this.e_() && !bl && this.vehicle == null) {
            int n2;
            int n3;
            this.Q = (float)((double)this.Q + (double)MathHelper.sqrt(d5 * d5 + d4 * d4) * 0.6);
            n = MathHelper.floor(this.locX);
            int n4 = this.world.getTypeId(n, n3 = MathHelper.floor(this.locY - (double)0.2f - (double)this.height), n2 = MathHelper.floor(this.locZ));
            if (n4 == 0 && this.world.getTypeId(n, n3 - 1, n2) == Block.FENCE.id) {
                n4 = this.world.getTypeId(n, n3 - 1, n2);
            }
            if (this.Q > (float)this.b && n4 > 0) {
                this.b = (int)this.Q + 1;
                this.a(n, n3, n2, n4);
                Block.byId[n4].b(this.world, n, n3, n2, this);
            }
        }
        this.D();
        n = this.G();
        if (this.world.e(this.boundingBox.shrink(0.001, 0.001, 0.001))) {
            this.burn(1);
            if (n == 0) {
                ++this.fireTicks;
                if (this.fireTicks == 0) {
                    this.setOnFire(8);
                }
            }
        } else if (this.fireTicks <= 0) {
            this.fireTicks = -this.maxFireTicks;
        }
        if (n != 0 && this.fireTicks > 0) {
            this.world.makeSound(this, "random.fizz", 0.7f, 1.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
            this.fireTicks = -this.maxFireTicks;
        }
        this.world.methodProfiler.b();
    }

    protected void D() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = MathHelper.floor(this.boundingBox.a + 0.001);
        if (this.world.c(n6, n5 = MathHelper.floor(this.boundingBox.b + 0.001), n4 = MathHelper.floor(this.boundingBox.c + 0.001), n3 = MathHelper.floor(this.boundingBox.d - 0.001), n2 = MathHelper.floor(this.boundingBox.e - 0.001), n = MathHelper.floor(this.boundingBox.f - 0.001))) {
            for (int i = n6; i <= n3; ++i) {
                for (int j = n5; j <= n2; ++j) {
                    for (int k = n4; k <= n; ++k) {
                        int n7 = this.world.getTypeId(i, j, k);
                        if (n7 <= 0) continue;
                        Block.byId[n7].a(this.world, i, j, k, this);
                    }
                }
            }
        }
    }

    protected void a(int n, int n2, int n3, int n4) {
        StepSound stepSound = Block.byId[n4].stepSound;
        if (this.world.getTypeId(n, n2 + 1, n3) == Block.SNOW.id) {
            stepSound = Block.SNOW.stepSound;
            this.world.makeSound(this, stepSound.getName(), stepSound.getVolume1() * 0.15f, stepSound.getVolume2());
        } else if (!Block.byId[n4].material.isLiquid()) {
            this.world.makeSound(this, stepSound.getName(), stepSound.getVolume1() * 0.15f, stepSound.getVolume2());
        }
    }

    protected boolean e_() {
        return true;
    }

    protected void a(double d, boolean bl) {
        if (bl) {
            if (this.fallDistance > 0.0f) {
                if (this instanceof EntityLiving) {
                    int n;
                    int n2;
                    int n3 = MathHelper.floor(this.locX);
                    int n4 = this.world.getTypeId(n3, n2 = MathHelper.floor(this.locY - (double)0.2f - (double)this.height), n = MathHelper.floor(this.locZ));
                    if (n4 == 0 && this.world.getTypeId(n3, n2 - 1, n) == Block.FENCE.id) {
                        n4 = this.world.getTypeId(n3, n2 - 1, n);
                    }
                    if (n4 > 0) {
                        Block.byId[n4].a(this.world, n3, n2, n, this, this.fallDistance);
                    }
                }
                this.a(this.fallDistance);
                this.fallDistance = 0.0f;
            }
        } else if (d < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - d);
        }
    }

    public AxisAlignedBB E() {
        return null;
    }

    protected void burn(int n) {
        if (!this.fireProof) {
            this.damageEntity(DamageSource.FIRE, n);
        }
    }

    public final boolean isFireproof() {
        return this.fireProof;
    }

    protected void a(float f) {
        if (this.passenger != null) {
            this.passenger.a(f);
        }
    }

    public boolean G() {
        return this.ac || this.world.B(MathHelper.floor(this.locX), MathHelper.floor(this.locY), MathHelper.floor(this.locZ));
    }

    public boolean H() {
        return this.ac;
    }

    public boolean I() {
        return this.world.a(this.boundingBox.grow(0.0, -0.4f, 0.0).shrink(0.001, 0.001, 0.001), Material.WATER, this);
    }

    public boolean a(Material material) {
        int n;
        int n2;
        double d = this.locY + (double)this.getHeadHeight();
        int n3 = MathHelper.floor(this.locX);
        int n4 = this.world.getTypeId(n3, n2 = MathHelper.d(MathHelper.floor(d)), n = MathHelper.floor(this.locZ));
        if (n4 != 0 && Block.byId[n4].material == material) {
            float f = BlockFluids.d(this.world.getData(n3, n2, n)) - 0.11111111f;
            float f2 = (float)(n2 + 1) - f;
            return d < (double)f2;
        }
        return false;
    }

    public float getHeadHeight() {
        return 0.0f;
    }

    public boolean J() {
        return this.world.a(this.boundingBox.grow(-0.1f, -0.4f, -0.1f), Material.LAVA);
    }

    public void a(float f, float f2, float f3) {
        float f4 = f * f + f2 * f2;
        if (f4 < 1.0E-4f) {
            return;
        }
        if ((f4 = MathHelper.c(f4)) < 1.0f) {
            f4 = 1.0f;
        }
        f4 = f3 / f4;
        float f5 = MathHelper.sin(this.yaw * (float)Math.PI / 180.0f);
        float f6 = MathHelper.cos(this.yaw * (float)Math.PI / 180.0f);
        this.motX += (double)((f *= f4) * f6 - (f2 *= f4) * f5);
        this.motZ += (double)(f2 * f6 + f * f5);
    }

    public float c(float f) {
        int n;
        int n2 = MathHelper.floor(this.locX);
        if (this.world.isLoaded(n2, 0, n = MathHelper.floor(this.locZ))) {
            double d = (this.boundingBox.e - this.boundingBox.b) * 0.66;
            int n3 = MathHelper.floor(this.locY - (double)this.height + d);
            return this.world.o(n2, n3, n);
        }
        return 0.0f;
    }

    public void spawnIn(World world) {
        this.world = world;
    }

    public void setLocation(double d, double d2, double d3, float f, float f2) {
        this.lastX = this.locX = d;
        this.lastY = this.locY = d2;
        this.lastZ = this.locZ = d3;
        this.lastYaw = this.yaw = f;
        this.lastPitch = this.pitch = f2;
        this.V = 0.0f;
        double d4 = this.lastYaw - f;
        if (d4 < -180.0) {
            this.lastYaw += 360.0f;
        }
        if (d4 >= 180.0) {
            this.lastYaw -= 360.0f;
        }
        this.setPosition(this.locX, this.locY, this.locZ);
        this.b(f, f2);
    }

    public void setPositionRotation(double d, double d2, double d3, float f, float f2) {
        this.lastX = this.locX = d;
        this.S = this.locX;
        this.lastY = this.locY = d2 + (double)this.height;
        this.T = this.locY;
        this.lastZ = this.locZ = d3;
        this.U = this.locZ;
        this.yaw = f;
        this.pitch = f2;
        this.setPosition(this.locX, this.locY, this.locZ);
    }

    public float d(Entity entity) {
        float f = (float)(this.locX - entity.locX);
        float f2 = (float)(this.locY - entity.locY);
        float f3 = (float)(this.locZ - entity.locZ);
        return MathHelper.c(f * f + f2 * f2 + f3 * f3);
    }

    public double e(double d, double d2, double d3) {
        double d4 = this.locX - d;
        double d5 = this.locY - d2;
        double d6 = this.locZ - d3;
        return d4 * d4 + d5 * d5 + d6 * d6;
    }

    public double f(double d, double d2, double d3) {
        double d4 = this.locX - d;
        double d5 = this.locY - d2;
        double d6 = this.locZ - d3;
        return MathHelper.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
    }

    public double e(Entity entity) {
        double d = this.locX - entity.locX;
        double d2 = this.locY - entity.locY;
        double d3 = this.locZ - entity.locZ;
        return d * d + d2 * d2 + d3 * d3;
    }

    public void b_(EntityHuman entityHuman) {
    }

    public void collide(Entity entity) {
        if (entity.passenger == this || entity.vehicle == this) {
            return;
        }
        double d = entity.locX - this.locX;
        double d2 = entity.locZ - this.locZ;
        double d3 = MathHelper.a(d, d2);
        if (d3 >= (double)0.01f) {
            d3 = MathHelper.sqrt(d3);
            d /= d3;
            d2 /= d3;
            double d4 = 1.0 / d3;
            if (d4 > 1.0) {
                d4 = 1.0;
            }
            d *= d4;
            d2 *= d4;
            d *= (double)0.05f;
            d2 *= (double)0.05f;
            this.g(-(d *= (double)(1.0f - this.Y)), 0.0, -(d2 *= (double)(1.0f - this.Y)));
            entity.g(d, 0.0, d2);
        }
    }

    public void g(double d, double d2, double d3) {
        this.motX += d;
        this.motY += d2;
        this.motZ += d3;
        this.al = true;
    }

    protected void K() {
        this.velocityChanged = true;
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        this.K();
        return false;
    }

    public boolean L() {
        return false;
    }

    public boolean M() {
        return false;
    }

    public void c(Entity entity, int n) {
    }

    public boolean c(NBTTagCompound nBTTagCompound) {
        String string = this.Q();
        if (this.dead || string == null) {
            return false;
        }
        nBTTagCompound.setString("id", string);
        this.d(nBTTagCompound);
        return true;
    }

    public void d(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.set("Pos", this.a(this.locX, this.locY + (double)this.V, this.locZ));
        nBTTagCompound.set("Motion", this.a(this.motX, this.motY, this.motZ));
        nBTTagCompound.set("Rotation", this.a(new float[]{this.yaw, this.pitch}));
        nBTTagCompound.setFloat("FallDistance", this.fallDistance);
        nBTTagCompound.setShort("Fire", (short)this.fireTicks);
        nBTTagCompound.setShort("Air", (short)this.getAirTicks());
        nBTTagCompound.setBoolean("OnGround", this.onGround);
        this.b(nBTTagCompound);
    }

    public void e(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList = nBTTagCompound.getList("Pos");
        NBTTagList nBTTagList2 = nBTTagCompound.getList("Motion");
        NBTTagList nBTTagList3 = nBTTagCompound.getList("Rotation");
        this.motX = ((NBTTagDouble)nBTTagList2.get((int)0)).data;
        this.motY = ((NBTTagDouble)nBTTagList2.get((int)1)).data;
        this.motZ = ((NBTTagDouble)nBTTagList2.get((int)2)).data;
        if (Math.abs(this.motX) > 10.0) {
            this.motX = 0.0;
        }
        if (Math.abs(this.motY) > 10.0) {
            this.motY = 0.0;
        }
        if (Math.abs(this.motZ) > 10.0) {
            this.motZ = 0.0;
        }
        this.S = this.locX = ((NBTTagDouble)nBTTagList.get((int)0)).data;
        this.lastX = this.locX;
        this.T = this.locY = ((NBTTagDouble)nBTTagList.get((int)1)).data;
        this.lastY = this.locY;
        this.U = this.locZ = ((NBTTagDouble)nBTTagList.get((int)2)).data;
        this.lastZ = this.locZ;
        this.lastYaw = this.yaw = ((NBTTagFloat)nBTTagList3.get((int)0)).data;
        this.lastPitch = this.pitch = ((NBTTagFloat)nBTTagList3.get((int)1)).data;
        this.fallDistance = nBTTagCompound.getFloat("FallDistance");
        this.fireTicks = nBTTagCompound.getShort("Fire");
        this.setAirTicks(nBTTagCompound.getShort("Air"));
        this.onGround = nBTTagCompound.getBoolean("OnGround");
        this.setPosition(this.locX, this.locY, this.locZ);
        this.b(this.yaw, this.pitch);
        this.a(nBTTagCompound);
    }

    protected final String Q() {
        return EntityTypes.b(this);
    }

    protected abstract void a(NBTTagCompound var1);

    protected abstract void b(NBTTagCompound var1);

    protected NBTTagList a(double ... dArray) {
        NBTTagList nBTTagList = new NBTTagList();
        for (double d : dArray) {
            nBTTagList.add(new NBTTagDouble(null, d));
        }
        return nBTTagList;
    }

    protected NBTTagList a(float ... fArray) {
        NBTTagList nBTTagList = new NBTTagList();
        for (float f : fArray) {
            nBTTagList.add(new NBTTagFloat(null, f));
        }
        return nBTTagList;
    }

    public EntityItem b(int n, int n2) {
        return this.a(n, n2, 0.0f);
    }

    public EntityItem a(int n, int n2, float f) {
        return this.a(new ItemStack(n, n2, 0), f);
    }

    public EntityItem a(ItemStack itemStack, float f) {
        EntityItem entityItem = new EntityItem(this.world, this.locX, this.locY + (double)f, this.locZ, itemStack);
        entityItem.pickupDelay = 10;
        this.world.addEntity(entityItem);
        return entityItem;
    }

    public boolean isAlive() {
        return !this.dead;
    }

    public boolean inBlock() {
        for (int i = 0; i < 8; ++i) {
            int n;
            int n2;
            float f = ((float)((i >> 0) % 2) - 0.5f) * this.width * 0.8f;
            float f2 = ((float)((i >> 1) % 2) - 0.5f) * 0.1f;
            float f3 = ((float)((i >> 2) % 2) - 0.5f) * this.width * 0.8f;
            int n3 = MathHelper.floor(this.locX + (double)f);
            if (!this.world.s(n3, n2 = MathHelper.floor(this.locY + (double)this.getHeadHeight() + (double)f2), n = MathHelper.floor(this.locZ + (double)f3))) continue;
            return true;
        }
        return false;
    }

    public boolean c(EntityHuman entityHuman) {
        return false;
    }

    public AxisAlignedBB g(Entity entity) {
        return null;
    }

    public void U() {
        if (this.vehicle.dead) {
            this.vehicle = null;
            return;
        }
        this.motX = 0.0;
        this.motY = 0.0;
        this.motZ = 0.0;
        this.h_();
        if (this.vehicle == null) {
            return;
        }
        this.vehicle.V();
        this.f += (double)(this.vehicle.yaw - this.vehicle.lastYaw);
        this.e += (double)(this.vehicle.pitch - this.vehicle.lastPitch);
        while (this.f >= 180.0) {
            this.f -= 360.0;
        }
        while (this.f < -180.0) {
            this.f += 360.0;
        }
        while (this.e >= 180.0) {
            this.e -= 360.0;
        }
        while (this.e < -180.0) {
            this.e += 360.0;
        }
        double d = this.f * 0.5;
        double d2 = this.e * 0.5;
        float f = 10.0f;
        if (d > (double)f) {
            d = f;
        }
        if (d < (double)(-f)) {
            d = -f;
        }
        if (d2 > (double)f) {
            d2 = f;
        }
        if (d2 < (double)(-f)) {
            d2 = -f;
        }
        this.f -= d;
        this.e -= d2;
        this.yaw = (float)((double)this.yaw + d);
        this.pitch = (float)((double)this.pitch + d2);
    }

    public void V() {
        if (!(this.passenger instanceof EntityHuman) || !((EntityHuman)this.passenger).bF()) {
            this.passenger.S = this.passenger.locX;
            this.passenger.T = this.passenger.locY;
            this.passenger.U = this.passenger.locZ;
        }
        this.passenger.setPosition(this.locX, this.locY + this.X() + this.passenger.W(), this.locZ);
    }

    public double W() {
        return this.height;
    }

    public double X() {
        return (double)this.length * 0.75;
    }

    public void mount(Entity entity) {
        this.e = 0.0;
        this.f = 0.0;
        if (entity == null) {
            if (this.vehicle != null) {
                this.setPositionRotation(this.vehicle.locX, this.vehicle.boundingBox.b + (double)this.vehicle.length, this.vehicle.locZ, this.yaw, this.pitch);
                this.vehicle.passenger = null;
            }
            this.vehicle = null;
            return;
        }
        if (this.vehicle == entity) {
            this.h(entity);
            this.vehicle.passenger = null;
            this.vehicle = null;
            return;
        }
        if (this.vehicle != null) {
            this.vehicle.passenger = null;
        }
        if (entity.passenger != null) {
            entity.passenger.vehicle = null;
        }
        this.vehicle = entity;
        entity.passenger = this;
    }

    public void h(Entity entity) {
        double d = entity.locX;
        double d2 = entity.boundingBox.b + (double)entity.length;
        double d3 = entity.locZ;
        for (double d4 = -1.5; d4 < 2.0; d4 += 1.5) {
            for (double d5 = -1.5; d5 < 2.0; d5 += 1.5) {
                if (d4 == 0.0 && d5 == 0.0) continue;
                int n = (int)(this.locX + d4);
                int n2 = (int)(this.locZ + d5);
                AxisAlignedBB axisAlignedBB = this.boundingBox.c(d4, 1.0, d5);
                if (!this.world.a(axisAlignedBB).isEmpty()) continue;
                if (this.world.t(n, (int)this.locY, n2)) {
                    this.setPositionRotation(this.locX + d4, this.locY + 1.0, this.locZ + d5, this.yaw, this.pitch);
                    return;
                }
                if (!this.world.t(n, (int)this.locY - 1, n2) && this.world.getMaterial(n, (int)this.locY - 1, n2) != Material.WATER) continue;
                d = this.locX + d4;
                d2 = this.locY + 1.0;
                d3 = this.locZ + d5;
            }
        }
        this.setPositionRotation(d, d2, d3, this.yaw, this.pitch);
    }

    public float Y() {
        return 0.1f;
    }

    public Vec3D Z() {
        return null;
    }

    public void aa() {
    }

    public ItemStack[] getEquipment() {
        return null;
    }

    public boolean isBurning() {
        return this.fireTicks > 0 || this.f(0);
    }

    public boolean isSneaking() {
        return this.f(1);
    }

    public void setSneaking(boolean bl) {
        this.a(1, bl);
    }

    public boolean isSprinting() {
        return this.f(3);
    }

    public void setSprinting(boolean bl) {
        this.a(3, bl);
    }

    public void c(boolean bl) {
        this.a(4, bl);
    }

    protected boolean f(int n) {
        return (this.datawatcher.getByte(0) & 1 << n) != 0;
    }

    protected void a(int n, boolean bl) {
        byte by = this.datawatcher.getByte(0);
        if (bl) {
            this.datawatcher.watch(0, (byte)(by | 1 << n));
        } else {
            this.datawatcher.watch(0, (byte)(by & ~(1 << n)));
        }
    }

    public int getAirTicks() {
        return this.datawatcher.getShort(1);
    }

    public void setAirTicks(int n) {
        this.datawatcher.watch(1, (short)n);
    }

    public void a(EntityLightning entityLightning) {
        this.burn(5);
        ++this.fireTicks;
        if (this.fireTicks == 0) {
            this.setOnFire(8);
        }
    }

    public void a(EntityLiving entityLiving) {
    }

    protected boolean i(double d, double d2, double d3) {
        int n = MathHelper.floor(d);
        int n2 = MathHelper.floor(d2);
        int n3 = MathHelper.floor(d3);
        double d4 = d - (double)n;
        double d5 = d2 - (double)n2;
        double d6 = d3 - (double)n3;
        if (this.world.s(n, n2, n3)) {
            boolean bl = !this.world.s(n - 1, n2, n3);
            boolean bl2 = !this.world.s(n + 1, n2, n3);
            boolean bl3 = !this.world.s(n, n2 - 1, n3);
            boolean bl4 = !this.world.s(n, n2 + 1, n3);
            boolean bl5 = !this.world.s(n, n2, n3 - 1);
            boolean bl6 = !this.world.s(n, n2, n3 + 1);
            int n4 = -1;
            double d7 = 9999.0;
            if (bl && d4 < d7) {
                d7 = d4;
                n4 = 0;
            }
            if (bl2 && 1.0 - d4 < d7) {
                d7 = 1.0 - d4;
                n4 = 1;
            }
            if (bl3 && d5 < d7) {
                d7 = d5;
                n4 = 2;
            }
            if (bl4 && 1.0 - d5 < d7) {
                d7 = 1.0 - d5;
                n4 = 3;
            }
            if (bl5 && d6 < d7) {
                d7 = d6;
                n4 = 4;
            }
            if (bl6 && 1.0 - d6 < d7) {
                d7 = 1.0 - d6;
                n4 = 5;
            }
            float f = this.random.nextFloat() * 0.2f + 0.1f;
            if (n4 == 0) {
                this.motX = -f;
            }
            if (n4 == 1) {
                this.motX = f;
            }
            if (n4 == 2) {
                this.motY = -f;
            }
            if (n4 == 3) {
                this.motY = f;
            }
            if (n4 == 4) {
                this.motZ = -f;
            }
            if (n4 == 5) {
                this.motZ = f;
            }
            return true;
        }
        return false;
    }

    public void aj() {
        this.J = true;
        this.fallDistance = 0.0f;
    }

    public String getLocalizedName() {
        String string = EntityTypes.b(this);
        if (string == null) {
            string = "generic";
        }
        return LocaleI18n.get("entity." + string + ".name");
    }

    public Entity[] al() {
        return null;
    }

    public boolean i(Entity entity) {
        return this == entity;
    }

    public float am() {
        return 0.0f;
    }

    public boolean an() {
        return true;
    }

    public String toString() {
        return String.format("%s['%s'/%d, l='%s', x=%.2f, y=%.2f, z=%.2f]", this.getClass().getSimpleName(), this.getLocalizedName(), this.id, this.world == null ? "~NULL~" : this.world.getWorldData().getName(), this.locX, this.locY, this.locZ);
    }
}

