/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.MessageBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerUtil;
import io.netty.channel.ChannelInboundMessageHandler;
import io.netty.channel.ChannelStateHandlerAdapter;
import io.netty.util.Signal;
import io.netty.util.internal.TypeParameterMatcher;

public abstract class ChannelInboundMessageHandlerAdapter<I>
extends ChannelStateHandlerAdapter
implements ChannelInboundMessageHandler<I>,
ChannelHandlerUtil.SingleInboundMessageHandler<I> {
    protected static final Signal ABORT = ChannelHandlerUtil.ABORT;
    private final TypeParameterMatcher msgMatcher;

    protected ChannelInboundMessageHandlerAdapter() {
        this.msgMatcher = TypeParameterMatcher.find(this, ChannelInboundMessageHandlerAdapter.class, "I");
    }

    protected ChannelInboundMessageHandlerAdapter(Class<? extends I> inboundMessageType) {
        this.msgMatcher = TypeParameterMatcher.get(inboundMessageType);
    }

    @Override
    public MessageBuf<I> newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return Unpooled.messageBuffer();
    }

    @Override
    public void freeInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        ctx.inboundMessageBuffer().release();
    }

    @Override
    public final void inboundBufferUpdated(ChannelHandlerContext ctx) throws Exception {
        ChannelHandlerUtil.handleInboundBufferUpdated(ctx, this);
    }

    @Override
    public boolean acceptInboundMessage(Object msg) throws Exception {
        return this.msgMatcher.match(msg);
    }

    @Override
    public boolean beginMessageReceived(ChannelHandlerContext ctx) throws Exception {
        return true;
    }

    @Override
    public void endMessageReceived(ChannelHandlerContext ctx) throws Exception {
    }
}

