/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.util.AsyncHttpProviderUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyServer {
    private final List<String> nonProxyHosts = new ArrayList<String>();
    private final Protocol protocol;
    private final String host;
    private final String principal;
    private final String password;
    private final int port;
    private final URI uri;
    private String encoding = "UTF-8";
    private String ntlmDomain = System.getProperty("http.auth.ntlm.domain", "");

    public ProxyServer(Protocol protocol, String host, int port, String principal, String password) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.principal = principal;
        this.password = password;
        this.uri = AsyncHttpProviderUtils.createUri(this.toString());
    }

    public ProxyServer(String host, int port, String principal, String password) {
        this(Protocol.HTTP, host, port, principal, password);
    }

    public ProxyServer(Protocol protocol, String host, int port) {
        this(protocol, host, port, null, null);
    }

    public ProxyServer(String host, int port) {
        this(Protocol.HTTP, host, port, null, null);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getProtocolAsString() {
        return this.protocol.toString();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getPassword() {
        return this.password;
    }

    public URI getURI() {
        return this.uri;
    }

    public ProxyServer setEncoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public ProxyServer addNonProxyHost(String uri) {
        this.nonProxyHosts.add(uri);
        return this;
    }

    public ProxyServer removeNonProxyHost(String uri) {
        this.nonProxyHosts.remove(uri);
        return this;
    }

    public List<String> getNonProxyHosts() {
        return Collections.unmodifiableList(this.nonProxyHosts);
    }

    public ProxyServer setNtlmDomain(String ntlmDomain) {
        this.ntlmDomain = ntlmDomain;
        return this;
    }

    public String getNtlmDomain() {
        return this.ntlmDomain;
    }

    public String toString() {
        return (Object)((Object)this.protocol) + "://" + this.host + ":" + this.port;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocol {
        HTTP("http"),
        HTTPS("https"),
        NTLM("NTLM"),
        KERBEROS("KERBEROS"),
        SPNEGO("SPNEGO");

        private final String protocol;

        private Protocol(String protocol) {
            this.protocol = protocol;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String toString() {
            return this.getProtocol();
        }
    }
}

