/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.netty.channel.Channel;
import java.beans.ConstructorProperties;
import java.util.Objects;
import net.md_5.bungee.EntityMap;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.scoreboard.Objective;
import net.md_5.bungee.api.scoreboard.Position;
import net.md_5.bungee.api.scoreboard.Score;
import net.md_5.bungee.api.scoreboard.Team;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.packet.Packet0KeepAlive;
import net.md_5.bungee.packet.Packet3Chat;
import net.md_5.bungee.packet.PacketC9PlayerListItem;
import net.md_5.bungee.packet.PacketCEScoreboardObjective;
import net.md_5.bungee.packet.PacketCFScoreboardScore;
import net.md_5.bungee.packet.PacketD0DisplayScoreboard;
import net.md_5.bungee.packet.PacketD1Team;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.packet.PacketFFKick;
import net.md_5.bungee.packet.PacketHandler;

public class DownstreamBridge
extends PacketHandler {
    private final ProxyServer bungee;
    private final UserConnection con;
    private final ServerConnection server;

    @Override
    public void exception(Throwable t) throws Exception {
        ServerInfo def = this.bungee.getServerInfo(this.con.getPendingConnection().getListener().getFallbackServer());
        if (this.server.getInfo() != def) {
            this.con.connectNow(def);
            this.con.sendMessage((Object)((Object)ChatColor.RED) + "The server you were previously on went down, you have been connected to the lobby");
        } else {
            this.con.disconnect(Util.exception(t));
        }
    }

    @Override
    public void disconnected(Channel channel) throws Exception {
        this.server.getInfo().removePlayer(this.con);
        this.bungee.getReconnectHandler().setServer(this.con);
        if (!this.server.isObsolete()) {
            this.con.disconnect("[Proxy] Lost connection to server D:");
        }
    }

    @Override
    public void handle(byte[] buf) throws Exception {
        EntityMap.rewrite(buf, this.con.serverEntityId, this.con.clientEntityId);
        this.con.ch.write(buf);
    }

    @Override
    public void handle(Packet0KeepAlive alive) throws Exception {
        this.con.trackingPingId = alive.id;
    }

    @Override
    public void handle(Packet3Chat chat) throws Exception {
        ChatEvent chatEvent = new ChatEvent(this.con.getServer(), this.con, chat.message);
        this.bungee.getPluginManager().callEvent(chatEvent);
        if (chatEvent.isCancelled()) {
            throw new CancelSendSignal();
        }
    }

    @Override
    public void handle(PacketC9PlayerListItem playerList) throws Exception {
        if (!this.bungee.getTabListHandler().onListUpdate(this.con, playerList.username, playerList.online, playerList.ping)) {
            throw new CancelSendSignal();
        }
    }

    @Override
    public void handle(PacketCEScoreboardObjective objective) throws Exception {
        switch (objective.action) {
            case 0: {
                this.con.serverSentScoreboard.addObjective(new Objective(objective.name, objective.text));
                break;
            }
            case 1: {
                this.con.serverSentScoreboard.removeObjective(objective.name);
            }
        }
    }

    @Override
    public void handle(PacketCFScoreboardScore score) throws Exception {
        switch (score.action) {
            case 0: {
                Score s = new Score(score.itemName, score.scoreName, score.value);
                this.con.serverSentScoreboard.removeScore(score.itemName);
                this.con.serverSentScoreboard.addScore(s);
                break;
            }
            case 1: {
                this.con.serverSentScoreboard.removeScore(score.itemName);
            }
        }
    }

    @Override
    public void handle(PacketD0DisplayScoreboard displayScoreboard) throws Exception {
        this.con.serverSentScoreboard.setName(displayScoreboard.name);
        this.con.serverSentScoreboard.setPosition(Position.values()[displayScoreboard.position]);
    }

    @Override
    public void handle(PacketD1Team team) throws Exception {
        Team t;
        if (team.mode == 1) {
            this.con.serverSentScoreboard.removeTeam(team.name);
            return;
        }
        if (team.mode == 0) {
            t = new Team(team.name);
            this.con.serverSentScoreboard.addTeam(t);
        } else {
            t = this.con.serverSentScoreboard.getTeam(team.name);
        }
        if (t != null) {
            if (team.mode == 0 || team.mode == 2) {
                t.setDisplayName(team.displayName);
                t.setPrefix(team.prefix);
                t.setSuffix(team.suffix);
                t.setFriendlyMode(team.friendlyFire);
            }
            for (String s : team.players) {
                if (team.mode == 0 || team.mode == 3) {
                    t.addPlayer(s);
                    continue;
                }
                t.removePlayer(s);
            }
        }
    }

    @Override
    public void handle(PacketFAPluginMessage pluginMessage) throws Exception {
        ByteArrayDataInput in = ByteStreams.newDataInput(pluginMessage.data);
        PluginMessageEvent event = new PluginMessageEvent(this.con.getServer(), this.con, pluginMessage.tag, (byte[])pluginMessage.data.clone());
        if (this.bungee.getPluginManager().callEvent(event).isCancelled()) {
            throw new CancelSendSignal();
        }
        if (pluginMessage.tag.equals("MC|TPack") && this.con.getPendingConnection().getListener().getTexturePack() != null) {
            throw new CancelSendSignal();
        }
        if (pluginMessage.tag.equals("BungeeCord")) {
            byte[] b;
            ServerInfo server;
            Object target;
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            String subChannel = in.readUTF();
            if (subChannel.equals("Forward")) {
                target = in.readUTF();
                String channel = in.readUTF();
                short len = in.readShort();
                byte[] data = new byte[len];
                in.readFully(data);
                out.writeUTF(channel);
                out.writeShort(data.length);
                out.write(data);
                byte[] payload = out.toByteArray();
                out = null;
                if (((String)target).equals("ALL")) {
                    for (ServerInfo server2 : this.bungee.getServers().values()) {
                        if (server2 == this.con.getServer().getInfo()) continue;
                        server2.sendData("BungeeCord", payload);
                    }
                } else {
                    ServerInfo server3 = this.bungee.getServerInfo((String)target);
                    if (server3 != null) {
                        server3.sendData("BungeeCord", payload);
                    }
                }
            }
            if (subChannel.equals("Connect") && (server = this.bungee.getServerInfo(in.readUTF())) != null) {
                this.con.connect(server);
            }
            if (subChannel.equals("IP")) {
                out.writeUTF("IP");
                out.writeUTF(this.con.getAddress().getHostString());
                out.writeInt(this.con.getAddress().getPort());
            }
            if (subChannel.equals("PlayerCount") && (server = this.bungee.getServerInfo(in.readUTF())) != null) {
                out.writeUTF("PlayerCount");
                out.writeUTF(server.getName());
                out.writeInt(server.getPlayers().size());
            }
            if (subChannel.equals("PlayerList")) {
                target = in.readUTF();
                out.writeUTF("PlayerList");
                if (((String)target).equals("ALL")) {
                    out.writeUTF(Util.csv(this.bungee.getPlayers()));
                } else {
                    ServerInfo server4 = this.bungee.getServerInfo((String)target);
                    if (server4 != null) {
                        out.writeUTF(server4.getName());
                        out.writeUTF(Util.csv(server4.getPlayers()));
                    }
                }
            }
            if (subChannel.equals("GetServers")) {
                out.writeUTF("GetServers");
                out.writeUTF(Util.csv(this.bungee.getServers().keySet()));
            }
            if (subChannel.equals("Message") && (target = this.bungee.getPlayer(in.readUTF())) != null) {
                target.sendMessage(in.readUTF());
            }
            if (subChannel.equals("GetServer")) {
                out.writeUTF("GetServer");
                out.writeUTF(this.server.getInfo().getName());
            }
            if (out != null && (b = out.toByteArray()).length != 0) {
                this.con.getServer().sendData("BungeeCord", b);
            }
        }
    }

    @Override
    public void handle(PacketFFKick kick) throws Exception {
        ServerKickEvent event;
        ServerInfo def = this.bungee.getServerInfo(this.con.getPendingConnection().getListener().getFallbackServer());
        if (Objects.equals(this.server.getInfo(), def)) {
            def = null;
        }
        if ((event = this.bungee.getPluginManager().callEvent(new ServerKickEvent(this.con, kick.message, def))).isCancelled() && event.getCancelServer() != null) {
            this.con.connectNow(event.getCancelServer());
        } else {
            this.con.disconnect("[Kicked] " + event.getKickReason());
        }
        this.server.setObsolete(true);
        throw new CancelSendSignal();
    }

    @Override
    public String toString() {
        return "[" + this.con.getName() + "] <-> DownstreamBridge <-> [" + this.server.getInfo().getName() + "]";
    }

    @ConstructorProperties(value={"bungee", "con", "server"})
    public DownstreamBridge(ProxyServer bungee, UserConnection con, ServerConnection server) {
        this.bungee = bungee;
        this.con = con;
        this.server = server;
    }
}

