/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.aio;

import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.channel.aio.AioEventLoop;
import java.nio.channels.CompletionHandler;

public abstract class AioCompletionHandler<V, A extends Channel>
implements CompletionHandler<V, A> {
    private static final int MAX_STACK_DEPTH = 8;
    private static final ThreadLocal<Integer> STACK_DEPTH = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    protected abstract void completed0(V var1, A var2);

    protected abstract void failed0(Throwable var1, A var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void completed(final V result, A channel) {
        EventLoop loop = channel.eventLoop();
        if (loop.inEventLoop()) {
            Integer d = STACK_DEPTH.get();
            if (d < 8) {
                STACK_DEPTH.set(d + 1);
                try {
                    this.completed0(result, channel);
                }
                finally {
                    STACK_DEPTH.set(d);
                }
            } else {
                loop.execute(new AioEventLoop.RecursionBreakingRunnable((Channel)channel){
                    final /* synthetic */ Channel val$channel;
                    {
                        this.val$channel = channel;
                    }

                    @Override
                    public void run() {
                        AioCompletionHandler.this.completed0(result, this.val$channel);
                    }
                });
            }
        } else {
            loop.execute(new Runnable((Channel)channel){
                final /* synthetic */ Channel val$channel;
                {
                    this.val$channel = channel;
                }

                @Override
                public void run() {
                    AioCompletionHandler.this.completed0(result, this.val$channel);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void failed(final Throwable exc, A channel) {
        EventLoop loop = channel.eventLoop();
        if (loop.inEventLoop()) {
            Integer d = STACK_DEPTH.get();
            if (d < 8) {
                STACK_DEPTH.set(d + 1);
                try {
                    this.failed0(exc, channel);
                }
                finally {
                    STACK_DEPTH.set(d);
                }
            } else {
                loop.execute(new AioEventLoop.RecursionBreakingRunnable((Channel)channel){
                    final /* synthetic */ Channel val$channel;
                    {
                        this.val$channel = channel;
                    }

                    @Override
                    public void run() {
                        AioCompletionHandler.this.failed0(exc, this.val$channel);
                    }
                });
            }
        } else {
            loop.execute(new Runnable((Channel)channel){
                final /* synthetic */ Channel val$channel;
                {
                    this.val$channel = channel;
                }

                @Override
                public void run() {
                    AioCompletionHandler.this.failed0(exc, this.val$channel);
                }
            });
        }
    }
}

