/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.netty.channel.Channel;
import java.beans.ConstructorProperties;
import java.util.Queue;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.config.TexturePackInfo;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.scoreboard.Objective;
import net.md_5.bungee.api.scoreboard.Score;
import net.md_5.bungee.api.scoreboard.Team;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.connection.DownstreamBridge;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.packet.DefinedPacket;
import net.md_5.bungee.packet.Packet1Login;
import net.md_5.bungee.packet.Packet9Respawn;
import net.md_5.bungee.packet.PacketCDClientStatus;
import net.md_5.bungee.packet.PacketCEScoreboardObjective;
import net.md_5.bungee.packet.PacketCFScoreboardScore;
import net.md_5.bungee.packet.PacketD1Team;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.packet.PacketFDEncryptionRequest;
import net.md_5.bungee.packet.PacketFFKick;
import net.md_5.bungee.packet.PacketHandler;

public class ServerConnector
extends PacketHandler {
    private final ProxyServer bungee;
    private Channel ch;
    private final UserConnection user;
    private final ServerInfo target;
    private State thisState = State.ENCRYPT_REQUEST;

    @Override
    public void connected(Channel channel) throws Exception {
        this.ch = channel;
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Login");
        out.writeUTF(this.user.getAddress().getAddress().getHostAddress());
        out.writeInt(this.user.getAddress().getPort());
        channel.write(new PacketFAPluginMessage("BungeeCord", out.toByteArray()));
        channel.write(this.user.handshake);
        channel.write(PacketCDClientStatus.CLIENT_LOGIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Packet1Login login) throws Exception {
        Preconditions.checkState(this.thisState == State.LOGIN, "Not exepcting LOGIN");
        ServerConnection server = new ServerConnection(this.ch, this.target, login);
        ServerConnectedEvent event = new ServerConnectedEvent(this.user, server);
        this.bungee.getPluginManager().callEvent(event);
        this.ch.write(BungeeCord.getInstance().registerChannels());
        Queue<DefinedPacket> packetQueue = ((BungeeServerInfo)this.target).getPacketQueue();
        while (!packetQueue.isEmpty()) {
            this.ch.write(packetQueue.poll());
        }
        if (this.user.settings != null) {
            this.ch.write(this.user.settings);
        }
        Object object = this.user.getSwitchMutex();
        synchronized (object) {
            if (this.user.getServer() == null) {
                BungeeCord.getInstance().connections.put(this.user.getName(), this.user);
                this.bungee.getTabListHandler().onConnect(this.user);
                this.user.clientEntityId = login.entityId;
                this.user.serverEntityId = login.entityId;
                Packet1Login modLogin = new Packet1Login(login.entityId, login.levelType, login.gameMode, (byte)login.dimension, login.difficulty, login.unused, (byte)this.user.getPendingConnection().getListener().getTabListSize());
                this.user.ch.write(modLogin);
                this.ch.write(BungeeCord.getInstance().registerChannels());
                TexturePackInfo texture = this.user.getPendingConnection().getListener().getTexturePack();
                if (texture != null) {
                    this.ch.write(new PacketFAPluginMessage("MC|TPack", (texture.getUrl() + "\u0000" + texture.getSize()).getBytes()));
                }
            } else {
                this.bungee.getTabListHandler().onServerChange(this.user);
                if (this.user.serverSentScoreboard != null) {
                    for (Objective objective : this.user.serverSentScoreboard.getObjectives()) {
                        this.user.ch.write(new PacketCEScoreboardObjective(objective.getName(), objective.getValue(), 1));
                    }
                    for (Score score : this.user.serverSentScoreboard.getScores()) {
                        this.user.ch.write(new PacketCFScoreboardScore(score.getItemName(), 1, null, 0));
                    }
                    for (Team team : this.user.serverSentScoreboard.getTeams()) {
                        this.user.ch.write(PacketD1Team.destroy(team.getName()));
                    }
                    this.user.serverSentScoreboard = null;
                }
                this.user.sendPacket(Packet9Respawn.DIM1_SWITCH);
                this.user.sendPacket(Packet9Respawn.DIM2_SWITCH);
                this.user.serverEntityId = login.entityId;
                this.user.ch.write(new Packet9Respawn(login.dimension, login.difficulty, login.gameMode, 256, login.levelType));
                this.user.getServer().setObsolete(true);
                this.user.getServer().disconnect("Quitting");
            }
            if (!this.user.ch.isActive()) {
                server.disconnect("Quitting");
                throw new IllegalStateException("No client connected for pending server!");
            }
            this.target.addPlayer(this.user);
            this.user.setServer(server);
            this.ch.pipeline().get(HandlerBoss.class).setHandler(new DownstreamBridge(this.bungee, this.user, server));
        }
        this.thisState = State.FINISHED;
        throw new CancelSendSignal();
    }

    @Override
    public void handle(PacketFDEncryptionRequest encryptRequest) throws Exception {
        Preconditions.checkState(this.thisState == State.ENCRYPT_REQUEST, "Not expecting ENCRYPT_REQUEST");
        this.thisState = State.LOGIN;
    }

    @Override
    public void handle(PacketFFKick kick) throws Exception {
        ServerKickEvent event;
        ServerInfo def = this.bungee.getServerInfo(this.user.getPendingConnection().getListener().getDefaultServer());
        if (this.target == def) {
            def = null;
        }
        if ((event = this.bungee.getPluginManager().callEvent(new ServerKickEvent(this.user, kick.message, def))).isCancelled() && event.getCancelServer() != null) {
            this.user.connect(event.getCancelServer());
            return;
        }
        String message = (Object)((Object)ChatColor.RED) + "Kicked whilst connecting to " + this.target.getName() + ": " + kick.message;
        if (this.user.getServer() == null) {
            this.user.disconnect(message);
        } else {
            this.user.sendMessage(message);
        }
    }

    @Override
    public String toString() {
        return "[" + this.user.getName() + "] <-> ServerConnector [" + this.target.getName() + "]";
    }

    @ConstructorProperties(value={"bungee", "user", "target"})
    public ServerConnector(ProxyServer bungee, UserConnection user, ServerInfo target) {
        this.bungee = bungee;
        this.user = user;
        this.target = target;
    }

    private static enum State {
        ENCRYPT_REQUEST,
        LOGIN,
        FINISHED;

    }
}

