/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal.chmv8;

import io.netty.util.internal.chmv8.CountedCompleter;
import io.netty.util.internal.chmv8.ForkJoinPool;
import io.netty.util.internal.chmv8.ForkJoinTask;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import sun.misc.Unsafe;

public final class ConcurrentHashMapV8<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    private static final long serialVersionUID = 7249069246763182397L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int DEFAULT_CAPACITY = 16;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int TREE_THRESHOLD = 8;
    private static final int MIN_TRANSFER_STRIDE = 16;
    static final int MOVED = Integer.MIN_VALUE;
    static final int HASH_BITS = Integer.MAX_VALUE;
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final AtomicInteger counterHashCodeGenerator = new AtomicInteger();
    static final int SEED_INCREMENT = 1640531527;
    static final ThreadLocal<CounterHashCode> threadCounterHashCode = new ThreadLocal();
    volatile transient Node<V>[] table;
    private volatile transient Node<V>[] nextTable;
    private volatile transient long baseCount;
    private volatile transient int sizeCtl;
    private volatile transient int transferIndex;
    private volatile transient int transferOrigin;
    private volatile transient int counterBusy;
    private volatile transient CounterCell[] counterCells;
    private transient KeySetView<K, V> keySet;
    private transient ValuesView<K, V> values;
    private transient EntrySetView<K, V> entrySet;
    private Segment<K, V>[] segments;
    private static final Unsafe U;
    private static final long SIZECTL;
    private static final long TRANSFERINDEX;
    private static final long TRANSFERORIGIN;
    private static final long BASECOUNT;
    private static final long COUNTERBUSY;
    private static final long CELLVALUE;
    private static final long ABASE;
    private static final int ASHIFT;

    static final <V> Node<V> tabAt(Node<V>[] tab, int i) {
        return (Node)U.getObjectVolatile(tab, ((long)i << ASHIFT) + ABASE);
    }

    private static final <V> boolean casTabAt(Node<V>[] tab, int i, Node<V> c, Node<V> v) {
        return U.compareAndSwapObject(tab, ((long)i << ASHIFT) + ABASE, c, v);
    }

    private static final <V> void setTabAt(Node<V>[] tab, int i, Node<V> v) {
        U.putObjectVolatile(tab, ((long)i << ASHIFT) + ABASE, v);
    }

    private static final int spread(int h) {
        h ^= h >>> 18 ^ h >>> 12;
        return (h ^ h >>> 10) & Integer.MAX_VALUE;
    }

    private final void replaceWithTreeBin(Node<V>[] tab, int index, Object key) {
        if (key instanceof Comparable) {
            TreeBin t = new TreeBin();
            Node<V> e = ConcurrentHashMapV8.tabAt(tab, index);
            while (e != null) {
                t.putTreeNode(e.hash, e.key, e.val);
                e = e.next;
            }
            ConcurrentHashMapV8.setTabAt(tab, index, new Node<Object>(Integer.MIN_VALUE, t, null, null));
        }
    }

    private final V internalGet(Object k) {
        int h = ConcurrentHashMapV8.spread(k.hashCode());
        Node<V>[] tab = this.table;
        block0: while (tab != null) {
            Node<V> e = ConcurrentHashMapV8.tabAt(tab, tab.length - 1 & h);
            while (e != null) {
                Object ev;
                Object ek;
                int eh = e.hash;
                if (eh < 0) {
                    ek = e.key;
                    if (ek instanceof TreeBin) {
                        return ((TreeBin)ek).getValue(h, k);
                    }
                    tab = (Node[])ek;
                    continue block0;
                }
                if (eh == h && (ev = e.val) != null && ((ek = e.key) == k || k.equals(ek))) {
                    return ev;
                }
                e = e.next;
            }
            break block0;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final V internalReplace(Object k, V v, Object cv) {
        int i;
        Node<V> f;
        int h = ConcurrentHashMapV8.spread(k.hashCode());
        Object oldVal = null;
        Node<V>[] tab = this.table;
        while (tab != null && (f = ConcurrentHashMapV8.tabAt(tab, i = tab.length - 1 & h)) != null) {
            int fh = f.hash;
            if (fh < 0) {
                Object fk = f.key;
                if (fk instanceof TreeBin) {
                    TreeBin t = (TreeBin)fk;
                    boolean validated = false;
                    boolean deleted = false;
                    t.acquire(0);
                    try {
                        if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                            validated = true;
                            TreeNode p = t.getTreeNode(h, k, t.root);
                            if (p != null) {
                                Object pv = p.val;
                                if (cv == null || cv == pv || cv.equals(pv)) {
                                    oldVal = pv;
                                    p.val = v;
                                    if (p.val == null) {
                                        deleted = true;
                                        t.deleteTreeNode(p);
                                    }
                                }
                            }
                        }
                    }
                    finally {
                        t.release(0);
                    }
                    if (!validated) continue;
                    if (!deleted) break;
                    this.addCount(-1L, -1);
                    break;
                }
                tab = (Node[])fk;
                continue;
            }
            if (fh != h && f.next == null) break;
            boolean validated = false;
            boolean deleted = false;
            Node<V> node = f;
            synchronized (node) {
                if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                    validated = true;
                    Node<V> e = f;
                    Node<V> pred = null;
                    do {
                        Object ek;
                        Object ev;
                        if (e.hash == h && (ev = e.val) != null && ((ek = e.key) == k || k.equals(ek))) {
                            if (cv != null && cv != ev && !cv.equals(ev)) break;
                            oldVal = ev;
                            e.val = v;
                            if (e.val != null) break;
                            deleted = true;
                            Node en = e.next;
                            if (pred != null) {
                                pred.next = en;
                                break;
                            }
                            ConcurrentHashMapV8.setTabAt(tab, i, en);
                            break;
                        }
                        pred = e;
                    } while ((e = e.next) != null);
                }
            }
            if (!validated) continue;
            if (!deleted) break;
            this.addCount(-1L, -1);
            break;
        }
        return (V)oldVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final V internalPut(K k, V v, boolean onlyIfAbsent) {
        int len;
        block22: {
            V oldVal;
            if (k == null || v == null) {
                throw new NullPointerException();
            }
            int h = ConcurrentHashMapV8.spread(k.hashCode());
            len = 0;
            Node<V>[] tab = this.table;
            while (true) {
                Object fv;
                Object fk;
                if (tab == null) {
                    tab = this.initTable();
                    continue;
                }
                int i = tab.length - 1 & h;
                Node<V> f = ConcurrentHashMapV8.tabAt(tab, i);
                if (f == null) {
                    if (!ConcurrentHashMapV8.casTabAt(tab, i, null, new Node<V>(h, k, v, null))) continue;
                    break block22;
                }
                int fh = f.hash;
                if (fh < 0) {
                    fk = f.key;
                    if (fk instanceof TreeBin) {
                        TreeBin t = (TreeBin)fk;
                        Object oldVal2 = null;
                        t.acquire(0);
                        try {
                            if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                                len = 2;
                                TreeNode<V> p = t.putTreeNode(h, k, v);
                                if (p != null) {
                                    oldVal2 = p.val;
                                    if (!onlyIfAbsent) {
                                        p.val = v;
                                    }
                                }
                            }
                        }
                        finally {
                            t.release(0);
                        }
                        if (len == 0) continue;
                        if (oldVal2 != null) {
                            return (V)oldVal2;
                        }
                        break block22;
                    }
                    tab = (Node[])fk;
                    continue;
                }
                if (onlyIfAbsent && fh == h && (fv = f.val) != null && ((fk = f.key) == k || k.equals(fk))) {
                    return fv;
                }
                oldVal = null;
                Node<V> node = f;
                synchronized (node) {
                    if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                        len = 1;
                        Node<V> e = f;
                        while (true) {
                            Object ek;
                            Object ev;
                            if (e.hash == h && (ev = e.val) != null && ((ek = e.key) == k || k.equals(ek))) {
                                oldVal = ev;
                                if (onlyIfAbsent) break;
                                e.val = v;
                                break;
                            }
                            Node<V> last = e;
                            e = e.next;
                            if (e == null) {
                                last.next = new Node<V>(h, k, v, null);
                                if (len < 8) break;
                                this.replaceWithTreeBin(tab, i, k);
                                break;
                            }
                            ++len;
                        }
                    }
                }
                if (len != 0) break;
            }
            if (oldVal != null) {
                return oldVal;
            }
        }
        this.addCount(1L, len);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final V internalComputeIfAbsent(K k, Fun<? super K, ? extends V> mf) {
        int len;
        Object val;
        block35: {
            boolean added;
            if (k == null || mf == null) {
                throw new NullPointerException();
            }
            int h = ConcurrentHashMapV8.spread(k.hashCode());
            val = null;
            len = 0;
            Node<V>[] tab = this.table;
            while (true) {
                if (tab == null) {
                    tab = this.initTable();
                    continue;
                }
                int i = tab.length - 1 & h;
                Node<V> f = ConcurrentHashMapV8.tabAt(tab, i);
                if (f == null) {
                    Node<Object> node;
                    Node<Object> node2 = node = new Node<Object>(h, k, null, null);
                    synchronized (node2) {
                        if (ConcurrentHashMapV8.casTabAt(tab, i, null, node)) {
                            len = 1;
                            try {
                                V v = mf.apply(k);
                                val = v;
                                if (v != null) {
                                    node.val = val;
                                }
                            }
                            finally {
                                if (val == null) {
                                    ConcurrentHashMapV8.setTabAt(tab, i, null);
                                }
                            }
                        }
                    }
                    if (len == 0) continue;
                    break block35;
                }
                if (f.hash < 0) {
                    Object fk = f.key;
                    if (fk instanceof TreeBin) {
                        TreeBin t = (TreeBin)fk;
                        boolean added2 = false;
                        t.acquire(0);
                        try {
                            if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                                len = 1;
                                TreeNode p = t.getTreeNode(h, k, t.root);
                                if (p != null) {
                                    val = p.val;
                                } else {
                                    val = mf.apply(k);
                                    if (val != null) {
                                        added2 = true;
                                        len = 2;
                                        t.putTreeNode(h, k, val);
                                    }
                                }
                            }
                        }
                        finally {
                            t.release(0);
                        }
                        if (len == 0) continue;
                        if (!added2) {
                            return (V)val;
                        }
                        break block35;
                    }
                    tab = (Node[])fk;
                    continue;
                }
                Node<V> e = f;
                while (e != null) {
                    Object ek;
                    Object ev;
                    if (e.hash == h && (ev = e.val) != null && ((ek = e.key) == k || k.equals(ek))) {
                        return ev;
                    }
                    e = e.next;
                }
                added = false;
                Node<V> node = f;
                synchronized (node) {
                    if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                        len = 1;
                        Node<V> e2 = f;
                        while (true) {
                            Object ek;
                            Object ev;
                            if (e2.hash == h && (ev = e2.val) != null && ((ek = e2.key) == k || k.equals(ek))) {
                                val = ev;
                                break;
                            }
                            Node<V> last = e2;
                            e2 = e2.next;
                            if (e2 == null) {
                                val = mf.apply(k);
                                if (val == null) break;
                                added = true;
                                last.next = new Node<Object>(h, k, val, null);
                                if (len < 8) break;
                                this.replaceWithTreeBin(tab, i, k);
                                break;
                            }
                            ++len;
                        }
                    }
                }
                if (len != 0) break;
            }
            if (!added) {
                return (V)val;
            }
        }
        if (val != null) {
            this.addCount(1L, len);
        }
        return (V)val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final V internalCompute(K k, boolean onlyIfPresent, BiFun<? super K, ? super V, ? extends V> mf) {
        if (k == null || mf == null) {
            throw new NullPointerException();
        }
        int h = ConcurrentHashMapV8.spread(k.hashCode());
        Object val = null;
        int delta = 0;
        int len = 0;
        Node<V>[] tab = this.table;
        while (true) {
            if (tab == null) {
                tab = this.initTable();
                continue;
            }
            int i = tab.length - 1 & h;
            Node<V> f = ConcurrentHashMapV8.tabAt(tab, i);
            if (f == null) {
                Node<Object> node;
                if (onlyIfPresent) break;
                Node<Object> node2 = node = new Node<Object>(h, k, null, null);
                synchronized (node2) {
                    if (ConcurrentHashMapV8.casTabAt(tab, i, null, node)) {
                        try {
                            len = 1;
                            V v = mf.apply(k, null);
                            val = v;
                            if (v != null) {
                                node.val = val;
                                delta = 1;
                            }
                        }
                        finally {
                            if (delta == 0) {
                                ConcurrentHashMapV8.setTabAt(tab, i, null);
                            }
                        }
                    }
                }
                if (len == 0) continue;
                break;
            }
            int fh = f.hash;
            if (fh < 0) {
                Object fk = f.key;
                if (fk instanceof TreeBin) {
                    block35: {
                        TreeBin t = (TreeBin)fk;
                        t.acquire(0);
                        try {
                            if (ConcurrentHashMapV8.tabAt(tab, i) != f) break block35;
                            len = 1;
                            TreeNode p = t.getTreeNode(h, k, t.root);
                            if (p == null && onlyIfPresent) break;
                            Object pv = p == null ? null : p.val;
                            V v = mf.apply(k, pv);
                            val = v;
                            if (v != null) {
                                if (p != null) {
                                    p.val = val;
                                } else {
                                    len = 2;
                                    delta = 1;
                                    t.putTreeNode(h, k, val);
                                }
                            } else if (p != null) {
                                delta = -1;
                                t.deleteTreeNode(p);
                            }
                        }
                        finally {
                            t.release(0);
                        }
                    }
                    if (len == 0) continue;
                    break;
                }
                tab = (Node[])fk;
                continue;
            }
            Node<V> node = f;
            synchronized (node) {
                if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                    len = 1;
                    Node<V> e = f;
                    Node<V> pred = null;
                    while (true) {
                        Object ek;
                        Object ev;
                        if (e.hash == h && (ev = e.val) != null && ((ek = e.key) == k || k.equals(ek))) {
                            val = mf.apply(k, ev);
                            if (val != null) {
                                e.val = val;
                                break;
                            }
                            delta = -1;
                            Node en = e.next;
                            if (pred != null) {
                                pred.next = en;
                                break;
                            }
                            ConcurrentHashMapV8.setTabAt(tab, i, en);
                            break;
                        }
                        pred = e;
                        e = e.next;
                        if (e == null) {
                            if (onlyIfPresent) break;
                            V v = mf.apply(k, null);
                            val = v;
                            if (v == null) break;
                            pred.next = new Node<Object>(h, k, val, null);
                            delta = 1;
                            if (len < 8) break;
                            this.replaceWithTreeBin(tab, i, k);
                            break;
                        }
                        ++len;
                    }
                }
            }
            if (len != 0) break;
        }
        if (delta != 0) {
            this.addCount(delta, len);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final V internalMerge(K k, V v, BiFun<? super V, ? super V, ? extends V> mf) {
        if (k == null || v == null || mf == null) {
            throw new NullPointerException();
        }
        int h = ConcurrentHashMapV8.spread(k.hashCode());
        Object val = null;
        int delta = 0;
        int len = 0;
        Node<V>[] tab = this.table;
        while (true) {
            if (tab == null) {
                tab = this.initTable();
                continue;
            }
            int i = tab.length - 1 & h;
            Node<V> f = ConcurrentHashMapV8.tabAt(tab, i);
            if (f == null) {
                if (!ConcurrentHashMapV8.casTabAt(tab, i, null, new Node<V>(h, k, v, null))) continue;
                delta = 1;
                val = v;
                break;
            }
            if (f.hash < 0) {
                Object fk = f.key;
                if (fk instanceof TreeBin) {
                    TreeBin t = (TreeBin)fk;
                    t.acquire(0);
                    try {
                        if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                            len = 1;
                            TreeNode p = t.getTreeNode(h, k, t.root);
                            val = p == null ? v : mf.apply(p.val, v);
                            if (val != null) {
                                if (p != null) {
                                    p.val = val;
                                } else {
                                    len = 2;
                                    delta = 1;
                                    t.putTreeNode(h, k, val);
                                }
                            } else if (p != null) {
                                delta = -1;
                                t.deleteTreeNode(p);
                            }
                        }
                    }
                    finally {
                        t.release(0);
                    }
                    if (len == 0) continue;
                    break;
                }
                tab = (Node[])fk;
                continue;
            }
            Node<V> node = f;
            synchronized (node) {
                if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                    len = 1;
                    Node<V> e = f;
                    Node<V> pred = null;
                    while (true) {
                        Object ek;
                        Object ev;
                        if (e.hash == h && (ev = e.val) != null && ((ek = e.key) == k || k.equals(ek))) {
                            val = mf.apply(ev, v);
                            if (val != null) {
                                e.val = val;
                                break;
                            }
                            delta = -1;
                            Node en = e.next;
                            if (pred != null) {
                                pred.next = en;
                                break;
                            }
                            ConcurrentHashMapV8.setTabAt(tab, i, en);
                            break;
                        }
                        pred = e;
                        e = e.next;
                        if (e == null) {
                            val = v;
                            pred.next = new Node<Object>(h, k, val, null);
                            delta = 1;
                            if (len < 8) break;
                            this.replaceWithTreeBin(tab, i, k);
                            break;
                        }
                        ++len;
                    }
                }
            }
            if (len != 0) break;
        }
        if (delta != 0) {
            this.addCount(delta, len);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void internalPutAll(Map<? extends K, ? extends V> m) {
        this.tryPresize(m.size());
        long delta = 0L;
        boolean npe = false;
        try {
            block9: for (Map.Entry<K, V> entry : m.entrySet()) {
                int len;
                V v;
                K k;
                if (entry == null || (k = entry.getKey()) == null || (v = entry.getValue()) == null) {
                    npe = true;
                    break;
                }
                int h = ConcurrentHashMapV8.spread(k.hashCode());
                Node<V>[] tab = this.table;
                while (true) {
                    if (tab == null) {
                        tab = this.initTable();
                        continue;
                    }
                    int i = tab.length - 1 & h;
                    Node<V> f = ConcurrentHashMapV8.tabAt(tab, i);
                    if (f == null) {
                        if (!ConcurrentHashMapV8.casTabAt(tab, i, null, new Node<V>(h, k, v, null))) continue;
                        ++delta;
                        continue block9;
                    }
                    int fh = f.hash;
                    if (fh < 0) {
                        Object fk = f.key;
                        if (fk instanceof TreeBin) {
                            TreeBin t = (TreeBin)fk;
                            boolean validated = false;
                            t.acquire(0);
                            try {
                                if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                                    validated = true;
                                    TreeNode p = t.getTreeNode(h, k, t.root);
                                    if (p != null) {
                                        p.val = v;
                                    } else {
                                        t.putTreeNode(h, k, v);
                                        ++delta;
                                    }
                                }
                            }
                            finally {
                                t.release(0);
                            }
                            if (!validated) continue;
                            continue block9;
                        }
                        tab = (Node[])fk;
                        continue;
                    }
                    len = 0;
                    Node<V> node = f;
                    synchronized (node) {
                        if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                            len = 1;
                            Node<V> e = f;
                            while (true) {
                                Object ek;
                                Object ev;
                                if (e.hash == h && (ev = e.val) != null && ((ek = e.key) == k || k.equals(ek))) {
                                    e.val = v;
                                    break;
                                }
                                Node<V> last = e;
                                e = e.next;
                                if (e == null) {
                                    ++delta;
                                    last.next = new Node<V>(h, k, v, null);
                                    if (len < 8) break;
                                    this.replaceWithTreeBin(tab, i, k);
                                    break;
                                }
                                ++len;
                            }
                        }
                    }
                    if (len != 0) break;
                }
                if (len <= true) continue;
                this.addCount(delta, len);
                delta = 0L;
            }
        }
        finally {
            if (delta != 0L) {
                this.addCount(delta, 2);
            }
        }
        if (npe) {
            throw new NullPointerException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void internalClear() {
        long delta = 0L;
        int i = 0;
        Node<V>[] tab = this.table;
        while (tab != null && i < tab.length) {
            Node<V> f = ConcurrentHashMapV8.tabAt(tab, i);
            if (f == null) {
                ++i;
                continue;
            }
            if (f.hash < 0) {
                Object fk = f.key;
                if (fk instanceof TreeBin) {
                    TreeBin t = (TreeBin)fk;
                    t.acquire(0);
                    try {
                        if (ConcurrentHashMapV8.tabAt(tab, i) != f) continue;
                        Node p = t.first;
                        while (p != null) {
                            if (p.val != null) {
                                p.val = null;
                                --delta;
                            }
                            p = p.next;
                        }
                        t.first = null;
                        t.root = null;
                        ++i;
                        continue;
                    }
                    finally {
                        t.release(0);
                        continue;
                    }
                }
                tab = (Node[])fk;
                continue;
            }
            Node<V> node = f;
            synchronized (node) {
                if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                    Node<V> e = f;
                    while (e != null) {
                        if (e.val != null) {
                            e.val = null;
                            --delta;
                        }
                        e = e.next;
                    }
                    ConcurrentHashMapV8.setTabAt(tab, i, null);
                    ++i;
                }
            }
        }
        if (delta != 0L) {
            this.addCount(delta, -1);
        }
    }

    private static final int tableSizeFor(int c) {
        int n = c - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Node<V>[] initTable() {
        Node<V>[] tab;
        block6: {
            int sc;
            while (true) {
                tab = this.table;
                if (this.table != null) break block6;
                sc = this.sizeCtl;
                if (sc < 0) {
                    Thread.yield();
                    continue;
                }
                if (U.compareAndSwapInt(this, SIZECTL, sc, -1)) break;
            }
            try {
                tab = this.table;
                if (this.table == null) {
                    int n = sc > 0 ? sc : 16;
                    Node[] tb = new Node[n];
                    this.table = tab = tb;
                    sc = n - (n >>> 2);
                }
            }
            finally {
                this.sizeCtl = sc;
            }
        }
        return tab;
    }

    private final void addCount(long x, int check) {
        long s;
        long b;
        CounterCell[] as = this.counterCells;
        if (this.counterCells != null || !U.compareAndSwapLong(this, BASECOUNT, b = this.baseCount, s = b + x)) {
            long v;
            CounterCell a;
            int m;
            boolean uncontended = true;
            CounterHashCode hc = threadCounterHashCode.get();
            if (hc == null || as == null || (m = as.length - 1) < 0 || (a = as[m & hc.code]) == null || !(uncontended = U.compareAndSwapLong(a, CELLVALUE, v = a.value, v + x))) {
                this.fullAddCount(x, hc, uncontended);
                return;
            }
            if (check <= 1) {
                return;
            }
            s = this.sumCount();
        }
        if (check >= 0) {
            int sc;
            while (s >= (long)(sc = this.sizeCtl)) {
                Node<V>[] tab = this.table;
                if (this.table == null || tab.length >= 0x40000000) break;
                if (sc < 0) {
                    if (sc == -1 || this.transferIndex <= this.transferOrigin) break;
                    Node<V>[] nt = this.nextTable;
                    if (this.nextTable == null) break;
                    if (U.compareAndSwapInt(this, SIZECTL, sc, sc - 1)) {
                        this.transfer(tab, nt);
                    }
                } else if (U.compareAndSwapInt(this, SIZECTL, sc, -2)) {
                    this.transfer(tab, null);
                }
                s = this.sumCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryPresize(int size) {
        int sc;
        int c;
        int n = c = size >= 0x20000000 ? 0x40000000 : ConcurrentHashMapV8.tableSizeFor(size + (size >>> 1) + 1);
        while ((sc = this.sizeCtl) >= 0) {
            int n2;
            Node<V>[] tab = this.table;
            if (tab == null || (n2 = tab.length) == 0) {
                int n3 = n2 = sc > c ? sc : c;
                if (!U.compareAndSwapInt(this, SIZECTL, sc, -1)) continue;
                try {
                    if (this.table != tab) continue;
                    Node[] tb = new Node[n2];
                    this.table = tb;
                    sc = n2 - (n2 >>> 2);
                    continue;
                }
                finally {
                    this.sizeCtl = sc;
                    continue;
                }
            }
            if (c <= sc || n2 >= 0x40000000) break;
            if (tab != this.table || !U.compareAndSwapInt(this, SIZECTL, sc, -2)) continue;
            this.transfer(tab, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void transfer(Node<V>[] tab, Node<V>[] nextTab) {
        n = tab.length;
        stride = ConcurrentHashMapV8.NCPU > 1 ? (n >>> 3) / ConcurrentHashMapV8.NCPU : n;
        if (stride < 16) {
            stride = 16;
        }
        if (nextTab == null) {
            try {
                tb = new Node[n << 1];
                nextTab = tb;
            }
            catch (Throwable ex) {
                this.sizeCtl = 0x7FFFFFFF;
                return;
            }
            this.nextTable = nextTab;
            this.transferOrigin = n;
            this.transferIndex = n;
            rev = new Node<Object>(-2147483648, tab, null, null);
            k = n;
            while (k > 0) {
                for (m = nextk = k > stride ? k - stride : 0; m < k; ++m) {
                    nextTab[m] = rev;
                }
                for (m = n + nextk; m < n + k; ++m) {
                    nextTab[m] = rev;
                }
                k = nextk;
                ConcurrentHashMapV8.U.putOrderedInt(this, ConcurrentHashMapV8.TRANSFERORIGIN, k);
            }
        }
        nextn = nextTab.length;
        fwd = new Node<Object>(-2147483648, nextTab, null, null);
        advance = true;
        i = 0;
        bound = 0;
        while (true) lbl-1000:
        // 12 sources

        {
            if (advance) {
                if (--i >= bound) {
                    advance = false;
                    continue;
                }
                nextIndex = this.transferIndex;
                if (nextIndex <= this.transferOrigin) {
                    i = -1;
                    advance = false;
                    continue;
                }
                nextBound = nextIndex > stride ? nextIndex - stride : 0;
                if (!ConcurrentHashMapV8.U.compareAndSwapInt(this, ConcurrentHashMapV8.TRANSFERINDEX, nextIndex, nextBound)) continue;
                bound = nextBound;
                i = nextIndex - 1;
                advance = false;
                continue;
            }
            if (i < 0 || i >= n || i + n >= nextn) {
                do {
                    sc = this.sizeCtl;
                } while (!ConcurrentHashMapV8.U.compareAndSwapInt(this, ConcurrentHashMapV8.SIZECTL, sc, ++sc));
                if (sc == -1) {
                    this.nextTable = null;
                    this.table = nextTab;
                    this.sizeCtl = (n << 1) - (n >>> 1);
                }
                return;
            }
            f = ConcurrentHashMapV8.tabAt(tab, i);
            if (f == null) {
                if (!ConcurrentHashMapV8.casTabAt(tab, i, null, fwd)) continue;
                ConcurrentHashMapV8.setTabAt(nextTab, i, null);
                ConcurrentHashMapV8.setTabAt(nextTab, i + n, null);
                advance = true;
                continue;
            }
            if (f.hash >= 0) {
                sc = f;
                synchronized (sc) {
                    if (ConcurrentHashMapV8.tabAt(tab, i) == f) {
                        runBit = f.hash & n;
                        lastRun = f;
                        lo = null;
                        hi = null;
                        p = f.next;
                        while (p != null) {
                            b = p.hash & n;
                            if (b != runBit) {
                                runBit = b;
                                lastRun = p;
                            }
                            p = p.next;
                        }
                        if (runBit == 0) {
                            lo = lastRun;
                        } else {
                            hi = lastRun;
                        }
                        p = f;
                        while (p != lastRun) {
                            ph = p.hash;
                            pk = p.key;
                            pv = p.val;
                            if ((ph & n) == 0) {
                                lo = new Node<V>(ph, pk, pv, lo);
                            } else {
                                hi = new Node<V>(ph, pk, pv, hi);
                            }
                            p = p.next;
                        }
                        ConcurrentHashMapV8.setTabAt(nextTab, i, lo);
                        ConcurrentHashMapV8.setTabAt(nextTab, i + n, hi);
                        ConcurrentHashMapV8.setTabAt(tab, i, fwd);
                        advance = true;
                    }
                }
            }
            fk = f.key;
            if (fk instanceof TreeBin) {
                t = (TreeBin)fk;
                t.acquire(0);
                try {
                    if (ConcurrentHashMapV8.tabAt(tab, i) != f) ** GOTO lbl-1000
                    lt = new TreeBin<V>();
                    ht = new TreeBin<V>();
                    lc = 0;
                    hc = 0;
                    e /* !! */  = t.first;
                    while (e /* !! */  != null) {
                        h = e /* !! */ .hash;
                        k = e /* !! */ .key;
                        v = e /* !! */ .val;
                        if ((h & n) == 0) {
                            ++lc;
                            lt.putTreeNode(h, k, v);
                        } else {
                            ++hc;
                            ht.putTreeNode(h, k, v);
                        }
                        e /* !! */  = e /* !! */ .next;
                    }
                    if (lc < 8) {
                        ln = null;
                        p /* !! */  = lt.first;
                        while (p /* !! */  != null) {
                            ln = new Node<Object>(p /* !! */ .hash, p /* !! */ .key, p /* !! */ .val, ln);
                            p /* !! */  = p /* !! */ .next;
                        }
                    } else {
                        ln = new Node<Object>(-2147483648, lt, null, null);
                    }
                    ConcurrentHashMapV8.setTabAt(nextTab, i, ln);
                    if (hc < 8) {
                        hn = null;
                        p /* !! */  = ht.first;
                        while (p /* !! */  != null) {
                            hn = new Node<Object>(p /* !! */ .hash, p /* !! */ .key, p /* !! */ .val, hn);
                            p /* !! */  = p /* !! */ .next;
                        }
                    } else {
                        hn = new Node<Object>(-2147483648, ht, null, null);
                    }
                    ConcurrentHashMapV8.setTabAt(nextTab, i + n, hn);
                    ConcurrentHashMapV8.setTabAt(tab, i, fwd);
                    advance = true;
                }
                finally {
                    t.release(0);
                }
                continue;
            }
            advance = true;
        }
    }

    final long sumCount() {
        CounterCell[] as = this.counterCells;
        long sum = this.baseCount;
        if (as != null) {
            for (int i = 0; i < as.length; ++i) {
                CounterCell a = as[i];
                if (a == null) continue;
                sum += a.value;
            }
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void fullAddCount(long x, CounterHashCode hc, boolean wasUncontended) {
        int h;
        if (hc == null) {
            hc = new CounterHashCode();
            int s = counterHashCodeGenerator.addAndGet(1640531527);
            hc.code = s == 0 ? 1 : s;
            h = hc.code;
            threadCounterHashCode.set(hc);
        } else {
            h = hc.code;
        }
        boolean collide = false;
        while (true) {
            long v;
            int n;
            CounterCell[] as = this.counterCells;
            if (this.counterCells != null && (n = as.length) > 0) {
                CounterCell a = as[n - 1 & h];
                if (a == null) {
                    if (this.counterBusy == 0) {
                        CounterCell r = new CounterCell(x);
                        if (this.counterBusy == 0 && U.compareAndSwapInt(this, COUNTERBUSY, 0, 1)) {
                            boolean created = false;
                            try {
                                int j;
                                int m;
                                CounterCell[] rs = this.counterCells;
                                if (this.counterCells != null && (m = rs.length) > 0 && rs[j = m - 1 & h] == null) {
                                    rs[j] = r;
                                    created = true;
                                }
                            }
                            finally {
                                this.counterBusy = 0;
                            }
                            if (!created) continue;
                            break;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v = a.value;
                    if (U.compareAndSwapLong(a, CELLVALUE, v, v + x)) break;
                    if (this.counterCells != as || n >= NCPU) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.counterBusy == 0 && U.compareAndSwapInt(this, COUNTERBUSY, 0, 1)) {
                        try {
                            if (this.counterCells == as) {
                                CounterCell[] rs = new CounterCell[n << 1];
                                for (int i = 0; i < n; ++i) {
                                    rs[i] = as[i];
                                }
                                this.counterCells = rs;
                            }
                        }
                        finally {
                            this.counterBusy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h ^= h << 13;
                h ^= h >>> 17;
                h ^= h << 5;
                continue;
            }
            if (this.counterBusy == 0 && this.counterCells == as && U.compareAndSwapInt(this, COUNTERBUSY, 0, 1)) {
                boolean init = false;
                try {
                    if (this.counterCells == as) {
                        CounterCell[] rs = new CounterCell[2];
                        rs[h & 1] = new CounterCell(x);
                        this.counterCells = rs;
                        init = true;
                    }
                }
                finally {
                    this.counterBusy = 0;
                }
                if (!init) continue;
                break;
            }
            v = this.baseCount;
            if (U.compareAndSwapLong(this, BASECOUNT, v, v + x)) break;
        }
        hc.code = h;
    }

    public ConcurrentHashMapV8() {
    }

    public ConcurrentHashMapV8(int initialCapacity) {
        int cap;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.sizeCtl = cap = initialCapacity >= 0x20000000 ? 0x40000000 : ConcurrentHashMapV8.tableSizeFor(initialCapacity + (initialCapacity >>> 1) + 1);
    }

    public ConcurrentHashMapV8(Map<? extends K, ? extends V> m) {
        this.sizeCtl = 16;
        this.internalPutAll(m);
    }

    public ConcurrentHashMapV8(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 1);
    }

    public ConcurrentHashMapV8(int initialCapacity, float loadFactor, int concurrencyLevel) {
        long size;
        int cap;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity < concurrencyLevel) {
            initialCapacity = concurrencyLevel;
        }
        this.sizeCtl = cap = (size = (long)(1.0 + (double)((float)initialCapacity / loadFactor))) >= 0x40000000L ? 0x40000000 : ConcurrentHashMapV8.tableSizeFor((int)size);
    }

    public static <K> KeySetView<K, Boolean> newKeySet() {
        return new KeySetView<K, Boolean>(new ConcurrentHashMapV8(), Boolean.TRUE);
    }

    public static <K> KeySetView<K, Boolean> newKeySet(int initialCapacity) {
        return new KeySetView<K, Boolean>(new ConcurrentHashMapV8(initialCapacity), Boolean.TRUE);
    }

    @Override
    public boolean isEmpty() {
        return this.sumCount() <= 0L;
    }

    @Override
    public int size() {
        long n = this.sumCount();
        return n < 0L ? 0 : (n > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n);
    }

    public long mappingCount() {
        long n = this.sumCount();
        return n < 0L ? 0L : n;
    }

    @Override
    public V get(Object key) {
        return this.internalGet(key);
    }

    public V getValueOrDefault(Object key, V defaultValue) {
        V v = this.internalGet(key);
        return v == null ? defaultValue : v;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalGet(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Object v;
        if (value == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        while ((v = it.advance()) != null) {
            if (v != value && !value.equals(v)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public V put(K key, V value) {
        return this.internalPut(key, value, false);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.internalPut(key, value, true);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.internalPutAll(m);
    }

    @Override
    public V computeIfAbsent(K key, Fun<? super K, ? extends V> mappingFunction) {
        return this.internalComputeIfAbsent(key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, BiFun<? super K, ? super V, ? extends V> remappingFunction) {
        return this.internalCompute(key, true, remappingFunction);
    }

    @Override
    public V compute(K key, BiFun<? super K, ? super V, ? extends V> remappingFunction) {
        return this.internalCompute(key, false, remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFun<? super V, ? super V, ? extends V> remappingFunction) {
        return this.internalMerge(key, value, remappingFunction);
    }

    @Override
    public V remove(Object key) {
        return this.internalReplace(key, null, null);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return value != null && this.internalReplace(key, null, value) != null;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (key == null || oldValue == null || newValue == null) {
            throw new NullPointerException();
        }
        return this.internalReplace(key, newValue, oldValue) != null;
    }

    @Override
    public V replace(K key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.internalReplace(key, value, null);
    }

    @Override
    public void clear() {
        this.internalClear();
    }

    public KeySetView<K, V> keySet() {
        KeySetView<K, V> ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySetView(this, null));
    }

    public KeySetView<K, V> keySet(V mappedValue) {
        if (mappedValue == null) {
            throw new NullPointerException();
        }
        return new KeySetView(this, mappedValue);
    }

    public ValuesView<K, V> values() {
        ValuesView<K, V> vs = this.values;
        return vs != null ? vs : (this.values = new ValuesView(this));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySetView<K, V> es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySetView(this));
    }

    public Enumeration<K> keys() {
        return new KeyIterator(this);
    }

    public Enumeration<V> elements() {
        return new ValueIterator(this);
    }

    public Spliterator<K> keySpliterator() {
        return new KeyIterator(this);
    }

    public Spliterator<V> valueSpliterator() {
        return new ValueIterator(this);
    }

    public Spliterator<Map.Entry<K, V>> entrySpliterator() {
        return new EntryIterator(this);
    }

    @Override
    public int hashCode() {
        Object v;
        int h = 0;
        Traverser it = new Traverser(this);
        while ((v = it.advance()) != null) {
            h += it.nextKey.hashCode() ^ v.hashCode();
        }
        return h;
    }

    public String toString() {
        Traverser it = new Traverser(this);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Object v = it.advance();
        if (v != null) {
            while (true) {
                Object k;
                sb.append((k = it.nextKey) == this ? "(this Map)" : k);
                sb.append('=');
                sb.append((Object)(v == this ? "(this Map)" : v));
                v = it.advance();
                if (v == null) break;
                sb.append(',').append(' ');
            }
        }
        return sb.append('}').toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o != this) {
            Object val;
            if (!(o instanceof Map)) {
                return false;
            }
            Map m = (Map)o;
            Traverser it = new Traverser(this);
            while ((val = it.advance()) != null) {
                Object v = m.get(it.nextKey);
                if (v != null && (v == val || v.equals(val))) continue;
                return false;
            }
            for (Map.Entry e : m.entrySet()) {
                V v;
                Object mv;
                Object mk = e.getKey();
                if (mk != null && (mv = e.getValue()) != null && (v = this.internalGet(mk)) != null && (mv == v || mv.equals(v))) continue;
                return false;
            }
        }
        return true;
    }

    static <K, V> AbstractMap.SimpleEntry<K, V> entryFor(K k, V v) {
        return new AbstractMap.SimpleEntry<K, V>(k, v);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Object v;
        if (this.segments == null) {
            this.segments = new Segment[16];
            for (int i = 0; i < this.segments.length; ++i) {
                this.segments[i] = new Segment(0.75f);
            }
        }
        s.defaultWriteObject();
        Traverser it = new Traverser(this);
        while ((v = it.advance()) != null) {
            s.writeObject(it.nextKey);
            s.writeObject(v);
        }
        s.writeObject(null);
        s.writeObject(null);
        this.segments = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.segments = null;
        long size = 0L;
        Node<Object> p = null;
        while (true) {
            Object k = s.readObject();
            Object v = s.readObject();
            if (k == null || v == null) break;
            int h = ConcurrentHashMapV8.spread(k.hashCode());
            p = new Node<Object>(h, k, v, p);
            ++size;
        }
        if (p != null) {
            int n;
            boolean init = false;
            if (size >= 0x20000000L) {
                n = 0x40000000;
            } else {
                int sz = (int)size;
                n = ConcurrentHashMapV8.tableSizeFor(sz + (sz >>> 1) + 1);
            }
            int sc = this.sizeCtl;
            boolean collide = false;
            if (n > sc && U.compareAndSwapInt(this, SIZECTL, sc, -1)) {
                try {
                    if (this.table == null) {
                        Node[] rt;
                        init = true;
                        Node[] tab = rt = new Node[n];
                        int mask = n - 1;
                        while (p != null) {
                            int j = p.hash & mask;
                            Node next = p.next;
                            p.next = ConcurrentHashMapV8.tabAt(tab, j);
                            Node<V> q = p.next;
                            ConcurrentHashMapV8.setTabAt(tab, j, p);
                            if (!collide && q != null && q.hash == p.hash) {
                                collide = true;
                            }
                            p = next;
                        }
                        this.table = tab;
                        this.addCount(size, -1);
                        sc = n - (n >>> 2);
                    }
                }
                finally {
                    this.sizeCtl = sc;
                }
                if (collide) {
                    Node<V>[] tab = this.table;
                    block5: for (int i = 0; i < tab.length; ++i) {
                        int c = 0;
                        Node<V> e = ConcurrentHashMapV8.tabAt(tab, i);
                        while (e != null) {
                            if (++c > 8 && e.key instanceof Comparable) {
                                this.replaceWithTreeBin(tab, i, e.key);
                                continue block5;
                            }
                            e = e.next;
                        }
                    }
                }
            }
            if (!init) {
                while (p != null) {
                    this.internalPut(p.key, p.val, false);
                    p = p.next;
                }
            }
        }
    }

    public void forEachSequentially(BiAction<K, V> action) {
        Object v;
        if (action == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        while ((v = it.advance()) != null) {
            action.apply(it.nextKey, v);
        }
    }

    public <U> void forEachSequentially(BiFun<? super K, ? super V, ? extends U> transformer, Action<U> action) {
        Object v;
        if (transformer == null || action == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        while ((v = it.advance()) != null) {
            U u = transformer.apply(it.nextKey, v);
            if (u == null) continue;
            action.apply(u);
        }
    }

    public <U> U searchSequentially(BiFun<? super K, ? super V, ? extends U> searchFunction) {
        Object v;
        if (searchFunction == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        while ((v = it.advance()) != null) {
            U u = searchFunction.apply(it.nextKey, v);
            if (u == null) continue;
            return u;
        }
        return null;
    }

    public <U> U reduceSequentially(BiFun<? super K, ? super V, ? extends U> transformer, BiFun<? super U, ? super U, ? extends U> reducer) {
        Object v;
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        Object r = null;
        while ((v = it.advance()) != null) {
            U u = transformer.apply(it.nextKey, v);
            if (u == null) continue;
            r = r == null ? u : reducer.apply(r, u);
        }
        return (U)r;
    }

    public double reduceToDoubleSequentially(ObjectByObjectToDouble<? super K, ? super V> transformer, double basis, DoubleByDoubleToDouble reducer) {
        Object v;
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        double r = basis;
        while ((v = it.advance()) != null) {
            r = reducer.apply(r, transformer.apply(it.nextKey, v));
        }
        return r;
    }

    public long reduceToLongSequentially(ObjectByObjectToLong<? super K, ? super V> transformer, long basis, LongByLongToLong reducer) {
        Object v;
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        long r = basis;
        while ((v = it.advance()) != null) {
            r = reducer.apply(r, transformer.apply(it.nextKey, v));
        }
        return r;
    }

    public int reduceToIntSequentially(ObjectByObjectToInt<? super K, ? super V> transformer, int basis, IntByIntToInt reducer) {
        Object v;
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        int r = basis;
        while ((v = it.advance()) != null) {
            r = reducer.apply(r, transformer.apply(it.nextKey, v));
        }
        return r;
    }

    public void forEachKeySequentially(Action<K> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        while (it.advance() != null) {
            action.apply(it.nextKey);
        }
    }

    public <U> void forEachKeySequentially(Fun<? super K, ? extends U> transformer, Action<U> action) {
        if (transformer == null || action == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        while (it.advance() != null) {
            U u = transformer.apply(it.nextKey);
            if (u == null) continue;
            action.apply(u);
        }
        ForkJoinTasks.forEachKey(this, transformer, action).invoke();
    }

    public <U> U searchKeysSequentially(Fun<? super K, ? extends U> searchFunction) {
        Traverser it = new Traverser(this);
        while (it.advance() != null) {
            U u = searchFunction.apply(it.nextKey);
            if (u == null) continue;
            return u;
        }
        return null;
    }

    public K reduceKeysSequentially(BiFun<? super K, ? super K, ? extends K> reducer) {
        if (reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        Object r = null;
        while (it.advance() != null) {
            Object u = it.nextKey;
            r = r == null ? u : reducer.apply(r, u);
        }
        return (K)r;
    }

    public <U> U reduceKeysSequentially(Fun<? super K, ? extends U> transformer, BiFun<? super U, ? super U, ? extends U> reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        Object r = null;
        while (it.advance() != null) {
            U u = transformer.apply(it.nextKey);
            if (u == null) continue;
            r = r == null ? u : reducer.apply(r, u);
        }
        return (U)r;
    }

    public double reduceKeysToDoubleSequentially(ObjectToDouble<? super K> transformer, double basis, DoubleByDoubleToDouble reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        double r = basis;
        while (it.advance() != null) {
            r = reducer.apply(r, transformer.apply(it.nextKey));
        }
        return r;
    }

    public long reduceKeysToLongSequentially(ObjectToLong<? super K> transformer, long basis, LongByLongToLong reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        long r = basis;
        while (it.advance() != null) {
            r = reducer.apply(r, transformer.apply(it.nextKey));
        }
        return r;
    }

    public int reduceKeysToIntSequentially(ObjectToInt<? super K> transformer, int basis, IntByIntToInt reducer) {
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        int r = basis;
        while (it.advance() != null) {
            r = reducer.apply(r, transformer.apply(it.nextKey));
        }
        return r;
    }

    public void forEachValueSequentially(Action<V> action) {
        Object v;
        if (action == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        while ((v = it.advance()) != null) {
            action.apply(v);
        }
    }

    public <U> void forEachValueSequentially(Fun<? super V, ? extends U> transformer, Action<U> action) {
        Object v;
        if (transformer == null || action == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        while ((v = it.advance()) != null) {
            U u = transformer.apply(v);
            if (u == null) continue;
            action.apply(u);
        }
    }

    public <U> U searchValuesSequentially(Fun<? super V, ? extends U> searchFunction) {
        Object v;
        if (searchFunction == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        while ((v = it.advance()) != null) {
            U u = searchFunction.apply(v);
            if (u == null) continue;
            return u;
        }
        return null;
    }

    public V reduceValuesSequentially(BiFun<? super V, ? super V, ? extends V> reducer) {
        Object v;
        if (reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        Object r = null;
        while ((v = it.advance()) != null) {
            r = r == null ? v : reducer.apply(r, v);
        }
        return (V)r;
    }

    public <U> U reduceValuesSequentially(Fun<? super V, ? extends U> transformer, BiFun<? super U, ? super U, ? extends U> reducer) {
        Object v;
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        Object r = null;
        while ((v = it.advance()) != null) {
            U u = transformer.apply(v);
            if (u == null) continue;
            r = r == null ? u : reducer.apply(r, u);
        }
        return (U)r;
    }

    public double reduceValuesToDoubleSequentially(ObjectToDouble<? super V> transformer, double basis, DoubleByDoubleToDouble reducer) {
        Object v;
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        double r = basis;
        while ((v = it.advance()) != null) {
            r = reducer.apply(r, transformer.apply(v));
        }
        return r;
    }

    public long reduceValuesToLongSequentially(ObjectToLong<? super V> transformer, long basis, LongByLongToLong reducer) {
        Object v;
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        long r = basis;
        while ((v = it.advance()) != null) {
            r = reducer.apply(r, transformer.apply(v));
        }
        return r;
    }

    public int reduceValuesToIntSequentially(ObjectToInt<? super V> transformer, int basis, IntByIntToInt reducer) {
        Object v;
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        int r = basis;
        while ((v = it.advance()) != null) {
            r = reducer.apply(r, transformer.apply(v));
        }
        return r;
    }

    public void forEachEntrySequentially(Action<Map.Entry<K, V>> action) {
        Object v;
        if (action == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        while ((v = it.advance()) != null) {
            action.apply(ConcurrentHashMapV8.entryFor(it.nextKey, v));
        }
    }

    public <U> void forEachEntrySequentially(Fun<Map.Entry<K, V>, ? extends U> transformer, Action<U> action) {
        Object v;
        if (transformer == null || action == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        while ((v = it.advance()) != null) {
            U u = transformer.apply(ConcurrentHashMapV8.entryFor(it.nextKey, v));
            if (u == null) continue;
            action.apply(u);
        }
    }

    public <U> U searchEntriesSequentially(Fun<Map.Entry<K, V>, ? extends U> searchFunction) {
        Object v;
        if (searchFunction == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        while ((v = it.advance()) != null) {
            U u = searchFunction.apply(ConcurrentHashMapV8.entryFor(it.nextKey, v));
            if (u == null) continue;
            return u;
        }
        return null;
    }

    public Map.Entry<K, V> reduceEntriesSequentially(BiFun<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> reducer) {
        Object v;
        if (reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        AbstractMap.SimpleEntry r = null;
        while ((v = it.advance()) != null) {
            AbstractMap.SimpleEntry u = ConcurrentHashMapV8.entryFor(it.nextKey, v);
            r = r == null ? u : reducer.apply(r, u);
        }
        return r;
    }

    public <U> U reduceEntriesSequentially(Fun<Map.Entry<K, V>, ? extends U> transformer, BiFun<? super U, ? super U, ? extends U> reducer) {
        Object v;
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        Object r = null;
        while ((v = it.advance()) != null) {
            U u = transformer.apply(ConcurrentHashMapV8.entryFor(it.nextKey, v));
            if (u == null) continue;
            r = r == null ? u : reducer.apply(r, u);
        }
        return (U)r;
    }

    public double reduceEntriesToDoubleSequentially(ObjectToDouble<Map.Entry<K, V>> transformer, double basis, DoubleByDoubleToDouble reducer) {
        Object v;
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        double r = basis;
        while ((v = it.advance()) != null) {
            r = reducer.apply(r, transformer.apply(ConcurrentHashMapV8.entryFor(it.nextKey, v)));
        }
        return r;
    }

    public long reduceEntriesToLongSequentially(ObjectToLong<Map.Entry<K, V>> transformer, long basis, LongByLongToLong reducer) {
        Object v;
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        long r = basis;
        while ((v = it.advance()) != null) {
            r = reducer.apply(r, transformer.apply(ConcurrentHashMapV8.entryFor(it.nextKey, v)));
        }
        return r;
    }

    public int reduceEntriesToIntSequentially(ObjectToInt<Map.Entry<K, V>> transformer, int basis, IntByIntToInt reducer) {
        Object v;
        if (transformer == null || reducer == null) {
            throw new NullPointerException();
        }
        Traverser it = new Traverser(this);
        int r = basis;
        while ((v = it.advance()) != null) {
            r = reducer.apply(r, transformer.apply(ConcurrentHashMapV8.entryFor(it.nextKey, v)));
        }
        return r;
    }

    public void forEachInParallel(BiAction<K, V> action) {
        ForkJoinTasks.forEach(this, action).invoke();
    }

    public <U> void forEachInParallel(BiFun<? super K, ? super V, ? extends U> transformer, Action<U> action) {
        ForkJoinTasks.forEach(this, transformer, action).invoke();
    }

    public <U> U searchInParallel(BiFun<? super K, ? super V, ? extends U> searchFunction) {
        return ForkJoinTasks.search(this, searchFunction).invoke();
    }

    public <U> U reduceInParallel(BiFun<? super K, ? super V, ? extends U> transformer, BiFun<? super U, ? super U, ? extends U> reducer) {
        return ForkJoinTasks.reduce(this, transformer, reducer).invoke();
    }

    public double reduceToDoubleInParallel(ObjectByObjectToDouble<? super K, ? super V> transformer, double basis, DoubleByDoubleToDouble reducer) {
        return ForkJoinTasks.reduceToDouble(this, transformer, basis, reducer).invoke();
    }

    public long reduceToLongInParallel(ObjectByObjectToLong<? super K, ? super V> transformer, long basis, LongByLongToLong reducer) {
        return ForkJoinTasks.reduceToLong(this, transformer, basis, reducer).invoke();
    }

    public int reduceToIntInParallel(ObjectByObjectToInt<? super K, ? super V> transformer, int basis, IntByIntToInt reducer) {
        return ForkJoinTasks.reduceToInt(this, transformer, basis, reducer).invoke();
    }

    public void forEachKeyInParallel(Action<K> action) {
        ForkJoinTasks.forEachKey(this, action).invoke();
    }

    public <U> void forEachKeyInParallel(Fun<? super K, ? extends U> transformer, Action<U> action) {
        ForkJoinTasks.forEachKey(this, transformer, action).invoke();
    }

    public <U> U searchKeysInParallel(Fun<? super K, ? extends U> searchFunction) {
        return ForkJoinTasks.searchKeys(this, searchFunction).invoke();
    }

    public K reduceKeysInParallel(BiFun<? super K, ? super K, ? extends K> reducer) {
        return ForkJoinTasks.reduceKeys(this, reducer).invoke();
    }

    public <U> U reduceKeysInParallel(Fun<? super K, ? extends U> transformer, BiFun<? super U, ? super U, ? extends U> reducer) {
        return ForkJoinTasks.reduceKeys(this, transformer, reducer).invoke();
    }

    public double reduceKeysToDoubleInParallel(ObjectToDouble<? super K> transformer, double basis, DoubleByDoubleToDouble reducer) {
        return ForkJoinTasks.reduceKeysToDouble(this, transformer, basis, reducer).invoke();
    }

    public long reduceKeysToLongInParallel(ObjectToLong<? super K> transformer, long basis, LongByLongToLong reducer) {
        return ForkJoinTasks.reduceKeysToLong(this, transformer, basis, reducer).invoke();
    }

    public int reduceKeysToIntInParallel(ObjectToInt<? super K> transformer, int basis, IntByIntToInt reducer) {
        return ForkJoinTasks.reduceKeysToInt(this, transformer, basis, reducer).invoke();
    }

    public void forEachValueInParallel(Action<V> action) {
        ForkJoinTasks.forEachValue(this, action).invoke();
    }

    public <U> void forEachValueInParallel(Fun<? super V, ? extends U> transformer, Action<U> action) {
        ForkJoinTasks.forEachValue(this, transformer, action).invoke();
    }

    public <U> U searchValuesInParallel(Fun<? super V, ? extends U> searchFunction) {
        return ForkJoinTasks.searchValues(this, searchFunction).invoke();
    }

    public V reduceValuesInParallel(BiFun<? super V, ? super V, ? extends V> reducer) {
        return ForkJoinTasks.reduceValues(this, reducer).invoke();
    }

    public <U> U reduceValuesInParallel(Fun<? super V, ? extends U> transformer, BiFun<? super U, ? super U, ? extends U> reducer) {
        return ForkJoinTasks.reduceValues(this, transformer, reducer).invoke();
    }

    public double reduceValuesToDoubleInParallel(ObjectToDouble<? super V> transformer, double basis, DoubleByDoubleToDouble reducer) {
        return ForkJoinTasks.reduceValuesToDouble(this, transformer, basis, reducer).invoke();
    }

    public long reduceValuesToLongInParallel(ObjectToLong<? super V> transformer, long basis, LongByLongToLong reducer) {
        return ForkJoinTasks.reduceValuesToLong(this, transformer, basis, reducer).invoke();
    }

    public int reduceValuesToIntInParallel(ObjectToInt<? super V> transformer, int basis, IntByIntToInt reducer) {
        return ForkJoinTasks.reduceValuesToInt(this, transformer, basis, reducer).invoke();
    }

    public void forEachEntryInParallel(Action<Map.Entry<K, V>> action) {
        ForkJoinTasks.forEachEntry(this, action).invoke();
    }

    public <U> void forEachEntryInParallel(Fun<Map.Entry<K, V>, ? extends U> transformer, Action<U> action) {
        ForkJoinTasks.forEachEntry(this, transformer, action).invoke();
    }

    public <U> U searchEntriesInParallel(Fun<Map.Entry<K, V>, ? extends U> searchFunction) {
        return ForkJoinTasks.searchEntries(this, searchFunction).invoke();
    }

    public Map.Entry<K, V> reduceEntriesInParallel(BiFun<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> reducer) {
        return ForkJoinTasks.reduceEntries(this, reducer).invoke();
    }

    public <U> U reduceEntriesInParallel(Fun<Map.Entry<K, V>, ? extends U> transformer, BiFun<? super U, ? super U, ? extends U> reducer) {
        return ForkJoinTasks.reduceEntries(this, transformer, reducer).invoke();
    }

    public double reduceEntriesToDoubleInParallel(ObjectToDouble<Map.Entry<K, V>> transformer, double basis, DoubleByDoubleToDouble reducer) {
        return ForkJoinTasks.reduceEntriesToDouble(this, transformer, basis, reducer).invoke();
    }

    public long reduceEntriesToLongInParallel(ObjectToLong<Map.Entry<K, V>> transformer, long basis, LongByLongToLong reducer) {
        return ForkJoinTasks.reduceEntriesToLong(this, transformer, basis, reducer).invoke();
    }

    public int reduceEntriesToIntInParallel(ObjectToInt<Map.Entry<K, V>> transformer, int basis, IntByIntToInt reducer) {
        return ForkJoinTasks.reduceEntriesToInt(this, transformer, basis, reducer).invoke();
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException tryReflectionInstead) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> k = Unsafe.class;
                        for (Field f : k.getDeclaredFields()) {
                            f.setAccessible(true);
                            Object x = f.get(null);
                            if (!k.isInstance(x)) continue;
                            return (Unsafe)k.cast(x);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static {
        try {
            U = ConcurrentHashMapV8.getUnsafe();
            Class<ConcurrentHashMapV8> k = ConcurrentHashMapV8.class;
            SIZECTL = U.objectFieldOffset(k.getDeclaredField("sizeCtl"));
            TRANSFERINDEX = U.objectFieldOffset(k.getDeclaredField("transferIndex"));
            TRANSFERORIGIN = U.objectFieldOffset(k.getDeclaredField("transferOrigin"));
            BASECOUNT = U.objectFieldOffset(k.getDeclaredField("baseCount"));
            COUNTERBUSY = U.objectFieldOffset(k.getDeclaredField("counterBusy"));
            Class<CounterCell> ck = CounterCell.class;
            CELLVALUE = U.objectFieldOffset(ck.getDeclaredField("value"));
            Class<Node[]> sc = Node[].class;
            ABASE = U.arrayBaseOffset(sc);
            int scale = U.arrayIndexScale(sc);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    static final class MapReduceMappingsToIntTask<K, V>
    extends Traverser<K, V, Integer> {
        final ObjectByObjectToInt<? super K, ? super V> transformer;
        final IntByIntToInt reducer;
        final int basis;
        int result;
        MapReduceMappingsToIntTask<K, V> rights;
        MapReduceMappingsToIntTask<K, V> nextRight;

        MapReduceMappingsToIntTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, MapReduceMappingsToIntTask<K, V> nextRight, ObjectByObjectToInt<? super K, ? super V> transformer, int basis, IntByIntToInt reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntByIntToInt reducer;
            ObjectByObjectToInt<K, V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Object v;
                int b;
                int r = this.basis;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new MapReduceMappingsToIntTask<K, V>(this.map, this, b, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((v = this.advance()) != null) {
                    r = reducer.apply(r, transformer.apply(this.nextKey, v));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceMappingsToIntTask t = (MapReduceMappingsToIntTask)c;
                    MapReduceMappingsToIntTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.apply(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesToIntTask<K, V>
    extends Traverser<K, V, Integer> {
        final ObjectToInt<Map.Entry<K, V>> transformer;
        final IntByIntToInt reducer;
        final int basis;
        int result;
        MapReduceEntriesToIntTask<K, V> rights;
        MapReduceEntriesToIntTask<K, V> nextRight;

        MapReduceEntriesToIntTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, MapReduceEntriesToIntTask<K, V> nextRight, ObjectToInt<Map.Entry<K, V>> transformer, int basis, IntByIntToInt reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntByIntToInt reducer;
            ObjectToInt<Map.Entry<K, V>> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Object v;
                int b;
                int r = this.basis;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new MapReduceEntriesToIntTask<K, V>(this.map, this, b, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((v = this.advance()) != null) {
                    r = reducer.apply(r, transformer.apply(ConcurrentHashMapV8.entryFor(this.nextKey, v)));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceEntriesToIntTask t = (MapReduceEntriesToIntTask)c;
                    MapReduceEntriesToIntTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.apply(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesToIntTask<K, V>
    extends Traverser<K, V, Integer> {
        final ObjectToInt<? super V> transformer;
        final IntByIntToInt reducer;
        final int basis;
        int result;
        MapReduceValuesToIntTask<K, V> rights;
        MapReduceValuesToIntTask<K, V> nextRight;

        MapReduceValuesToIntTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, MapReduceValuesToIntTask<K, V> nextRight, ObjectToInt<? super V> transformer, int basis, IntByIntToInt reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntByIntToInt reducer;
            ObjectToInt<V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Object v;
                int b;
                int r = this.basis;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new MapReduceValuesToIntTask<K, V>(this.map, this, b, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((v = this.advance()) != null) {
                    r = reducer.apply(r, transformer.apply(v));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceValuesToIntTask t = (MapReduceValuesToIntTask)c;
                    MapReduceValuesToIntTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.apply(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysToIntTask<K, V>
    extends Traverser<K, V, Integer> {
        final ObjectToInt<? super K> transformer;
        final IntByIntToInt reducer;
        final int basis;
        int result;
        MapReduceKeysToIntTask<K, V> rights;
        MapReduceKeysToIntTask<K, V> nextRight;

        MapReduceKeysToIntTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, MapReduceKeysToIntTask<K, V> nextRight, ObjectToInt<? super K> transformer, int basis, IntByIntToInt reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Integer getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            IntByIntToInt reducer;
            ObjectToInt<K> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                int b;
                int r = this.basis;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new MapReduceKeysToIntTask<K, V>(this.map, this, b, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while (this.advance() != null) {
                    r = reducer.apply(r, transformer.apply(this.nextKey));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceKeysToIntTask t = (MapReduceKeysToIntTask)c;
                    MapReduceKeysToIntTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.apply(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceMappingsToLongTask<K, V>
    extends Traverser<K, V, Long> {
        final ObjectByObjectToLong<? super K, ? super V> transformer;
        final LongByLongToLong reducer;
        final long basis;
        long result;
        MapReduceMappingsToLongTask<K, V> rights;
        MapReduceMappingsToLongTask<K, V> nextRight;

        MapReduceMappingsToLongTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, MapReduceMappingsToLongTask<K, V> nextRight, ObjectByObjectToLong<? super K, ? super V> transformer, long basis, LongByLongToLong reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongByLongToLong reducer;
            ObjectByObjectToLong<K, V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Object v;
                int b;
                long r = this.basis;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new MapReduceMappingsToLongTask<K, V>(this.map, this, b, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((v = this.advance()) != null) {
                    r = reducer.apply(r, transformer.apply(this.nextKey, v));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceMappingsToLongTask t = (MapReduceMappingsToLongTask)c;
                    MapReduceMappingsToLongTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.apply(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesToLongTask<K, V>
    extends Traverser<K, V, Long> {
        final ObjectToLong<Map.Entry<K, V>> transformer;
        final LongByLongToLong reducer;
        final long basis;
        long result;
        MapReduceEntriesToLongTask<K, V> rights;
        MapReduceEntriesToLongTask<K, V> nextRight;

        MapReduceEntriesToLongTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, MapReduceEntriesToLongTask<K, V> nextRight, ObjectToLong<Map.Entry<K, V>> transformer, long basis, LongByLongToLong reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongByLongToLong reducer;
            ObjectToLong<Map.Entry<K, V>> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Object v;
                int b;
                long r = this.basis;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new MapReduceEntriesToLongTask<K, V>(this.map, this, b, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((v = this.advance()) != null) {
                    r = reducer.apply(r, transformer.apply(ConcurrentHashMapV8.entryFor(this.nextKey, v)));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceEntriesToLongTask t = (MapReduceEntriesToLongTask)c;
                    MapReduceEntriesToLongTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.apply(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesToLongTask<K, V>
    extends Traverser<K, V, Long> {
        final ObjectToLong<? super V> transformer;
        final LongByLongToLong reducer;
        final long basis;
        long result;
        MapReduceValuesToLongTask<K, V> rights;
        MapReduceValuesToLongTask<K, V> nextRight;

        MapReduceValuesToLongTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, MapReduceValuesToLongTask<K, V> nextRight, ObjectToLong<? super V> transformer, long basis, LongByLongToLong reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongByLongToLong reducer;
            ObjectToLong<V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Object v;
                int b;
                long r = this.basis;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new MapReduceValuesToLongTask<K, V>(this.map, this, b, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((v = this.advance()) != null) {
                    r = reducer.apply(r, transformer.apply(v));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceValuesToLongTask t = (MapReduceValuesToLongTask)c;
                    MapReduceValuesToLongTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.apply(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysToLongTask<K, V>
    extends Traverser<K, V, Long> {
        final ObjectToLong<? super K> transformer;
        final LongByLongToLong reducer;
        final long basis;
        long result;
        MapReduceKeysToLongTask<K, V> rights;
        MapReduceKeysToLongTask<K, V> nextRight;

        MapReduceKeysToLongTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, MapReduceKeysToLongTask<K, V> nextRight, ObjectToLong<? super K> transformer, long basis, LongByLongToLong reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Long getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            LongByLongToLong reducer;
            ObjectToLong<K> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                int b;
                long r = this.basis;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new MapReduceKeysToLongTask<K, V>(this.map, this, b, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while (this.advance() != null) {
                    r = reducer.apply(r, transformer.apply(this.nextKey));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceKeysToLongTask t = (MapReduceKeysToLongTask)c;
                    MapReduceKeysToLongTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.apply(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceMappingsToDoubleTask<K, V>
    extends Traverser<K, V, Double> {
        final ObjectByObjectToDouble<? super K, ? super V> transformer;
        final DoubleByDoubleToDouble reducer;
        final double basis;
        double result;
        MapReduceMappingsToDoubleTask<K, V> rights;
        MapReduceMappingsToDoubleTask<K, V> nextRight;

        MapReduceMappingsToDoubleTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, MapReduceMappingsToDoubleTask<K, V> nextRight, ObjectByObjectToDouble<? super K, ? super V> transformer, double basis, DoubleByDoubleToDouble reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleByDoubleToDouble reducer;
            ObjectByObjectToDouble<K, V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Object v;
                int b;
                double r = this.basis;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new MapReduceMappingsToDoubleTask<K, V>(this.map, this, b, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((v = this.advance()) != null) {
                    r = reducer.apply(r, transformer.apply(this.nextKey, v));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceMappingsToDoubleTask t = (MapReduceMappingsToDoubleTask)c;
                    MapReduceMappingsToDoubleTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.apply(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesToDoubleTask<K, V>
    extends Traverser<K, V, Double> {
        final ObjectToDouble<Map.Entry<K, V>> transformer;
        final DoubleByDoubleToDouble reducer;
        final double basis;
        double result;
        MapReduceEntriesToDoubleTask<K, V> rights;
        MapReduceEntriesToDoubleTask<K, V> nextRight;

        MapReduceEntriesToDoubleTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, MapReduceEntriesToDoubleTask<K, V> nextRight, ObjectToDouble<Map.Entry<K, V>> transformer, double basis, DoubleByDoubleToDouble reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleByDoubleToDouble reducer;
            ObjectToDouble<Map.Entry<K, V>> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Object v;
                int b;
                double r = this.basis;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new MapReduceEntriesToDoubleTask<K, V>(this.map, this, b, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((v = this.advance()) != null) {
                    r = reducer.apply(r, transformer.apply(ConcurrentHashMapV8.entryFor(this.nextKey, v)));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceEntriesToDoubleTask t = (MapReduceEntriesToDoubleTask)c;
                    MapReduceEntriesToDoubleTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.apply(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesToDoubleTask<K, V>
    extends Traverser<K, V, Double> {
        final ObjectToDouble<? super V> transformer;
        final DoubleByDoubleToDouble reducer;
        final double basis;
        double result;
        MapReduceValuesToDoubleTask<K, V> rights;
        MapReduceValuesToDoubleTask<K, V> nextRight;

        MapReduceValuesToDoubleTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, MapReduceValuesToDoubleTask<K, V> nextRight, ObjectToDouble<? super V> transformer, double basis, DoubleByDoubleToDouble reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleByDoubleToDouble reducer;
            ObjectToDouble<V> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Object v;
                int b;
                double r = this.basis;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new MapReduceValuesToDoubleTask<K, V>(this.map, this, b, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while ((v = this.advance()) != null) {
                    r = reducer.apply(r, transformer.apply(v));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceValuesToDoubleTask t = (MapReduceValuesToDoubleTask)c;
                    MapReduceValuesToDoubleTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.apply(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysToDoubleTask<K, V>
    extends Traverser<K, V, Double> {
        final ObjectToDouble<? super K> transformer;
        final DoubleByDoubleToDouble reducer;
        final double basis;
        double result;
        MapReduceKeysToDoubleTask<K, V> rights;
        MapReduceKeysToDoubleTask<K, V> nextRight;

        MapReduceKeysToDoubleTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, MapReduceKeysToDoubleTask<K, V> nextRight, ObjectToDouble<? super K> transformer, double basis, DoubleByDoubleToDouble reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.basis = basis;
            this.reducer = reducer;
        }

        @Override
        public final Double getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            DoubleByDoubleToDouble reducer;
            ObjectToDouble<K> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                int b;
                double r = this.basis;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new MapReduceKeysToDoubleTask<K, V>(this.map, this, b, this.rights, transformer, r, reducer);
                    this.rights.fork();
                }
                while (this.advance() != null) {
                    r = reducer.apply(r, transformer.apply(this.nextKey));
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceKeysToDoubleTask t = (MapReduceKeysToDoubleTask)c;
                    MapReduceKeysToDoubleTask<K, V> s = t.rights;
                    while (s != null) {
                        t.result = reducer.apply(t.result, s.result);
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceMappingsTask<K, V, U>
    extends Traverser<K, V, U> {
        final BiFun<? super K, ? super V, ? extends U> transformer;
        final BiFun<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceMappingsTask<K, V, U> rights;
        MapReduceMappingsTask<K, V, U> nextRight;

        MapReduceMappingsTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, MapReduceMappingsTask<K, V, U> nextRight, BiFun<? super K, ? super V, ? extends U> transformer, BiFun<? super U, ? super U, ? extends U> reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.reducer = reducer;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFun<U, U, U> reducer;
            BiFun<K, V, U> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Object v;
                int b;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new MapReduceMappingsTask<K, V, U>(this.map, this, b, this.rights, transformer, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while ((v = this.advance()) != null) {
                    U u = transformer.apply(this.nextKey, v);
                    if (u == null) continue;
                    r = r == null ? u : reducer.apply(r, u);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceMappingsTask t = (MapReduceMappingsTask)c;
                    MapReduceMappingsTask<K, V, U> s = t.rights;
                    while (s != null) {
                        U sr = s.result;
                        if (sr != null) {
                            U tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceEntriesTask<K, V, U>
    extends Traverser<K, V, U> {
        final Fun<Map.Entry<K, V>, ? extends U> transformer;
        final BiFun<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceEntriesTask<K, V, U> rights;
        MapReduceEntriesTask<K, V, U> nextRight;

        MapReduceEntriesTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, MapReduceEntriesTask<K, V, U> nextRight, Fun<Map.Entry<K, V>, ? extends U> transformer, BiFun<? super U, ? super U, ? extends U> reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.reducer = reducer;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFun<U, U, U> reducer;
            Fun<Map.Entry<K, V>, U> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Object v;
                int b;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new MapReduceEntriesTask<K, V, U>(this.map, this, b, this.rights, transformer, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while ((v = this.advance()) != null) {
                    U u = transformer.apply(ConcurrentHashMapV8.entryFor(this.nextKey, v));
                    if (u == null) continue;
                    r = r == null ? u : reducer.apply(r, u);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceEntriesTask t = (MapReduceEntriesTask)c;
                    MapReduceEntriesTask<K, V, U> s = t.rights;
                    while (s != null) {
                        U sr = s.result;
                        if (sr != null) {
                            U tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceValuesTask<K, V, U>
    extends Traverser<K, V, U> {
        final Fun<? super V, ? extends U> transformer;
        final BiFun<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceValuesTask<K, V, U> rights;
        MapReduceValuesTask<K, V, U> nextRight;

        MapReduceValuesTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, MapReduceValuesTask<K, V, U> nextRight, Fun<? super V, ? extends U> transformer, BiFun<? super U, ? super U, ? extends U> reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.reducer = reducer;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFun<U, U, U> reducer;
            Fun<V, U> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                Object v;
                int b;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new MapReduceValuesTask<K, V, U>(this.map, this, b, this.rights, transformer, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while ((v = this.advance()) != null) {
                    U u = transformer.apply(v);
                    if (u == null) continue;
                    r = r == null ? u : reducer.apply(r, u);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceValuesTask t = (MapReduceValuesTask)c;
                    MapReduceValuesTask<K, V, U> s = t.rights;
                    while (s != null) {
                        U sr = s.result;
                        if (sr != null) {
                            U tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class MapReduceKeysTask<K, V, U>
    extends Traverser<K, V, U> {
        final Fun<? super K, ? extends U> transformer;
        final BiFun<? super U, ? super U, ? extends U> reducer;
        U result;
        MapReduceKeysTask<K, V, U> rights;
        MapReduceKeysTask<K, V, U> nextRight;

        MapReduceKeysTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, MapReduceKeysTask<K, V, U> nextRight, Fun<? super K, ? extends U> transformer, BiFun<? super U, ? super U, ? extends U> reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.transformer = transformer;
            this.reducer = reducer;
        }

        @Override
        public final U getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFun<U, U, U> reducer;
            Fun<K, U> transformer = this.transformer;
            if (transformer != null && (reducer = this.reducer) != null) {
                int b;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new MapReduceKeysTask<K, V, U>(this.map, this, b, this.rights, transformer, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while (this.advance() != null) {
                    U u = transformer.apply(this.nextKey);
                    if (u == null) continue;
                    r = r == null ? u : reducer.apply(r, u);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    MapReduceKeysTask t = (MapReduceKeysTask)c;
                    MapReduceKeysTask<K, V, U> s = t.rights;
                    while (s != null) {
                        U sr = s.result;
                        if (sr != null) {
                            U tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class ReduceEntriesTask<K, V>
    extends Traverser<K, V, Map.Entry<K, V>> {
        final BiFun<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> reducer;
        Map.Entry<K, V> result;
        ReduceEntriesTask<K, V> rights;
        ReduceEntriesTask<K, V> nextRight;

        ReduceEntriesTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, ReduceEntriesTask<K, V> nextRight, BiFun<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.reducer = reducer;
        }

        @Override
        public final Map.Entry<K, V> getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFun<Map.Entry<K, V>, Map.Entry<K, V>, Map.Entry<K, V>> reducer = this.reducer;
            if (reducer != null) {
                Object v;
                int b;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new ReduceEntriesTask<K, V>(this.map, this, b, this.rights, reducer);
                    this.rights.fork();
                }
                AbstractMap.SimpleEntry r = null;
                while ((v = this.advance()) != null) {
                    AbstractMap.SimpleEntry u = ConcurrentHashMapV8.entryFor(this.nextKey, v);
                    r = r == null ? u : reducer.apply(r, u);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    ReduceEntriesTask t = (ReduceEntriesTask)c;
                    ReduceEntriesTask<K, V> s = t.rights;
                    while (s != null) {
                        Map.Entry<K, V> sr = s.result;
                        if (sr != null) {
                            Map.Entry<K, V> tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class ReduceValuesTask<K, V>
    extends Traverser<K, V, V> {
        final BiFun<? super V, ? super V, ? extends V> reducer;
        V result;
        ReduceValuesTask<K, V> rights;
        ReduceValuesTask<K, V> nextRight;

        ReduceValuesTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, ReduceValuesTask<K, V> nextRight, BiFun<? super V, ? super V, ? extends V> reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.reducer = reducer;
        }

        @Override
        public final V getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFun<V, V, V> reducer = this.reducer;
            if (reducer != null) {
                Object v;
                int b;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new ReduceValuesTask<K, V>(this.map, this, b, this.rights, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while ((v = this.advance()) != null) {
                    Object u = v;
                    r = r == null ? u : reducer.apply(r, u);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    ReduceValuesTask t = (ReduceValuesTask)c;
                    ReduceValuesTask<K, V> s = t.rights;
                    while (s != null) {
                        V sr = s.result;
                        if (sr != null) {
                            V tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class ReduceKeysTask<K, V>
    extends Traverser<K, V, K> {
        final BiFun<? super K, ? super K, ? extends K> reducer;
        K result;
        ReduceKeysTask<K, V> rights;
        ReduceKeysTask<K, V> nextRight;

        ReduceKeysTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, ReduceKeysTask<K, V> nextRight, BiFun<? super K, ? super K, ? extends K> reducer) {
            super(m, p, b);
            this.nextRight = nextRight;
            this.reducer = reducer;
        }

        @Override
        public final K getRawResult() {
            return this.result;
        }

        @Override
        public final void compute() {
            BiFun<K, K, K> reducer = this.reducer;
            if (reducer != null) {
                int b;
                while ((b = this.preSplit()) > 0) {
                    this.rights = new ReduceKeysTask<K, V>(this.map, this, b, this.rights, reducer);
                    this.rights.fork();
                }
                Object r = null;
                while (this.advance() != null) {
                    Object u = this.nextKey;
                    r = r == null ? u : reducer.apply(r, u);
                }
                this.result = r;
                for (CountedCompleter<?> c = this.firstComplete(); c != null; c = c.nextComplete()) {
                    ReduceKeysTask t = (ReduceKeysTask)c;
                    ReduceKeysTask<K, V> s = t.rights;
                    while (s != null) {
                        K sr = s.result;
                        if (sr != null) {
                            K tr = t.result;
                            t.result = tr == null ? sr : reducer.apply(tr, sr);
                        }
                        s = t.rights = s.nextRight;
                    }
                }
            }
        }
    }

    static final class SearchMappingsTask<K, V, U>
    extends Traverser<K, V, U> {
        final BiFun<? super K, ? super V, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchMappingsTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, BiFun<? super K, ? super V, ? extends U> searchFunction, AtomicReference<U> result) {
            super(m, p, b);
            this.searchFunction = searchFunction;
            this.result = result;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> result;
            BiFun<K, V, U> searchFunction = this.searchFunction;
            if (searchFunction != null && (result = this.result) != null) {
                while (true) {
                    if (result.get() != null) {
                        return;
                    }
                    int b = this.preSplit();
                    if (b <= 0) break;
                    new SearchMappingsTask<K, V, U>(this.map, this, b, searchFunction, result).fork();
                }
                while (result.get() == null) {
                    Object v = this.advance();
                    if (v == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u = searchFunction.apply(this.nextKey, v);
                    if (u == null) continue;
                    if (!result.compareAndSet(null, u)) break;
                    this.quietlyCompleteRoot();
                    break;
                }
            }
        }
    }

    static final class SearchEntriesTask<K, V, U>
    extends Traverser<K, V, U> {
        final Fun<Map.Entry<K, V>, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchEntriesTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, Fun<Map.Entry<K, V>, ? extends U> searchFunction, AtomicReference<U> result) {
            super(m, p, b);
            this.searchFunction = searchFunction;
            this.result = result;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> result;
            Fun<Map.Entry<K, V>, U> searchFunction = this.searchFunction;
            if (searchFunction != null && (result = this.result) != null) {
                while (true) {
                    if (result.get() != null) {
                        return;
                    }
                    int b = this.preSplit();
                    if (b <= 0) break;
                    new SearchEntriesTask<K, V, U>(this.map, this, b, searchFunction, result).fork();
                }
                while (result.get() == null) {
                    Object v = this.advance();
                    if (v == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u = searchFunction.apply(ConcurrentHashMapV8.entryFor(this.nextKey, v));
                    if (u == null) continue;
                    if (result.compareAndSet(null, u)) {
                        this.quietlyCompleteRoot();
                    }
                    return;
                }
            }
        }
    }

    static final class SearchValuesTask<K, V, U>
    extends Traverser<K, V, U> {
        final Fun<? super V, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchValuesTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, Fun<? super V, ? extends U> searchFunction, AtomicReference<U> result) {
            super(m, p, b);
            this.searchFunction = searchFunction;
            this.result = result;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> result;
            Fun<V, U> searchFunction = this.searchFunction;
            if (searchFunction != null && (result = this.result) != null) {
                while (true) {
                    if (result.get() != null) {
                        return;
                    }
                    int b = this.preSplit();
                    if (b <= 0) break;
                    new SearchValuesTask<K, V, U>(this.map, this, b, searchFunction, result).fork();
                }
                while (result.get() == null) {
                    Object v = this.advance();
                    if (v == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u = searchFunction.apply(v);
                    if (u == null) continue;
                    if (!result.compareAndSet(null, u)) break;
                    this.quietlyCompleteRoot();
                    break;
                }
            }
        }
    }

    static final class SearchKeysTask<K, V, U>
    extends Traverser<K, V, U> {
        final Fun<? super K, ? extends U> searchFunction;
        final AtomicReference<U> result;

        SearchKeysTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, Fun<? super K, ? extends U> searchFunction, AtomicReference<U> result) {
            super(m, p, b);
            this.searchFunction = searchFunction;
            this.result = result;
        }

        @Override
        public final U getRawResult() {
            return this.result.get();
        }

        @Override
        public final void compute() {
            AtomicReference<U> result;
            Fun<K, U> searchFunction = this.searchFunction;
            if (searchFunction != null && (result = this.result) != null) {
                while (true) {
                    if (result.get() != null) {
                        return;
                    }
                    int b = this.preSplit();
                    if (b <= 0) break;
                    new SearchKeysTask<K, V, U>(this.map, this, b, searchFunction, result).fork();
                }
                while (result.get() == null) {
                    if (this.advance() == null) {
                        this.propagateCompletion();
                        break;
                    }
                    U u = searchFunction.apply(this.nextKey);
                    if (u == null) continue;
                    if (!result.compareAndSet(null, u)) break;
                    this.quietlyCompleteRoot();
                    break;
                }
            }
        }
    }

    static final class ForEachTransformedMappingTask<K, V, U>
    extends Traverser<K, V, Void> {
        final BiFun<? super K, ? super V, ? extends U> transformer;
        final Action<U> action;

        ForEachTransformedMappingTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, BiFun<? super K, ? super V, ? extends U> transformer, Action<U> action) {
            super(m, p, b);
            this.transformer = transformer;
            this.action = action;
        }

        @Override
        public final void compute() {
            Action<U> action;
            BiFun<K, V, U> transformer = this.transformer;
            if (transformer != null && (action = this.action) != null) {
                Object v;
                int b;
                while ((b = this.preSplit()) > 0) {
                    new ForEachTransformedMappingTask<K, V, U>(this.map, this, b, transformer, action).fork();
                }
                while ((v = this.advance()) != null) {
                    U u = transformer.apply(this.nextKey, v);
                    if (u == null) continue;
                    action.apply(u);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachTransformedEntryTask<K, V, U>
    extends Traverser<K, V, Void> {
        final Fun<Map.Entry<K, V>, ? extends U> transformer;
        final Action<U> action;

        ForEachTransformedEntryTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, Fun<Map.Entry<K, V>, ? extends U> transformer, Action<U> action) {
            super(m, p, b);
            this.transformer = transformer;
            this.action = action;
        }

        @Override
        public final void compute() {
            Action<U> action;
            Fun<Map.Entry<K, V>, U> transformer = this.transformer;
            if (transformer != null && (action = this.action) != null) {
                Object v;
                int b;
                while ((b = this.preSplit()) > 0) {
                    new ForEachTransformedEntryTask<K, V, U>(this.map, this, b, transformer, action).fork();
                }
                while ((v = this.advance()) != null) {
                    U u = transformer.apply(ConcurrentHashMapV8.entryFor(this.nextKey, v));
                    if (u == null) continue;
                    action.apply(u);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachTransformedValueTask<K, V, U>
    extends Traverser<K, V, Void> {
        final Fun<? super V, ? extends U> transformer;
        final Action<U> action;

        ForEachTransformedValueTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, Fun<? super V, ? extends U> transformer, Action<U> action) {
            super(m, p, b);
            this.transformer = transformer;
            this.action = action;
        }

        @Override
        public final void compute() {
            Action<U> action;
            Fun<V, U> transformer = this.transformer;
            if (transformer != null && (action = this.action) != null) {
                Object v;
                int b;
                while ((b = this.preSplit()) > 0) {
                    new ForEachTransformedValueTask<K, V, U>(this.map, this, b, transformer, action).fork();
                }
                while ((v = this.advance()) != null) {
                    U u = transformer.apply(v);
                    if (u == null) continue;
                    action.apply(u);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachTransformedKeyTask<K, V, U>
    extends Traverser<K, V, Void> {
        final Fun<? super K, ? extends U> transformer;
        final Action<U> action;

        ForEachTransformedKeyTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, Fun<? super K, ? extends U> transformer, Action<U> action) {
            super(m, p, b);
            this.transformer = transformer;
            this.action = action;
        }

        @Override
        public final void compute() {
            Action<U> action;
            Fun<K, U> transformer = this.transformer;
            if (transformer != null && (action = this.action) != null) {
                int b;
                while ((b = this.preSplit()) > 0) {
                    new ForEachTransformedKeyTask<K, V, U>(this.map, this, b, transformer, action).fork();
                }
                while (this.advance() != null) {
                    U u = transformer.apply(this.nextKey);
                    if (u == null) continue;
                    action.apply(u);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachMappingTask<K, V>
    extends Traverser<K, V, Void> {
        final BiAction<K, V> action;

        ForEachMappingTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, BiAction<K, V> action) {
            super(m, p, b);
            this.action = action;
        }

        @Override
        public final void compute() {
            BiAction<K, V> action = this.action;
            if (action != null) {
                Object v;
                int b;
                while ((b = this.preSplit()) > 0) {
                    new ForEachMappingTask<K, V>(this.map, this, b, action).fork();
                }
                while ((v = this.advance()) != null) {
                    action.apply(this.nextKey, v);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachEntryTask<K, V>
    extends Traverser<K, V, Void> {
        final Action<Map.Entry<K, V>> action;

        ForEachEntryTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, Action<Map.Entry<K, V>> action) {
            super(m, p, b);
            this.action = action;
        }

        @Override
        public final void compute() {
            Action<Map.Entry<K, V>> action = this.action;
            if (action != null) {
                Object v;
                int b;
                while ((b = this.preSplit()) > 0) {
                    new ForEachEntryTask<K, V>(this.map, this, b, action).fork();
                }
                while ((v = this.advance()) != null) {
                    action.apply(ConcurrentHashMapV8.entryFor(this.nextKey, v));
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachValueTask<K, V>
    extends Traverser<K, V, Void> {
        final Action<V> action;

        ForEachValueTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, Action<V> action) {
            super(m, p, b);
            this.action = action;
        }

        @Override
        public final void compute() {
            Action<V> action = this.action;
            if (action != null) {
                Object v;
                int b;
                while ((b = this.preSplit()) > 0) {
                    new ForEachValueTask<K, V>(this.map, this, b, action).fork();
                }
                while ((v = this.advance()) != null) {
                    action.apply(v);
                }
                this.propagateCompletion();
            }
        }
    }

    static final class ForEachKeyTask<K, V>
    extends Traverser<K, V, Void> {
        final Action<K> action;

        ForEachKeyTask(ConcurrentHashMapV8<K, V> m, Traverser<K, V, ?> p, int b, Action<K> action) {
            super(m, p, b);
            this.action = action;
        }

        @Override
        public final void compute() {
            Action<K> action = this.action;
            if (action != null) {
                int b;
                while ((b = this.preSplit()) > 0) {
                    new ForEachKeyTask<K, V>(this.map, this, b, action).fork();
                }
                while (this.advance() != null) {
                    action.apply(this.nextKey);
                }
                this.propagateCompletion();
            }
        }
    }

    public static class ForkJoinTasks {
        private ForkJoinTasks() {
        }

        public static <K, V> ForkJoinTask<Void> forEach(ConcurrentHashMapV8<K, V> map, BiAction<K, V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            return new ForEachMappingTask<K, V>(map, null, -1, action);
        }

        public static <K, V, U> ForkJoinTask<Void> forEach(ConcurrentHashMapV8<K, V> map, BiFun<? super K, ? super V, ? extends U> transformer, Action<U> action) {
            if (transformer == null || action == null) {
                throw new NullPointerException();
            }
            return new ForEachTransformedMappingTask<K, V, U>(map, null, -1, transformer, action);
        }

        public static <K, V, U> ForkJoinTask<U> search(ConcurrentHashMapV8<K, V> map, BiFun<? super K, ? super V, ? extends U> searchFunction) {
            if (searchFunction == null) {
                throw new NullPointerException();
            }
            return new SearchMappingsTask<K, V, U>(map, null, -1, searchFunction, new AtomicReference());
        }

        public static <K, V, U> ForkJoinTask<U> reduce(ConcurrentHashMapV8<K, V> map, BiFun<? super K, ? super V, ? extends U> transformer, BiFun<? super U, ? super U, ? extends U> reducer) {
            if (transformer == null || reducer == null) {
                throw new NullPointerException();
            }
            return new MapReduceMappingsTask<K, V, U>(map, null, -1, null, transformer, reducer);
        }

        public static <K, V> ForkJoinTask<Double> reduceToDouble(ConcurrentHashMapV8<K, V> map, ObjectByObjectToDouble<? super K, ? super V> transformer, double basis, DoubleByDoubleToDouble reducer) {
            if (transformer == null || reducer == null) {
                throw new NullPointerException();
            }
            return new MapReduceMappingsToDoubleTask<K, V>(map, null, -1, null, transformer, basis, reducer);
        }

        public static <K, V> ForkJoinTask<Long> reduceToLong(ConcurrentHashMapV8<K, V> map, ObjectByObjectToLong<? super K, ? super V> transformer, long basis, LongByLongToLong reducer) {
            if (transformer == null || reducer == null) {
                throw new NullPointerException();
            }
            return new MapReduceMappingsToLongTask<K, V>(map, null, -1, null, transformer, basis, reducer);
        }

        public static <K, V> ForkJoinTask<Integer> reduceToInt(ConcurrentHashMapV8<K, V> map, ObjectByObjectToInt<? super K, ? super V> transformer, int basis, IntByIntToInt reducer) {
            if (transformer == null || reducer == null) {
                throw new NullPointerException();
            }
            return new MapReduceMappingsToIntTask<K, V>(map, null, -1, null, transformer, basis, reducer);
        }

        public static <K, V> ForkJoinTask<Void> forEachKey(ConcurrentHashMapV8<K, V> map, Action<K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            return new ForEachKeyTask<K, V>(map, null, -1, action);
        }

        public static <K, V, U> ForkJoinTask<Void> forEachKey(ConcurrentHashMapV8<K, V> map, Fun<? super K, ? extends U> transformer, Action<U> action) {
            if (transformer == null || action == null) {
                throw new NullPointerException();
            }
            return new ForEachTransformedKeyTask<K, V, U>(map, null, -1, transformer, action);
        }

        public static <K, V, U> ForkJoinTask<U> searchKeys(ConcurrentHashMapV8<K, V> map, Fun<? super K, ? extends U> searchFunction) {
            if (searchFunction == null) {
                throw new NullPointerException();
            }
            return new SearchKeysTask<K, V, U>(map, null, -1, searchFunction, new AtomicReference());
        }

        public static <K, V> ForkJoinTask<K> reduceKeys(ConcurrentHashMapV8<K, V> map, BiFun<? super K, ? super K, ? extends K> reducer) {
            if (reducer == null) {
                throw new NullPointerException();
            }
            return new ReduceKeysTask<K, V>(map, null, -1, null, reducer);
        }

        public static <K, V, U> ForkJoinTask<U> reduceKeys(ConcurrentHashMapV8<K, V> map, Fun<? super K, ? extends U> transformer, BiFun<? super U, ? super U, ? extends U> reducer) {
            if (transformer == null || reducer == null) {
                throw new NullPointerException();
            }
            return new MapReduceKeysTask<K, V, U>(map, null, -1, null, transformer, reducer);
        }

        public static <K, V> ForkJoinTask<Double> reduceKeysToDouble(ConcurrentHashMapV8<K, V> map, ObjectToDouble<? super K> transformer, double basis, DoubleByDoubleToDouble reducer) {
            if (transformer == null || reducer == null) {
                throw new NullPointerException();
            }
            return new MapReduceKeysToDoubleTask<K, V>(map, null, -1, null, transformer, basis, reducer);
        }

        public static <K, V> ForkJoinTask<Long> reduceKeysToLong(ConcurrentHashMapV8<K, V> map, ObjectToLong<? super K> transformer, long basis, LongByLongToLong reducer) {
            if (transformer == null || reducer == null) {
                throw new NullPointerException();
            }
            return new MapReduceKeysToLongTask<K, V>(map, null, -1, null, transformer, basis, reducer);
        }

        public static <K, V> ForkJoinTask<Integer> reduceKeysToInt(ConcurrentHashMapV8<K, V> map, ObjectToInt<? super K> transformer, int basis, IntByIntToInt reducer) {
            if (transformer == null || reducer == null) {
                throw new NullPointerException();
            }
            return new MapReduceKeysToIntTask<K, V>(map, null, -1, null, transformer, basis, reducer);
        }

        public static <K, V> ForkJoinTask<Void> forEachValue(ConcurrentHashMapV8<K, V> map, Action<V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            return new ForEachValueTask<K, V>(map, null, -1, action);
        }

        public static <K, V, U> ForkJoinTask<Void> forEachValue(ConcurrentHashMapV8<K, V> map, Fun<? super V, ? extends U> transformer, Action<U> action) {
            if (transformer == null || action == null) {
                throw new NullPointerException();
            }
            return new ForEachTransformedValueTask<K, V, U>(map, null, -1, transformer, action);
        }

        public static <K, V, U> ForkJoinTask<U> searchValues(ConcurrentHashMapV8<K, V> map, Fun<? super V, ? extends U> searchFunction) {
            if (searchFunction == null) {
                throw new NullPointerException();
            }
            return new SearchValuesTask<K, V, U>(map, null, -1, searchFunction, new AtomicReference());
        }

        public static <K, V> ForkJoinTask<V> reduceValues(ConcurrentHashMapV8<K, V> map, BiFun<? super V, ? super V, ? extends V> reducer) {
            if (reducer == null) {
                throw new NullPointerException();
            }
            return new ReduceValuesTask<K, V>(map, null, -1, null, reducer);
        }

        public static <K, V, U> ForkJoinTask<U> reduceValues(ConcurrentHashMapV8<K, V> map, Fun<? super V, ? extends U> transformer, BiFun<? super U, ? super U, ? extends U> reducer) {
            if (transformer == null || reducer == null) {
                throw new NullPointerException();
            }
            return new MapReduceValuesTask<K, V, U>(map, null, -1, null, transformer, reducer);
        }

        public static <K, V> ForkJoinTask<Double> reduceValuesToDouble(ConcurrentHashMapV8<K, V> map, ObjectToDouble<? super V> transformer, double basis, DoubleByDoubleToDouble reducer) {
            if (transformer == null || reducer == null) {
                throw new NullPointerException();
            }
            return new MapReduceValuesToDoubleTask<K, V>(map, null, -1, null, transformer, basis, reducer);
        }

        public static <K, V> ForkJoinTask<Long> reduceValuesToLong(ConcurrentHashMapV8<K, V> map, ObjectToLong<? super V> transformer, long basis, LongByLongToLong reducer) {
            if (transformer == null || reducer == null) {
                throw new NullPointerException();
            }
            return new MapReduceValuesToLongTask<K, V>(map, null, -1, null, transformer, basis, reducer);
        }

        public static <K, V> ForkJoinTask<Integer> reduceValuesToInt(ConcurrentHashMapV8<K, V> map, ObjectToInt<? super V> transformer, int basis, IntByIntToInt reducer) {
            if (transformer == null || reducer == null) {
                throw new NullPointerException();
            }
            return new MapReduceValuesToIntTask<K, V>(map, null, -1, null, transformer, basis, reducer);
        }

        public static <K, V> ForkJoinTask<Void> forEachEntry(ConcurrentHashMapV8<K, V> map, Action<Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            return new ForEachEntryTask<K, V>(map, null, -1, action);
        }

        public static <K, V, U> ForkJoinTask<Void> forEachEntry(ConcurrentHashMapV8<K, V> map, Fun<Map.Entry<K, V>, ? extends U> transformer, Action<U> action) {
            if (transformer == null || action == null) {
                throw new NullPointerException();
            }
            return new ForEachTransformedEntryTask<K, V, U>(map, null, -1, transformer, action);
        }

        public static <K, V, U> ForkJoinTask<U> searchEntries(ConcurrentHashMapV8<K, V> map, Fun<Map.Entry<K, V>, ? extends U> searchFunction) {
            if (searchFunction == null) {
                throw new NullPointerException();
            }
            return new SearchEntriesTask<K, V, U>(map, null, -1, searchFunction, new AtomicReference());
        }

        public static <K, V> ForkJoinTask<Map.Entry<K, V>> reduceEntries(ConcurrentHashMapV8<K, V> map, BiFun<Map.Entry<K, V>, Map.Entry<K, V>, ? extends Map.Entry<K, V>> reducer) {
            if (reducer == null) {
                throw new NullPointerException();
            }
            return new ReduceEntriesTask<K, V>(map, null, -1, null, reducer);
        }

        public static <K, V, U> ForkJoinTask<U> reduceEntries(ConcurrentHashMapV8<K, V> map, Fun<Map.Entry<K, V>, ? extends U> transformer, BiFun<? super U, ? super U, ? extends U> reducer) {
            if (transformer == null || reducer == null) {
                throw new NullPointerException();
            }
            return new MapReduceEntriesTask<K, V, U>(map, null, -1, null, transformer, reducer);
        }

        public static <K, V> ForkJoinTask<Double> reduceEntriesToDouble(ConcurrentHashMapV8<K, V> map, ObjectToDouble<Map.Entry<K, V>> transformer, double basis, DoubleByDoubleToDouble reducer) {
            if (transformer == null || reducer == null) {
                throw new NullPointerException();
            }
            return new MapReduceEntriesToDoubleTask<K, V>(map, null, -1, null, transformer, basis, reducer);
        }

        public static <K, V> ForkJoinTask<Long> reduceEntriesToLong(ConcurrentHashMapV8<K, V> map, ObjectToLong<Map.Entry<K, V>> transformer, long basis, LongByLongToLong reducer) {
            if (transformer == null || reducer == null) {
                throw new NullPointerException();
            }
            return new MapReduceEntriesToLongTask<K, V>(map, null, -1, null, transformer, basis, reducer);
        }

        public static <K, V> ForkJoinTask<Integer> reduceEntriesToInt(ConcurrentHashMapV8<K, V> map, ObjectToInt<Map.Entry<K, V>> transformer, int basis, IntByIntToInt reducer) {
            if (transformer == null || reducer == null) {
                throw new NullPointerException();
            }
            return new MapReduceEntriesToIntTask<K, V>(map, null, -1, null, transformer, basis, reducer);
        }
    }

    public static final class EntrySetView<K, V>
    extends CHMView<K, V>
    implements Set<Map.Entry<K, V>> {
        EntrySetView(ConcurrentHashMapV8<K, V> map) {
            super(map);
        }

        @Override
        public final boolean contains(Object o) {
            Object v;
            Object r;
            Map.Entry e;
            Object k;
            return o instanceof Map.Entry && (k = (e = (Map.Entry)o).getKey()) != null && (r = this.map.get(k)) != null && (v = e.getValue()) != null && (v == r || v.equals(r));
        }

        @Override
        public final boolean remove(Object o) {
            Object v;
            Map.Entry e;
            Object k;
            return o instanceof Map.Entry && (k = (e = (Map.Entry)o).getKey()) != null && (v = e.getValue()) != null && this.map.remove(k, v);
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.map);
        }

        @Override
        public final boolean add(Map.Entry<K, V> e) {
            return this.map.internalPut(e.getKey(), e.getValue(), false) == null;
        }

        @Override
        public final boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            boolean added = false;
            for (Map.Entry<K, V> e : c) {
                if (!this.add(e)) continue;
                added = true;
            }
            return added;
        }

        @Override
        public boolean equals(Object o) {
            Set c;
            return o instanceof Set && ((c = (Set)o) == this || this.containsAll(c) && c.containsAll(this));
        }
    }

    public static final class ValuesView<K, V>
    extends CHMView<K, V>
    implements Collection<V> {
        ValuesView(ConcurrentHashMapV8<K, V> map) {
            super(map);
        }

        @Override
        public final boolean contains(Object o) {
            return this.map.containsValue(o);
        }

        @Override
        public final boolean remove(Object o) {
            if (o != null) {
                ValueIterator it = new ValueIterator(this.map);
                while (it.hasNext()) {
                    if (!o.equals(it.next())) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator(this.map);
        }

        @Override
        public final boolean add(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends V> c) {
            throw new UnsupportedOperationException();
        }
    }

    public static class KeySetView<K, V>
    extends CHMView<K, V>
    implements Set<K>,
    Serializable {
        private static final long serialVersionUID = 7249069246763182397L;
        private final V value;

        KeySetView(ConcurrentHashMapV8<K, V> map, V value) {
            super(map);
            this.value = value;
        }

        public V getMappedValue() {
            return this.value;
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(o) != null;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(this.map);
        }

        @Override
        public boolean add(K e) {
            V v = this.value;
            if (v == null) {
                throw new UnsupportedOperationException();
            }
            return this.map.internalPut(e, v, true) == null;
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            boolean added = false;
            V v = this.value;
            if (v == null) {
                throw new UnsupportedOperationException();
            }
            for (K e : c) {
                if (this.map.internalPut(e, v, true) != null) continue;
                added = true;
            }
            return added;
        }

        @Override
        public boolean equals(Object o) {
            Set c;
            return o instanceof Set && ((c = (Set)o) == this || this.containsAll(c) && c.containsAll(this));
        }
    }

    static abstract class CHMView<K, V> {
        final ConcurrentHashMapV8<K, V> map;
        private static final String oomeMsg = "Required array size too large";

        CHMView(ConcurrentHashMapV8<K, V> map) {
            this.map = map;
        }

        public ConcurrentHashMapV8<K, V> getMap() {
            return this.map;
        }

        public final int size() {
            return this.map.size();
        }

        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        public final void clear() {
            this.map.clear();
        }

        public abstract Iterator<?> iterator();

        public abstract boolean contains(Object var1);

        public abstract boolean remove(Object var1);

        public final Object[] toArray() {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(oomeMsg);
            }
            int n = (int)sz;
            Object[] r = new Object[n];
            int i = 0;
            Iterator<?> it = this.iterator();
            while (it.hasNext()) {
                if (i == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(oomeMsg);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i++] = it.next();
            }
            return i == n ? r : Arrays.copyOf(r, i);
        }

        public final <T> T[] toArray(T[] a) {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(oomeMsg);
            }
            int m = (int)sz;
            T[] r = a.length >= m ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), m);
            int n = r.length;
            int i = 0;
            Iterator<?> it = this.iterator();
            while (it.hasNext()) {
                if (i == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(oomeMsg);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i++] = it.next();
            }
            if (a == r && i < n) {
                r[i] = null;
                return r;
            }
            return i == n ? r : Arrays.copyOf(r, i);
        }

        public final int hashCode() {
            int h = 0;
            Iterator<?> it = this.iterator();
            while (it.hasNext()) {
                h += it.next().hashCode();
            }
            return h;
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Iterator<?> it = this.iterator();
            if (it.hasNext()) {
                while (true) {
                    Object e;
                    sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
                    if (!it.hasNext()) break;
                    sb.append(',').append(' ');
                }
            }
            return sb.append(']').toString();
        }

        public final boolean containsAll(Collection<?> c) {
            if (c != this) {
                for (Object e : c) {
                    if (e != null && this.contains(e)) continue;
                    return false;
                }
            }
            return true;
        }

        public final boolean removeAll(Collection<?> c) {
            boolean modified = false;
            Iterator<?> it = this.iterator();
            while (it.hasNext()) {
                if (!c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        public final boolean retainAll(Collection<?> c) {
            boolean modified = false;
            Iterator<?> it = this.iterator();
            while (it.hasNext()) {
                if (c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }
    }

    public static interface IntByIntToInt {
        public int apply(int var1, int var2);
    }

    public static interface LongByLongToLong {
        public long apply(long var1, long var3);
    }

    public static interface DoubleByDoubleToDouble {
        public double apply(double var1, double var3);
    }

    public static interface IntToInt {
        public int apply(int var1);
    }

    public static interface LongToLong {
        public long apply(long var1);
    }

    public static interface DoubleToDouble {
        public double apply(double var1);
    }

    public static interface ObjectByObjectToInt<A, B> {
        public int apply(A var1, B var2);
    }

    public static interface ObjectByObjectToLong<A, B> {
        public long apply(A var1, B var2);
    }

    public static interface ObjectByObjectToDouble<A, B> {
        public double apply(A var1, B var2);
    }

    public static interface ObjectToInt<A> {
        public int apply(A var1);
    }

    public static interface ObjectToLong<A> {
        public long apply(A var1);
    }

    public static interface ObjectToDouble<A> {
        public double apply(A var1);
    }

    public static interface Generator<T> {
        public T apply();
    }

    public static interface BiFun<A, B, T> {
        public T apply(A var1, B var2);
    }

    public static interface Fun<A, T> {
        public T apply(A var1);
    }

    public static interface BiAction<A, B> {
        public void apply(A var1, B var2);
    }

    public static interface Action<A> {
        public void apply(A var1);
    }

    static class Segment<K, V>
    implements Serializable {
        private static final long serialVersionUID = 2249069246763182397L;
        final float loadFactor;

        Segment(float lf) {
            this.loadFactor = lf;
        }
    }

    static final class MapEntry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        V val;
        final ConcurrentHashMapV8<K, V> map;

        MapEntry(K key, V val, ConcurrentHashMapV8<K, V> map) {
            this.key = key;
            this.val = val;
            this.map = map;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.val;
        }

        @Override
        public final int hashCode() {
            return this.key.hashCode() ^ this.val.hashCode();
        }

        public final String toString() {
            return this.key + "=" + this.val;
        }

        @Override
        public final boolean equals(Object o) {
            Object v;
            Map.Entry e;
            Object k;
            return !(!(o instanceof Map.Entry) || (k = (e = (Map.Entry)o).getKey()) == null || (v = e.getValue()) == null || k != this.key && !k.equals(this.key) || v != this.val && !v.equals(this.val));
        }

        @Override
        public final V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            V v = this.val;
            this.val = value;
            this.map.put(this.key, value);
            return v;
        }
    }

    static final class EntryIterator<K, V>
    extends Traverser<K, V, Object>
    implements Spliterator<Map.Entry<K, V>> {
        EntryIterator(ConcurrentHashMapV8<K, V> map) {
            super(map);
        }

        EntryIterator(ConcurrentHashMapV8<K, V> map, Traverser<K, V, Object> it) {
            super(map, it, -1);
        }

        public EntryIterator<K, V> split() {
            if (this.nextKey != null) {
                throw new IllegalStateException();
            }
            return new EntryIterator<K, V>(this.map, this);
        }

        @Override
        public final Map.Entry<K, V> next() {
            Object v = this.nextVal;
            if (v == null && (v = this.advance()) == null) {
                throw new NoSuchElementException();
            }
            Object k = this.nextKey;
            this.nextVal = null;
            return new MapEntry<Object, Object>(k, v, this.map);
        }
    }

    static final class ValueIterator<K, V>
    extends Traverser<K, V, Object>
    implements Spliterator<V>,
    Enumeration<V> {
        ValueIterator(ConcurrentHashMapV8<K, V> map) {
            super(map);
        }

        ValueIterator(ConcurrentHashMapV8<K, V> map, Traverser<K, V, Object> it) {
            super(map, it, -1);
        }

        public ValueIterator<K, V> split() {
            if (this.nextKey != null) {
                throw new IllegalStateException();
            }
            return new ValueIterator<K, V>(this.map, this);
        }

        @Override
        public final V next() {
            Object v = this.nextVal;
            if (v == null && (v = this.advance()) == null) {
                throw new NoSuchElementException();
            }
            this.nextVal = null;
            return (V)v;
        }

        @Override
        public final V nextElement() {
            return this.next();
        }
    }

    static final class KeyIterator<K, V>
    extends Traverser<K, V, Object>
    implements Spliterator<K>,
    Enumeration<K> {
        KeyIterator(ConcurrentHashMapV8<K, V> map) {
            super(map);
        }

        KeyIterator(ConcurrentHashMapV8<K, V> map, Traverser<K, V, Object> it) {
            super(map, it, -1);
        }

        public KeyIterator<K, V> split() {
            if (this.nextKey != null) {
                throw new IllegalStateException();
            }
            return new KeyIterator<K, V>(this.map, this);
        }

        @Override
        public final K next() {
            if (this.nextVal == null && this.advance() == null) {
                throw new NoSuchElementException();
            }
            Object k = this.nextKey;
            this.nextVal = null;
            return (K)k;
        }

        @Override
        public final K nextElement() {
            return this.next();
        }
    }

    static class Traverser<K, V, R>
    extends CountedCompleter<R> {
        final ConcurrentHashMapV8<K, V> map;
        Node<V> next;
        Object nextKey;
        V nextVal;
        Node<V>[] tab;
        int index;
        int baseIndex;
        int baseLimit;
        int baseSize;
        int batch;

        Traverser(ConcurrentHashMapV8<K, V> map) {
            this.map = map;
        }

        Traverser(ConcurrentHashMapV8<K, V> map, Traverser<K, V, ?> it, int batch) {
            super(it);
            this.batch = batch;
            this.map = map;
            if (this.map != null && it != null) {
                Node<V>[] t = it.tab;
                if (it.tab == null) {
                    it.tab = map.table;
                    t = map.table;
                    if (t != null) {
                        it.baseLimit = it.baseSize = t.length;
                    }
                }
                this.tab = t;
                this.baseSize = it.baseSize;
                int hi = this.baseLimit = it.baseLimit;
                this.index = this.baseIndex = hi + it.baseIndex + 1 >>> 1;
                it.baseLimit = this.baseIndex;
            }
        }

        final V advance() {
            Object v;
            Node<V> e = this.next;
            V ev = null;
            block0: do {
                if (e != null) {
                    e = e.next;
                }
                while (e == null) {
                    int n;
                    int i;
                    int n2;
                    Node<V>[] t = this.tab;
                    if (this.tab != null) {
                        n2 = t.length;
                    } else {
                        ConcurrentHashMapV8<K, V> m = this.map;
                        if (m == null) break block0;
                        this.tab = m.table;
                        t = m.table;
                        if (t == null) break block0;
                        this.baseLimit = this.baseSize = t.length;
                        n2 = this.baseSize;
                    }
                    int b = this.baseIndex;
                    if (b >= this.baseLimit || (i = this.index) < 0 || i >= n2) break block0;
                    e = ConcurrentHashMapV8.tabAt(t, i);
                    if (e != null && e.hash < 0) {
                        Object ek = e.key;
                        if (ek instanceof TreeBin) {
                            e = ((TreeBin)ek).first;
                        } else {
                            this.tab = (Node[])ek;
                            continue;
                        }
                    }
                    if ((i += this.baseSize) < n2) {
                        n = i;
                    } else {
                        n = b + 1;
                        this.baseIndex = this.baseIndex;
                    }
                    this.index = n;
                }
                this.nextKey = e.key;
                v = e.val;
                ev = v;
            } while (v == null);
            this.next = e;
            this.nextVal = ev;
            return this.nextVal;
        }

        public final void remove() {
            Object k = this.nextKey;
            if (k == null && (this.advance() == null || (k = this.nextKey) == null)) {
                throw new IllegalStateException();
            }
            ((ConcurrentHashMapV8)this.map).internalReplace(k, null, null);
        }

        public final boolean hasNext() {
            return this.nextVal != null || this.advance() != null;
        }

        public final boolean hasMoreElements() {
            return this.hasNext();
        }

        @Override
        public void compute() {
        }

        final int preSplit() {
            ConcurrentHashMapV8<K, V> m;
            int b = this.batch;
            if (b < 0 && (m = this.map) != null) {
                Node<V>[] t = this.tab;
                if (this.tab == null) {
                    this.tab = m.table;
                    t = m.table;
                    if (t != null) {
                        this.baseLimit = this.baseSize = t.length;
                    }
                }
                if (t != null) {
                    long n = m.sumCount();
                    ForkJoinPool pool = Traverser.getPool();
                    int par = pool == null ? ForkJoinPool.getCommonPoolParallelism() : pool.getParallelism();
                    int sp = par << 3;
                    int n2 = b = n <= 0L ? 0 : (n < (long)sp ? (int)n : sp);
                }
            }
            if ((this.batch = (b = b <= 1 || this.baseIndex == this.baseLimit ? 0 : b >>> 1)) > 0) {
                this.addToPendingCount(1);
            }
            return b;
        }
    }

    static final class TreeBin<V>
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 2249069246763182397L;
        transient TreeNode<V> root;
        transient TreeNode<V> first;

        TreeBin() {
        }

        @Override
        public final boolean isHeldExclusively() {
            return this.getState() > 0;
        }

        @Override
        public final boolean tryAcquire(int ignore) {
            if (this.compareAndSetState(0, 1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }

        @Override
        public final boolean tryRelease(int ignore) {
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        @Override
        public final int tryAcquireShared(int ignore) {
            int c;
            do {
                if ((c = this.getState()) <= 0) continue;
                return -1;
            } while (!this.compareAndSetState(c, c - 1));
            return 1;
        }

        @Override
        public final boolean tryReleaseShared(int ignore) {
            int c;
            while (!this.compareAndSetState(c = this.getState(), c + 1)) {
            }
            return c == -1;
        }

        private void rotateLeft(TreeNode<V> p) {
            if (p != null) {
                TreeNode r = p.right;
                p.right = r.left;
                TreeNode rl = p.right;
                if (p.right != null) {
                    rl.parent = p;
                }
                TreeNode pp = r.parent = p.parent;
                if (r.parent == null) {
                    this.root = r;
                } else if (pp.left == p) {
                    pp.left = r;
                } else {
                    pp.right = r;
                }
                r.left = p;
                p.parent = r;
            }
        }

        private void rotateRight(TreeNode<V> p) {
            if (p != null) {
                TreeNode l = p.left;
                p.left = l.right;
                TreeNode lr = p.left;
                if (p.left != null) {
                    lr.parent = p;
                }
                TreeNode pp = l.parent = p.parent;
                if (l.parent == null) {
                    this.root = l;
                } else if (pp.right == p) {
                    pp.right = l;
                } else {
                    pp.left = l;
                }
                l.right = p;
                p.parent = l;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final TreeNode<V> getTreeNode(int h, Object k, TreeNode<V> p) {
            Class<?> c = k.getClass();
            while (p != null) {
                int dir;
                int ph = p.hash;
                if (ph == h) {
                    Object pk = p.key;
                    if (pk == k || k.equals(pk)) {
                        return p;
                    }
                    Class<?> pc = pk.getClass();
                    if (!(c == pc && k instanceof Comparable && (dir = ((Comparable)k).compareTo((Comparable)pk)) != 0 || (dir = c == pc ? 0 : c.getName().compareTo(pc.getName())) != 0)) {
                        TreeNode r = null;
                        TreeNode pr = p.right;
                        if (pr != null && h >= pr.hash && (r = this.getTreeNode(h, k, pr)) != null) {
                            return r;
                        }
                        TreeNode pl = p.left;
                        if (pl == null || h > pl.hash) return null;
                        dir = -1;
                    }
                } else {
                    dir = h < ph ? -1 : 1;
                }
                p = dir > 0 ? p.right : p.left;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final V getValue(int h, Object k) {
            TreeNode<V> r = null;
            int c = this.getState();
            Node e = this.first;
            while (e != null) {
                if (c <= 0 && this.compareAndSetState(c, c - 1)) {
                    try {
                        r = this.getTreeNode(h, k, this.root);
                        break;
                    }
                    finally {
                        this.releaseShared(0);
                    }
                }
                if (e.hash == h && k.equals(e.key)) {
                    r = e;
                    break;
                }
                c = this.getState();
                e = e.next;
            }
            return r == null ? null : (V)r.val;
        }

        final TreeNode<V> putTreeNode(int h, Object k, V v) {
            TreeNode<V> r;
            Class<?> c = k.getClass();
            TreeNode<V> pp = this.root;
            TreeNode<V> p = null;
            int dir = 0;
            while (pp != null) {
                p = pp;
                int ph = p.hash;
                if (ph == h) {
                    Object pk = p.key;
                    if (pk == k || k.equals(pk)) {
                        return p;
                    }
                    Class<?> pc = pk.getClass();
                    if (c != pc || !(k instanceof Comparable) || (dir = ((Comparable)k).compareTo((Comparable)pk)) == 0) {
                        TreeNode pr;
                        TreeNode s = null;
                        r = null;
                        dir = c == pc ? 0 : c.getName().compareTo(pc.getName());
                        if (dir == 0) {
                            pr = p.right;
                            if (pr != null && h >= pr.hash && (r = this.getTreeNode(h, k, pr)) != null) {
                                return r;
                            }
                            dir = -1;
                        } else {
                            pr = p.right;
                            if (pr != null && h >= pr.hash) {
                                s = pr;
                            }
                        }
                        if (s != null && (r = this.getTreeNode(h, k, s)) != null) {
                            return r;
                        }
                    }
                } else {
                    dir = h < ph ? -1 : 1;
                }
                pp = dir > 0 ? p.right : p.left;
            }
            TreeNode<V> f = this.first;
            this.first = new TreeNode<V>(h, k, v, f, p);
            TreeNode<V> x = this.first;
            if (p == null) {
                this.root = x;
            } else {
                TreeNode xpp;
                TreeNode xp;
                if (f != null) {
                    f.prev = x;
                }
                if (dir <= 0) {
                    p.left = x;
                } else {
                    p.right = x;
                }
                x.red = true;
                while (x != null && (xp = x.parent) != null && xp.red && (xpp = xp.parent) != null) {
                    TreeNode y;
                    TreeNode xppl = xpp.left;
                    if (xp == xppl) {
                        y = xpp.right;
                        if (y != null && y.red) {
                            y.red = false;
                            xp.red = false;
                            xpp.red = true;
                            x = xpp;
                            continue;
                        }
                        if (x == xp.right) {
                            x = xp;
                            this.rotateLeft(x);
                            xp = x.parent;
                            TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                        }
                        if (xp == null) continue;
                        xp.red = false;
                        if (xpp == null) continue;
                        xpp.red = true;
                        this.rotateRight(xpp);
                        continue;
                    }
                    y = xppl;
                    if (y != null && y.red) {
                        y.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x = xpp;
                        continue;
                    }
                    if (x == xp.left) {
                        x = xp;
                        this.rotateRight(x);
                        xp = x.parent;
                        TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    this.rotateLeft(xpp);
                }
                r = this.root;
                if (r != null && r.red) {
                    r.red = false;
                }
            }
            return null;
        }

        final void deleteTreeNode(TreeNode<V> p) {
            TreeNode replacement;
            TreeNode next = (TreeNode)p.next;
            TreeNode pred = p.prev;
            if (pred == null) {
                this.first = next;
            } else {
                pred.next = next;
            }
            if (next != null) {
                next.prev = pred;
            }
            TreeNode pl = p.left;
            TreeNode pr = p.right;
            if (pl != null && pr != null) {
                TreeNode sl;
                TreeNode s = pr;
                while ((sl = s.left) != null) {
                    s = sl;
                }
                boolean c = s.red;
                s.red = p.red;
                p.red = c;
                TreeNode sr = s.right;
                TreeNode pp = p.parent;
                if (s == pr) {
                    p.parent = s;
                    s.right = p;
                } else {
                    TreeNode sp = s.parent;
                    p.parent = sp;
                    if (p.parent != null) {
                        if (s == sp.left) {
                            sp.left = p;
                        } else {
                            sp.right = p;
                        }
                    }
                    if ((s.right = pr) != null) {
                        pr.parent = s;
                    }
                }
                p.left = null;
                p.right = sr;
                if (p.right != null) {
                    sr.parent = p;
                }
                if ((s.left = pl) != null) {
                    pl.parent = s;
                }
                if ((s.parent = pp) == null) {
                    this.root = s;
                } else if (p == pp.left) {
                    pp.left = s;
                } else {
                    pp.right = s;
                }
                replacement = sr;
            } else {
                replacement = pl != null ? pl : pr;
            }
            TreeNode pp = p.parent;
            if (replacement == null) {
                if (pp == null) {
                    this.root = null;
                    return;
                }
                replacement = p;
            } else {
                replacement.parent = pp;
                if (pp == null) {
                    this.root = replacement;
                } else if (p == pp.left) {
                    pp.left = replacement;
                } else {
                    pp.right = replacement;
                }
                p.parent = null;
                p.right = null;
                p.left = null;
            }
            if (!p.red) {
                TreeNode x = replacement;
                while (x != null) {
                    TreeNode sr;
                    TreeNode sl;
                    TreeNode sib;
                    TreeNode xp;
                    if (x.red || (xp = x.parent) == null) {
                        x.red = false;
                        break;
                    }
                    TreeNode xpl = xp.left;
                    if (x == xpl) {
                        sib = xp.right;
                        if (sib != null && sib.red) {
                            sib.red = false;
                            xp.red = true;
                            this.rotateLeft(xp);
                            xp = x.parent;
                            TreeNode treeNode = sib = xp == null ? null : xp.right;
                        }
                        if (sib == null) {
                            x = xp;
                            continue;
                        }
                        sl = sib.left;
                        sr = sib.right;
                        if (!(sr != null && sr.red || sl != null && sl.red)) {
                            sib.red = true;
                            x = xp;
                            continue;
                        }
                        if (sr == null || !sr.red) {
                            if (sl != null) {
                                sl.red = false;
                            }
                            sib.red = true;
                            this.rotateRight(sib);
                            xp = x.parent;
                            TreeNode treeNode = sib = xp == null ? null : xp.right;
                        }
                        if (sib != null) {
                            sib.red = xp == null ? false : xp.red;
                            sr = sib.right;
                            if (sr != null) {
                                sr.red = false;
                            }
                        }
                        if (xp != null) {
                            xp.red = false;
                            this.rotateLeft(xp);
                        }
                        x = this.root;
                        continue;
                    }
                    sib = xpl;
                    if (sib != null && sib.red) {
                        sib.red = false;
                        xp.red = true;
                        this.rotateRight(xp);
                        xp = x.parent;
                        TreeNode treeNode = sib = xp == null ? null : xp.left;
                    }
                    if (sib == null) {
                        x = xp;
                        continue;
                    }
                    sl = sib.left;
                    sr = sib.right;
                    if (!(sl != null && sl.red || sr != null && sr.red)) {
                        sib.red = true;
                        x = xp;
                        continue;
                    }
                    if (sl == null || !sl.red) {
                        if (sr != null) {
                            sr.red = false;
                        }
                        sib.red = true;
                        this.rotateLeft(sib);
                        xp = x.parent;
                        TreeNode treeNode = sib = xp == null ? null : xp.left;
                    }
                    if (sib != null) {
                        sib.red = xp == null ? false : xp.red;
                        sl = sib.left;
                        if (sl != null) {
                            sl.red = false;
                        }
                    }
                    if (xp != null) {
                        xp.red = false;
                        this.rotateRight(xp);
                    }
                    x = this.root;
                }
            }
            if (p == replacement && (pp = p.parent) != null) {
                if (p == pp.left) {
                    pp.left = null;
                } else if (p == pp.right) {
                    pp.right = null;
                }
                p.parent = null;
            }
        }
    }

    static final class TreeNode<V>
    extends Node<V> {
        TreeNode<V> parent;
        TreeNode<V> left;
        TreeNode<V> right;
        TreeNode<V> prev;
        boolean red;

        TreeNode(int hash, Object key, V val, Node<V> next, TreeNode<V> parent) {
            super(hash, key, val, next);
            this.parent = parent;
        }
    }

    static class Node<V> {
        final int hash;
        final Object key;
        volatile V val;
        volatile Node<V> next;

        Node(int hash, Object key, V val, Node<V> next) {
            this.hash = hash;
            this.key = key;
            this.val = val;
            this.next = next;
        }
    }

    static final class CounterHashCode {
        int code;

        CounterHashCode() {
        }
    }

    static final class CounterCell {
        volatile long p0;
        volatile long p1;
        volatile long p2;
        volatile long p3;
        volatile long p4;
        volatile long p5;
        volatile long p6;
        volatile long value;
        volatile long q0;
        volatile long q1;
        volatile long q2;
        volatile long q3;
        volatile long q4;
        volatile long q5;
        volatile long q6;

        CounterCell(long x) {
            this.value = x;
        }
    }

    public static interface Spliterator<T>
    extends Iterator<T> {
        public Spliterator<T> split();
    }
}

