/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.IInventory;
import net.minecraft.server.ItemArmor;
import net.minecraft.server.ItemStack;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;

public class PlayerInventory
implements IInventory {
    public ItemStack[] items = new ItemStack[36];
    public ItemStack[] armor = new ItemStack[4];
    public int itemInHandIndex = 0;
    public EntityHuman player;
    private ItemStack g;
    public boolean e = false;

    public PlayerInventory(EntityHuman entityHuman) {
        this.player = entityHuman;
    }

    public ItemStack getItemInHand() {
        if (this.itemInHandIndex < 9 && this.itemInHandIndex >= 0) {
            return this.items[this.itemInHandIndex];
        }
        return null;
    }

    public static int getHotbarSize() {
        return 9;
    }

    private int h(int n) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null || this.items[i].id != n) continue;
            return i;
        }
        return -1;
    }

    private int firstPartial(ItemStack itemStack) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null || this.items[i].id != itemStack.id || !this.items[i].isStackable() || this.items[i].count >= this.items[i].getMaxStackSize() || this.items[i].count >= this.getMaxStackSize() || this.items[i].usesData() && this.items[i].getData() != itemStack.getData() || !ItemStack.equals(this.items[i], itemStack)) continue;
            return i;
        }
        return -1;
    }

    public int i() {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != null) continue;
            return i;
        }
        return -1;
    }

    private int e(ItemStack itemStack) {
        int n;
        int n2 = itemStack.id;
        int n3 = itemStack.count;
        if (itemStack.getMaxStackSize() == 1) {
            int n4 = this.i();
            if (n4 < 0) {
                return n3;
            }
            if (this.items[n4] == null) {
                this.items[n4] = ItemStack.b(itemStack);
            }
            return 0;
        }
        int n5 = this.firstPartial(itemStack);
        if (n5 < 0) {
            n5 = this.i();
        }
        if (n5 < 0) {
            return n3;
        }
        if (this.items[n5] == null) {
            this.items[n5] = new ItemStack(n2, 0, itemStack.getData());
            if (itemStack.hasTag()) {
                this.items[n5].setTag((NBTTagCompound)itemStack.getTag().clone());
            }
        }
        if ((n = n3) > this.items[n5].getMaxStackSize() - this.items[n5].count) {
            n = this.items[n5].getMaxStackSize() - this.items[n5].count;
        }
        if (n > this.getMaxStackSize() - this.items[n5].count) {
            n = this.getMaxStackSize() - this.items[n5].count;
        }
        if (n == 0) {
            return n3;
        }
        this.items[n5].count += n;
        this.items[n5].b = 5;
        return n3 -= n;
    }

    public void k() {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            this.items[i].a(this.player.world, this.player, i, this.itemInHandIndex == i);
        }
    }

    public boolean d(int n) {
        int n2 = this.h(n);
        if (n2 < 0) {
            return false;
        }
        if (--this.items[n2].count <= 0) {
            this.items[n2] = null;
        }
        return true;
    }

    public boolean e(int n) {
        int n2 = this.h(n);
        return n2 >= 0;
    }

    public boolean pickup(ItemStack itemStack) {
        if (!itemStack.h()) {
            int n;
            do {
                n = itemStack.count;
                itemStack.count = this.e(itemStack);
            } while (itemStack.count > 0 && itemStack.count < n);
            if (itemStack.count == n && this.player.abilities.canInstantlyBuild) {
                itemStack.count = 0;
                return true;
            }
            return itemStack.count < n;
        }
        int n = this.i();
        if (n >= 0) {
            this.items[n] = ItemStack.b(itemStack);
            this.items[n].b = 5;
            itemStack.count = 0;
            return true;
        }
        if (this.player.abilities.canInstantlyBuild) {
            itemStack.count = 0;
            return true;
        }
        return false;
    }

    public ItemStack splitStack(int n, int n2) {
        ItemStack[] itemStackArray = this.items;
        if (n >= this.items.length) {
            itemStackArray = this.armor;
            n -= this.items.length;
        }
        if (itemStackArray[n] != null) {
            if (itemStackArray[n].count <= n2) {
                ItemStack itemStack = itemStackArray[n];
                itemStackArray[n] = null;
                return itemStack;
            }
            ItemStack itemStack = itemStackArray[n].a(n2);
            if (itemStackArray[n].count == 0) {
                itemStackArray[n] = null;
            }
            return itemStack;
        }
        return null;
    }

    public ItemStack splitWithoutUpdate(int n) {
        ItemStack[] itemStackArray = this.items;
        if (n >= this.items.length) {
            itemStackArray = this.armor;
            n -= this.items.length;
        }
        if (itemStackArray[n] != null) {
            ItemStack itemStack = itemStackArray[n];
            itemStackArray[n] = null;
            return itemStack;
        }
        return null;
    }

    public void setItem(int n, ItemStack itemStack) {
        ItemStack[] itemStackArray = this.items;
        if (n >= itemStackArray.length) {
            n -= itemStackArray.length;
            itemStackArray = this.armor;
        }
        itemStackArray[n] = itemStack;
    }

    public float a(Block block) {
        float f = 1.0f;
        if (this.items[this.itemInHandIndex] != null) {
            f *= this.items[this.itemInHandIndex].a(block);
        }
        return f;
    }

    public NBTTagList a(NBTTagList nBTTagList) {
        NBTTagCompound nBTTagCompound;
        int n;
        for (n = 0; n < this.items.length; ++n) {
            if (this.items[n] == null) continue;
            nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.setByte("Slot", (byte)n);
            this.items[n].save(nBTTagCompound);
            nBTTagList.add(nBTTagCompound);
        }
        for (n = 0; n < this.armor.length; ++n) {
            if (this.armor[n] == null) continue;
            nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.setByte("Slot", (byte)(n + 100));
            this.armor[n].save(nBTTagCompound);
            nBTTagList.add(nBTTagCompound);
        }
        return nBTTagList;
    }

    public void b(NBTTagList nBTTagList) {
        this.items = new ItemStack[36];
        this.armor = new ItemStack[4];
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound = (NBTTagCompound)nBTTagList.get(i);
            int n = nBTTagCompound.getByte("Slot") & 0xFF;
            ItemStack itemStack = ItemStack.a(nBTTagCompound);
            if (itemStack == null) continue;
            if (n >= 0 && n < this.items.length) {
                this.items[n] = itemStack;
            }
            if (n < 100 || n >= this.armor.length + 100) continue;
            this.armor[n - 100] = itemStack;
        }
    }

    public int getSize() {
        return this.items.length + 4;
    }

    public ItemStack getItem(int n) {
        ItemStack[] itemStackArray = this.items;
        if (n >= itemStackArray.length) {
            n -= itemStackArray.length;
            itemStackArray = this.armor;
        }
        return itemStackArray[n];
    }

    public String getName() {
        return "container.inventory";
    }

    public int getMaxStackSize() {
        return 64;
    }

    public int a(Entity entity) {
        ItemStack itemStack = this.getItem(this.itemInHandIndex);
        if (itemStack != null) {
            return itemStack.a(entity);
        }
        return 1;
    }

    public boolean b(Block block) {
        if (block.material.isAlwaysDestroyable()) {
            return true;
        }
        ItemStack itemStack = this.getItem(this.itemInHandIndex);
        if (itemStack != null) {
            return itemStack.b(block);
        }
        return false;
    }

    public int l() {
        int n = 0;
        for (ItemStack itemStack : this.armor) {
            if (itemStack == null || !(itemStack.getItem() instanceof ItemArmor)) continue;
            int n2 = ((ItemArmor)itemStack.getItem()).b;
            n += n2;
        }
        return n;
    }

    public void g(int n) {
        if ((n /= 4) < 1) {
            n = 1;
        }
        for (int i = 0; i < this.armor.length; ++i) {
            if (this.armor[i] == null || !(this.armor[i].getItem() instanceof ItemArmor)) continue;
            this.armor[i].damage(n, this.player);
            if (this.armor[i].count != 0) continue;
            this.armor[i] = null;
        }
    }

    public void m() {
        int n;
        for (n = 0; n < this.items.length; ++n) {
            if (this.items[n] == null) continue;
            this.player.a(this.items[n], true);
            this.items[n] = null;
        }
        for (n = 0; n < this.armor.length; ++n) {
            if (this.armor[n] == null) continue;
            this.player.a(this.armor[n], true);
            this.armor[n] = null;
        }
    }

    public void update() {
        this.e = true;
    }

    public void setCarried(ItemStack itemStack) {
        this.g = itemStack;
    }

    public ItemStack getCarried() {
        return this.g;
    }

    public boolean a(EntityHuman entityHuman) {
        if (this.player.dead) {
            return false;
        }
        return !(entityHuman.e(this.player) > 64.0);
    }

    public boolean c(ItemStack itemStack) {
        for (ItemStack itemStack2 : this.armor) {
            if (itemStack2 == null || !itemStack2.c(itemStack)) continue;
            return true;
        }
        for (ItemStack itemStack2 : this.items) {
            if (itemStack2 == null || !itemStack2.c(itemStack)) continue;
            return true;
        }
        return false;
    }

    public void startOpen() {
    }

    public void f() {
    }

    public void b(PlayerInventory playerInventory) {
        int n;
        for (n = 0; n < this.items.length; ++n) {
            this.items[n] = ItemStack.b(playerInventory.items[n]);
        }
        for (n = 0; n < this.armor.length; ++n) {
            this.armor[n] = ItemStack.b(playerInventory.armor[n]);
        }
    }
}

