/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.scheduler;

import com.google.common.base.Preconditions;
import gnu.trove.TCollections;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import net.md_5.bungee.api.scheduler.TaskScheduler;
import net.md_5.bungee.scheduler.BungeeTask;

public class BungeeScheduler
implements TaskScheduler {
    private final AtomicInteger taskCounter = new AtomicInteger();
    private final TIntObjectMap<BungeeTask> tasks = TCollections.synchronizedMap(new TIntObjectHashMap());

    @Override
    public void cancel(int id) {
        this.cancel(this.tasks.remove(id));
    }

    @Override
    public void cancel(ScheduledTask task) {
        Preconditions.checkArgument(task instanceof BungeeTask, "Don't know how to handle task %s", task);
        this.tasks.remove(task.getId()).getFuture().cancel(false);
    }

    @Override
    public int cancel(Plugin plugin) {
        int cancelled = 0;
        TIntObjectIterator<BungeeTask> iter = this.tasks.iterator();
        while (iter.hasNext()) {
            BungeeTask task = iter.value();
            if (task.getOwner() != plugin) continue;
            task.getFuture().cancel(false);
            iter.remove();
            ++cancelled;
        }
        return cancelled;
    }

    @Override
    public ScheduledTask runAsync(Plugin owner, Runnable task) {
        return this.schedule(owner, task, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledTask schedule(Plugin owner, Runnable task, long delay, TimeUnit unit) {
        return this.prepare(owner, task).setFuture(BungeeCord.getInstance().executors.schedule(task, delay, unit));
    }

    @Override
    public ScheduledTask schedule(Plugin owner, Runnable task, long delay, long period, TimeUnit unit) {
        return this.prepare(owner, task).setFuture(BungeeCord.getInstance().executors.scheduleWithFixedDelay(task, delay, period, unit));
    }

    private BungeeTask prepare(Plugin owner, Runnable task) {
        int id = this.taskCounter.getAndIncrement();
        return this.tasks.put(id, new BungeeTask(this.taskCounter.getAndIncrement(), owner, task));
    }
}

