/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.Signal;
import io.netty.util.concurrent.BlockingOperationException;
import io.netty.util.concurrent.DefaultPromiseListeners;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.TimeUnit;

public class DefaultPromise
implements Promise {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultPromise.class);
    private static final int MAX_LISTENER_STACK_DEPTH = 8;
    private static final ThreadLocal<Integer> LISTENER_STACK_DEPTH = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static final Signal SUCCESS = new Signal(DefaultPromise.class.getName() + ".SUCCESS");
    private final EventExecutor executor;
    private volatile Throwable cause;
    private Object listeners;
    protected long state;

    public DefaultPromise(EventExecutor executor) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        this.executor = executor;
    }

    protected DefaultPromise() {
        this.executor = null;
    }

    protected EventExecutor executor() {
        return this.executor;
    }

    @Override
    public boolean isDone() {
        return this.cause != null;
    }

    @Override
    public boolean isSuccess() {
        return this.cause == SUCCESS;
    }

    @Override
    public Throwable cause() {
        Throwable cause = this.cause;
        return cause == SUCCESS ? null : cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise addListener(GenericFutureListener<? extends Future> listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.isDone()) {
            DefaultPromise.notifyListener(this.executor(), this, listener);
            return this;
        }
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            if (!this.isDone()) {
                if (this.listeners == null) {
                    this.listeners = listener;
                } else if (this.listeners instanceof DefaultPromiseListeners) {
                    ((DefaultPromiseListeners)this.listeners).add(listener);
                } else {
                    this.listeners = new DefaultPromiseListeners((GenericFutureListener)this.listeners, listener);
                }
                return this;
            }
        }
        DefaultPromise.notifyListener(this.executor(), this, listener);
        return this;
    }

    @Override
    public Promise addListeners(GenericFutureListener<? extends Future> ... listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners");
        }
        for (GenericFutureListener<? extends Future> l : listeners) {
            if (l == null) break;
            this.addListener((GenericFutureListener)l);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise removeListener(GenericFutureListener<? extends Future> listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        if (this.isDone()) {
            return this;
        }
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            if (!this.isDone()) {
                if (this.listeners instanceof DefaultPromiseListeners) {
                    ((DefaultPromiseListeners)this.listeners).remove(listener);
                } else if (this.listeners == listener) {
                    this.listeners = null;
                }
            }
        }
        return this;
    }

    @Override
    public Promise removeListeners(GenericFutureListener<? extends Future> ... listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners");
        }
        for (GenericFutureListener<? extends Future> l : listeners) {
            if (l == null) break;
            this.removeListener((GenericFutureListener)l);
        }
        return this;
    }

    @Override
    public Promise sync() throws InterruptedException {
        this.await();
        this.rethrowIfFailed();
        return this;
    }

    @Override
    public Promise syncUninterruptibly() {
        this.awaitUninterruptibly();
        this.rethrowIfFailed();
        return this;
    }

    private void rethrowIfFailed() {
        Throwable cause = this.cause();
        if (cause == null) {
            return;
        }
        PlatformDependent.throwException(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise await() throws InterruptedException {
        if (this.isDone()) {
            return this;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            while (!this.isDone()) {
                this.checkDeadLock();
                this.incWaiters();
                try {
                    this.wait();
                }
                finally {
                    this.decWaiters();
                }
            }
        }
        return this;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await0(unit.toNanos(timeout), true);
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise awaitUninterruptibly() {
        if (this.isDone()) {
            return this;
        }
        boolean interrupted = false;
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            while (!this.isDone()) {
                this.checkDeadLock();
                this.incWaiters();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
                finally {
                    this.decWaiters();
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        try {
            return this.await0(unit.toNanos(timeout), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(TimeUnit.MILLISECONDS.toNanos(timeoutMillis), false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    /*
     * Exception decompiling
     */
    private boolean await0(long timeoutNanos, boolean interruptable) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void checkDeadLock() {
        EventExecutor e = this.executor();
        if (e != null && e.inEventLoop()) {
            throw new BlockingOperationException();
        }
    }

    @Override
    public Promise setSuccess() {
        if (this.set(SUCCESS)) {
            this.notifyListeners();
            return this;
        }
        throw new IllegalStateException("complete already");
    }

    @Override
    public boolean trySuccess() {
        if (this.set(SUCCESS)) {
            this.notifyListeners();
            return true;
        }
        return false;
    }

    @Override
    public Promise setFailure(Throwable cause) {
        if (this.set(cause)) {
            this.notifyListeners();
            return this;
        }
        throw new IllegalStateException("complete already", cause);
    }

    @Override
    public boolean tryFailure(Throwable cause) {
        if (this.set(cause)) {
            this.notifyListeners();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean set(Throwable cause) {
        if (this.isDone()) {
            return false;
        }
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            if (this.isDone()) {
                return false;
            }
            this.cause = cause;
            if (this.hasWaiters()) {
                this.notifyAll();
            }
        }
        return true;
    }

    private boolean hasWaiters() {
        return (this.state & 0xFFFFFF0000000000L) != 0L;
    }

    private void incWaiters() {
        long newState = this.state + 0x10000000000L;
        if ((newState & 0xFFFFFF0000000000L) == 0L) {
            throw new IllegalStateException("too many waiters");
        }
        this.state = newState;
    }

    private void decWaiters() {
        this.state -= 0x10000000000L;
    }

    private void notifyListeners() {
        if (this.listeners == null) {
            return;
        }
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            if (this.listeners instanceof DefaultPromiseListeners) {
                DefaultPromise.notifyListeners0(this, (DefaultPromiseListeners)this.listeners);
            } else {
                DefaultPromise.notifyListener0(this, (GenericFutureListener)this.listeners);
            }
            this.listeners = null;
        } else {
            final Object listeners = this.listeners;
            this.listeners = null;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (listeners instanceof DefaultPromiseListeners) {
                        DefaultPromise.notifyListeners0(DefaultPromise.this, (DefaultPromiseListeners)listeners);
                    } else {
                        DefaultPromise.notifyListener0(DefaultPromise.this, (GenericFutureListener)listeners);
                    }
                }
            });
        }
    }

    private static void notifyListeners0(Future future, DefaultPromiseListeners listeners) {
        GenericFutureListener<? extends Future>[] a = listeners.listeners();
        int size = listeners.size();
        for (int i = 0; i < size; ++i) {
            DefaultPromise.notifyListener0(future, a[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyListener(final EventExecutor eventExecutor, final Future future, final GenericFutureListener<? extends Future> l) {
        Integer stackDepth;
        if (eventExecutor.inEventLoop() && (stackDepth = LISTENER_STACK_DEPTH.get()) < 8) {
            LISTENER_STACK_DEPTH.set(stackDepth + 1);
            try {
                DefaultPromise.notifyListener0(future, l);
            }
            finally {
                LISTENER_STACK_DEPTH.set(stackDepth);
            }
            return;
        }
        eventExecutor.execute(new Runnable(){

            @Override
            public void run() {
                DefaultPromise.notifyListener(eventExecutor, future, l);
            }
        });
    }

    private static void notifyListener0(Future future, GenericFutureListener l) {
        block2: {
            try {
                l.operationComplete(future);
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("An exception was thrown by " + GenericFutureListener.class.getSimpleName() + '.', t);
            }
        }
    }
}

