/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import net.md_5.bungee.ChatColor;
import net.md_5.bungee.Configuration;
import net.md_5.bungee.ListenThread;
import net.md_5.bungee.Logger;
import net.md_5.bungee.Metrics;
import net.md_5.bungee.ReconnectSaveThread;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.command.Command;
import net.md_5.bungee.command.CommandAlert;
import net.md_5.bungee.command.CommandEnd;
import net.md_5.bungee.command.CommandIP;
import net.md_5.bungee.command.CommandList;
import net.md_5.bungee.command.CommandSender;
import net.md_5.bungee.command.CommandServer;
import net.md_5.bungee.command.ConsoleCommandSender;
import net.md_5.bungee.plugin.JavaPluginManager;

public class BungeeCord {
    public static BungeeCord instance;
    public volatile boolean isRunning;
    public final Configuration config = new Configuration();
    public final ExecutorService threadPool = Executors.newCachedThreadPool();
    private final ReconnectSaveThread saveThread = new ReconnectSaveThread();
    private ListenThread listener;
    public String version = this.getClass().getPackage().getImplementationVersion() == null ? "unknown" : this.getClass().getPackage().getImplementationVersion();
    public Map<String, UserConnection> connections = new ConcurrentHashMap<String, UserConnection>();
    public Map<String, Command> commandMap = new HashMap<String, Command>();
    public final JavaPluginManager pluginManager = new JavaPluginManager();

    public BungeeCord() {
        this.commandMap.put("end", new CommandEnd());
        this.commandMap.put("glist", new CommandList());
        this.commandMap.put("server", new CommandServer());
        this.commandMap.put("ip", new CommandIP());
        this.commandMap.put("alert", new CommandAlert());
    }

    public static void main(String[] args) throws IOException {
        instance = new BungeeCord();
        Logger.$().info("Enabled BungeeCord version " + BungeeCord.instance.version);
        instance.start();
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (BungeeCord.instance.isRunning) {
            boolean handled;
            String line = br.readLine();
            if (line == null || (handled = instance.dispatchCommand(line, ConsoleCommandSender.instance))) continue;
            System.err.println("Command not found");
        }
    }

    public boolean dispatchCommand(String commandLine, CommandSender sender) {
        String[] split = commandLine.trim().split(" ");
        String commandName = split[0].toLowerCase();
        Command command = this.commandMap.get(commandName);
        if (!(command == null || this.config.disabledCommands != null && this.config.disabledCommands.contains(commandName))) {
            String[] args = Arrays.copyOfRange(split, 1, split.length);
            try {
                command.execute(sender, args);
            }
            catch (Exception ex) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "An error occurred while executing this command!");
                Logger.$().severe("----------------------- [Start of command error] -----------------------");
                Logger.$().log(Level.SEVERE, "", ex);
                Logger.$().severe("----------------------- [End of command error] -----------------------");
            }
        }
        return command != null;
    }

    public void start() throws IOException {
        this.config.load();
        this.isRunning = true;
        this.pluginManager.loadPlugins();
        InetSocketAddress addr = Util.getAddr(this.config.bindHost);
        this.listener = new ListenThread(addr);
        this.listener.start();
        this.saveThread.start();
        Logger.$().info("Listening on " + addr);
        new Metrics().start();
    }

    public void stop() {
        this.isRunning = false;
        Logger.$().info("Disabling plugin");
        this.pluginManager.onDisable();
        Logger.$().info("Closing listen thread");
        try {
            this.listener.socket.close();
            this.listener.join();
        }
        catch (IOException | InterruptedException ex) {
            Logger.$().severe("Could not close listen thread");
        }
        Logger.$().info("Closing pending connections");
        this.threadPool.shutdown();
        Logger.$().info("Disconnecting " + this.connections.size() + " connections");
        for (UserConnection user : this.connections.values()) {
            user.disconnect("Proxy restarting, brb.");
        }
        Logger.$().info("Saving reconnect locations");
        this.saveThread.interrupt();
        try {
            this.saveThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Logger.$().info("Thank you and goodbye");
    }

    public void setSocketOptions(Socket socket) throws IOException {
        socket.setSoTimeout(this.config.timeout);
        socket.setTrafficClass(24);
        socket.setTcpNoDelay(true);
    }
}

