/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.netty.channel.Channel;
import java.beans.ConstructorProperties;
import net.md_5.bungee.EntityMap;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.scoreboard.Scoreboard;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.packet.Packet0KeepAlive;
import net.md_5.bungee.packet.Packet3Chat;
import net.md_5.bungee.packet.PacketC9PlayerListItem;
import net.md_5.bungee.packet.PacketCESetScoreboard;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.packet.PacketFFKick;
import net.md_5.bungee.packet.PacketHandler;

public class DownstreamBridge
extends PacketHandler {
    private final ProxyServer bungee;
    private final UserConnection con;
    private final ServerConnection server;

    @Override
    public void exception(Throwable t) throws Exception {
        this.con.disconnect(Util.exception(t));
    }

    @Override
    public void disconnected(Channel channel) throws Exception {
        this.server.getInfo().removePlayer(this.con);
        this.bungee.getReconnectHandler().setServer(this.con);
        if (!this.server.isObsolete()) {
            this.con.disconnect("[Proxy] Lost connection to server D:");
        }
    }

    @Override
    public void handle(byte[] buf) throws Exception {
        EntityMap.rewrite(buf, this.con.serverEntityId, this.con.clientEntityId);
        this.con.ch.write(buf);
    }

    @Override
    public void handle(Packet0KeepAlive alive) throws Exception {
        this.con.trackingPingId = alive.id;
    }

    @Override
    public void handle(Packet3Chat chat) throws Exception {
        ChatEvent chatEvent = new ChatEvent(this.con.getServer(), this.con, chat.message);
        this.bungee.getPluginManager().callEvent(chatEvent);
        if (chatEvent.isCancelled()) {
            throw new CancelSendSignal();
        }
    }

    @Override
    public void handle(PacketCESetScoreboard scoreboard) throws Exception {
        this.con.serverSentScoreboard = new Scoreboard(scoreboard.name, scoreboard.text);
    }

    @Override
    public void handle(PacketC9PlayerListItem playerList) throws Exception {
        if (!this.bungee.getTabListHandler().onListUpdate(this.con, playerList.username, playerList.online, playerList.ping)) {
            throw new CancelSendSignal();
        }
    }

    @Override
    public void handle(PacketFAPluginMessage pluginMessage) throws Exception {
        ByteArrayDataInput in = ByteStreams.newDataInput(pluginMessage.data);
        PluginMessageEvent event = new PluginMessageEvent(this.con.getServer(), this.con, pluginMessage.tag, (byte[])pluginMessage.data.clone());
        if (this.bungee.getPluginManager().callEvent(event).isCancelled()) {
            throw new CancelSendSignal();
        }
        if (pluginMessage.tag.equals("BungeeCord")) {
            byte[] b;
            ServerInfo server;
            Object target;
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            String subChannel = in.readUTF();
            if (subChannel.equals("Forward")) {
                target = in.readUTF();
                String channel = in.readUTF();
                short len = in.readShort();
                byte[] data = new byte[len];
                in.readFully(data);
                out.writeUTF(channel);
                out.writeShort(data.length);
                out.write(data);
                byte[] payload = out.toByteArray();
                out = null;
                if (((String)target).equals("ALL")) {
                    for (ServerInfo server2 : this.bungee.getServers().values()) {
                        if (server2 == this.con.getServer().getInfo()) continue;
                        server2.sendData("BungeeCord", payload);
                    }
                } else {
                    ServerInfo server3 = this.bungee.getServerInfo((String)target);
                    if (server3 != null) {
                        server3.sendData("BungeeCord", payload);
                    }
                }
            }
            if (subChannel.equals("Connect") && (server = this.bungee.getServerInfo(in.readUTF())) != null) {
                this.con.connect(server);
            }
            if (subChannel.equals("IP")) {
                out.writeUTF("IP");
                out.writeUTF(this.con.getAddress().getHostString());
                out.writeInt(this.con.getAddress().getPort());
            }
            if (subChannel.equals("PlayerCount") && (server = this.bungee.getServerInfo(in.readUTF())) != null) {
                out.writeUTF("PlayerCount");
                out.writeUTF(server.getName());
                out.writeInt(server.getPlayers().size());
            }
            if (subChannel.equals("PlayerList") && (server = this.bungee.getServerInfo(in.readUTF())) != null) {
                out.writeUTF("PlayerList");
                out.writeUTF(server.getName());
                StringBuilder sb = new StringBuilder();
                for (ProxiedPlayer p : server.getPlayers()) {
                    sb.append(p.getName());
                    sb.append(",");
                }
                out.writeUTF(sb.substring(0, sb.length() - 1));
            }
            if (subChannel.equals("GetServers")) {
                out.writeUTF("GetServers");
                StringBuilder sb = new StringBuilder();
                for (String server4 : this.bungee.getServers().keySet()) {
                    sb.append(server4);
                    sb.append(",");
                }
                out.writeUTF(sb.substring(0, sb.length() - 1));
            }
            if (subChannel.equals("Message") && (target = this.bungee.getPlayer(in.readUTF())) != null) {
                target.sendMessage(in.readUTF());
            }
            if (subChannel.equals("GetServer")) {
                out.writeUTF("GetServer");
                out.writeUTF(this.server.getInfo().getName());
            }
            if (out != null && (b = out.toByteArray()).length != 0) {
                this.con.getServer().sendData("BungeeCord", b);
            }
        }
    }

    @Override
    public void handle(PacketFFKick kick) throws Exception {
        this.con.disconnect("[Kicked] " + kick.message);
        throw new CancelSendSignal();
    }

    @Override
    public String toString() {
        return "[" + this.con.getName() + "] <-> DownstreamBridge <-> [" + this.server.getInfo().getName() + "]";
    }

    @ConstructorProperties(value={"bungee", "con", "server"})
    public DownstreamBridge(ProxyServer bungee, UserConnection con, ServerConnection server) {
        this.bungee = bungee;
        this.con = con;
        this.server = server;
    }
}

