/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractMessageBuf;
import java.lang.reflect.Array;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class DefaultMessageBuf<T>
extends AbstractMessageBuf<T> {
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final Object[] PLACEHOLDER = new Object[2];
    private T[] elements;
    private int head;
    private int tail;

    DefaultMessageBuf() {
        this(16);
    }

    DefaultMessageBuf(int initialCapacity) {
        this(initialCapacity, Integer.MAX_VALUE);
    }

    DefaultMessageBuf(int initialCapacity, int maxCapacity) {
        super(maxCapacity);
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity: " + initialCapacity + " (expected: >= 0)");
        }
        if (maxCapacity < initialCapacity) {
            throw new IllegalArgumentException("maxCapacity: " + maxCapacity + " (expected: >= initialCapacity(" + initialCapacity + ')');
        }
        if (initialCapacity >= 8) {
            initialCapacity |= initialCapacity >>> 1;
            initialCapacity |= initialCapacity >>> 2;
            initialCapacity |= initialCapacity >>> 4;
            initialCapacity |= initialCapacity >>> 8;
            initialCapacity |= initialCapacity >>> 16;
            if (++initialCapacity < 0) {
                initialCapacity >>>= 1;
            }
        } else {
            initialCapacity = 8;
        }
        this.elements = DefaultMessageBuf.cast(new Object[initialCapacity]);
    }

    @Override
    protected void deallocate() {
        this.head = 0;
        this.tail = 0;
        this.elements = DefaultMessageBuf.cast(PLACEHOLDER);
    }

    @Override
    public boolean offer(T e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.ensureAccessible();
        if (!this.isWritable()) {
            return false;
        }
        this.elements[this.tail] = e;
        this.tail = this.tail + 1 & this.elements.length - 1;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
        return true;
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int p = this.head;
        int n = this.elements.length;
        int r = n - p;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Sorry, deque too big");
        }
        Object[] a = new Object[newCapacity];
        System.arraycopy(this.elements, p, a, 0, r);
        System.arraycopy(this.elements, 0, a, r, p);
        this.elements = DefaultMessageBuf.cast(a);
        this.head = 0;
        this.tail = n;
    }

    @Override
    public T poll() {
        this.ensureAccessible();
        int h = this.head;
        T result = this.elements[h];
        if (result == null) {
            return null;
        }
        this.elements[h] = null;
        this.head = h + 1 & this.elements.length - 1;
        return result;
    }

    @Override
    public T peek() {
        this.ensureAccessible();
        return this.elements[this.head];
    }

    @Override
    public boolean remove(Object o) {
        T x;
        if (o == null) {
            return false;
        }
        this.ensureAccessible();
        int mask = this.elements.length - 1;
        int i = this.head;
        while ((x = this.elements[i]) != null) {
            if (o.equals(x)) {
                this.delete(i);
                return true;
            }
            i = i + 1 & mask;
        }
        return false;
    }

    private boolean delete(int i) {
        assert (this.elements[this.tail] == null);
        assert (this.head != this.tail ? this.elements[this.head] != null && this.elements[this.tail - 1 & this.elements.length - 1] != null : this.elements[this.head] == null);
        assert (this.elements[this.head - 1 & this.elements.length - 1] == null);
        T[] elements = this.elements;
        int mask = elements.length - 1;
        int h = this.head;
        int t = this.tail;
        int front = i - h & mask;
        int back = t - i & mask;
        if (front >= (t - h & mask)) {
            throw new ConcurrentModificationException();
        }
        if (front < back) {
            if (h <= i) {
                System.arraycopy(elements, h, elements, h + 1, front);
            } else {
                System.arraycopy(elements, 0, elements, 1, i);
                elements[0] = elements[mask];
                System.arraycopy(elements, h, elements, h + 1, mask - h);
            }
            elements[h] = null;
            this.head = h + 1 & mask;
            return false;
        }
        if (i < t) {
            System.arraycopy(elements, i + 1, elements, i, back);
            this.tail = t - 1;
        } else {
            System.arraycopy(elements, i + 1, elements, i, mask - i);
            elements[mask] = elements[0];
            System.arraycopy(elements, 1, elements, 0, t);
            this.tail = t - 1 & mask;
        }
        return true;
    }

    @Override
    public int size() {
        return this.tail - this.head & this.elements.length - 1;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.tail;
    }

    @Override
    public Iterator<T> iterator() {
        this.ensureAccessible();
        return new Itr();
    }

    @Override
    public boolean contains(Object o) {
        T e;
        if (o == null) {
            return false;
        }
        this.ensureAccessible();
        int mask = this.elements.length - 1;
        int i = this.head;
        while ((e = this.elements[i]) != null) {
            if (o.equals(e)) {
                return true;
            }
            i = i + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.ensureAccessible();
        int head = this.head;
        int tail = this.tail;
        if (head != tail) {
            this.tail = 0;
            this.head = 0;
            int mask = this.elements.length - 1;
            int i = head;
            do {
                this.elements[i] = null;
            } while ((i = i + 1 & mask) != tail);
        }
    }

    @Override
    public Object[] toArray() {
        this.ensureAccessible();
        return this.copyElements(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.ensureAccessible();
        int size = this.size();
        if (a.length < size) {
            a = DefaultMessageBuf.cast(Array.newInstance(a.getClass().getComponentType(), size));
        }
        this.copyElements(a);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    private <U> U[] copyElements(U[] a) {
        if (this.head < this.tail) {
            System.arraycopy(this.elements, this.head, DefaultMessageBuf.cast(a), 0, this.size());
        } else if (this.head > this.tail) {
            int headPortionLen = this.elements.length - this.head;
            System.arraycopy(this.elements, this.head, DefaultMessageBuf.cast(a), 0, headPortionLen);
            System.arraycopy(this.elements, 0, DefaultMessageBuf.cast(a), headPortionLen, this.tail);
        }
        return a;
    }

    private static <T> T[] cast(Object a) {
        return (Object[])a;
    }

    private class Itr
    implements Iterator<T> {
        private int cursor;
        private int fence;
        private int lastRet;

        private Itr() {
            this.cursor = DefaultMessageBuf.this.head;
            this.fence = DefaultMessageBuf.this.tail;
            this.lastRet = -1;
        }

        @Override
        public boolean hasNext() {
            DefaultMessageBuf.this.ensureAccessible();
            return this.cursor != this.fence;
        }

        @Override
        public T next() {
            DefaultMessageBuf.this.ensureAccessible();
            if (this.cursor == this.fence) {
                throw new NoSuchElementException();
            }
            Object result = DefaultMessageBuf.this.elements[this.cursor];
            if (DefaultMessageBuf.this.tail != this.fence || result == null) {
                throw new ConcurrentModificationException();
            }
            this.lastRet = this.cursor;
            this.cursor = this.cursor + 1 & DefaultMessageBuf.this.elements.length - 1;
            return result;
        }

        @Override
        public void remove() {
            DefaultMessageBuf.this.ensureAccessible();
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            if (DefaultMessageBuf.this.delete(this.lastRet)) {
                this.cursor = this.cursor - 1 & DefaultMessageBuf.this.elements.length - 1;
                this.fence = DefaultMessageBuf.this.tail;
            }
            this.lastRet = -1;
        }
    }
}

