/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToByteCodec;
import javax.crypto.Cipher;

public class CipherCodec
extends ByteToByteCodec {
    private Cipher encrypt;
    private Cipher decrypt;
    private ByteBuf heapOut;

    public CipherCodec(Cipher encrypt, Cipher decrypt) {
        this.encrypt = encrypt;
        this.decrypt = decrypt;
    }

    @Override
    public void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        this.cipher(ctx, in, out, this.encrypt);
    }

    @Override
    public void decode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        this.cipher(ctx, in, out, this.decrypt);
    }

    @Override
    public void freeInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        super.freeInboundBuffer(ctx);
        if (this.heapOut != null) {
            this.heapOut.release();
            this.heapOut = null;
        }
    }

    @Override
    public void freeOutboundBuffer(ChannelHandlerContext ctx) throws Exception {
        super.freeOutboundBuffer(ctx);
        if (this.heapOut != null) {
            this.heapOut.release();
            this.heapOut = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cipher(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out, Cipher cipher) throws Exception {
        CipherCodec cipherCodec = this;
        synchronized (cipherCodec) {
            if (this.heapOut == null) {
                this.heapOut = ctx.alloc().heapBuffer();
            }
            int available = in.readableBytes();
            int outputSize = cipher.getOutputSize(available);
            if (this.heapOut.capacity() < outputSize) {
                this.heapOut.capacity(outputSize);
            }
            int processed = cipher.update(in.array(), in.arrayOffset() + in.readerIndex(), available, this.heapOut.array(), this.heapOut.arrayOffset() + this.heapOut.writerIndex());
            in.readerIndex(in.readerIndex() + processed);
            this.heapOut.writerIndex(this.heapOut.writerIndex() + processed);
            out.writeBytes(this.heapOut);
            this.heapOut.discardSomeReadBytes();
        }
    }
}

