/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.spdy.SpdyHeaderBlock;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SpdyHeaders
implements Iterable<Map.Entry<String, String>> {
    public static final SpdyHeaders EMPTY_HEADERS = new SpdyHeaders(){

        @Override
        public List<String> getAll(String name) {
            return Collections.emptyList();
        }

        @Override
        public List<Map.Entry<String, String>> entries() {
            return Collections.emptyList();
        }

        @Override
        public boolean contains(String name) {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Set<String> names() {
            return Collections.emptySet();
        }

        @Override
        public SpdyHeaders add(String name, Object value) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public SpdyHeaders add(String name, Iterable<?> values) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public SpdyHeaders set(String name, Object value) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public SpdyHeaders set(String name, Iterable<?> values) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public SpdyHeaders remove(String name) {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public SpdyHeaders clear() {
            throw new UnsupportedOperationException("read only");
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return this.entries().iterator();
        }

        @Override
        public String get(String name) {
            return null;
        }
    };

    public static String getHeader(SpdyHeaderBlock block, String name) {
        return block.headers().get(name);
    }

    public static String getHeader(SpdyHeaderBlock block, String name, String defaultValue) {
        String value = block.headers().get(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void setHeader(SpdyHeaderBlock block, String name, Object value) {
        block.headers().set(name, value);
    }

    public static void setHeader(SpdyHeaderBlock block, String name, Iterable<?> values) {
        block.headers().set(name, values);
    }

    public static void addHeader(SpdyHeaderBlock block, String name, Object value) {
        block.headers().add(name, value);
    }

    public static void removeHost(SpdyHeaderBlock block) {
        block.headers().remove(":host");
    }

    public static String getHost(SpdyHeaderBlock block) {
        return block.headers().get(":host");
    }

    public static void setHost(SpdyHeaderBlock block, String host) {
        block.headers().set(":host", host);
    }

    public static void removeMethod(int spdyVersion, SpdyHeaderBlock block) {
        if (spdyVersion < 3) {
            block.headers().remove("method");
        } else {
            block.headers().remove(":method");
        }
    }

    public static HttpMethod getMethod(int spdyVersion, SpdyHeaderBlock block) {
        try {
            if (spdyVersion < 3) {
                return HttpMethod.valueOf(block.headers().get("method"));
            }
            return HttpMethod.valueOf(block.headers().get(":method"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setMethod(int spdyVersion, SpdyHeaderBlock block, HttpMethod method) {
        if (spdyVersion < 3) {
            block.headers().set("method", method.name());
        } else {
            block.headers().set(":method", method.name());
        }
    }

    public static void removeScheme(int spdyVersion, SpdyHeaderBlock block) {
        if (spdyVersion < 2) {
            block.headers().remove("scheme");
        } else {
            block.headers().remove(":scheme");
        }
    }

    public static String getScheme(int spdyVersion, SpdyHeaderBlock block) {
        if (spdyVersion < 3) {
            return block.headers().get("scheme");
        }
        return block.headers().get(":scheme");
    }

    public static void setScheme(int spdyVersion, SpdyHeaderBlock block, String scheme) {
        if (spdyVersion < 3) {
            block.headers().set("scheme", scheme);
        } else {
            block.headers().set(":scheme", scheme);
        }
    }

    public static void removeStatus(int spdyVersion, SpdyHeaderBlock block) {
        if (spdyVersion < 3) {
            block.headers().remove("status");
        } else {
            block.headers().remove(":status");
        }
    }

    public static HttpResponseStatus getStatus(int spdyVersion, SpdyHeaderBlock block) {
        try {
            String status = spdyVersion < 3 ? block.headers().get("status") : block.headers().get(":status");
            int space = status.indexOf(32);
            if (space == -1) {
                return HttpResponseStatus.valueOf(Integer.parseInt(status));
            }
            int code = Integer.parseInt(status.substring(0, space));
            String reasonPhrase = status.substring(space + 1);
            HttpResponseStatus responseStatus = HttpResponseStatus.valueOf(code);
            if (responseStatus.reasonPhrase().equals(reasonPhrase)) {
                return responseStatus;
            }
            return new HttpResponseStatus(code, reasonPhrase);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setStatus(int spdyVersion, SpdyHeaderBlock block, HttpResponseStatus status) {
        if (spdyVersion < 3) {
            block.headers().set("status", status.toString());
        } else {
            block.headers().set(":status", status.toString());
        }
    }

    public static void removeUrl(int spdyVersion, SpdyHeaderBlock block) {
        if (spdyVersion < 3) {
            block.headers().remove("url");
        } else {
            block.headers().remove(":path");
        }
    }

    public static String getUrl(int spdyVersion, SpdyHeaderBlock block) {
        if (spdyVersion < 3) {
            return block.headers().get("url");
        }
        return block.headers().get(":path");
    }

    public static void setUrl(int spdyVersion, SpdyHeaderBlock block, String path) {
        if (spdyVersion < 3) {
            block.headers().set("url", path);
        } else {
            block.headers().set(":path", path);
        }
    }

    public static void removeVersion(int spdyVersion, SpdyHeaderBlock block) {
        if (spdyVersion < 3) {
            block.headers().remove("version");
        } else {
            block.headers().remove(":version");
        }
    }

    public static HttpVersion getVersion(int spdyVersion, SpdyHeaderBlock block) {
        try {
            if (spdyVersion < 3) {
                return HttpVersion.valueOf(block.headers().get("version"));
            }
            return HttpVersion.valueOf(block.headers().get(":version"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setVersion(int spdyVersion, SpdyHeaderBlock block, HttpVersion httpVersion) {
        if (spdyVersion < 3) {
            block.headers().set("version", httpVersion.text());
        } else {
            block.headers().set(":version", httpVersion.text());
        }
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.entries().iterator();
    }

    public abstract String get(String var1);

    public abstract List<String> getAll(String var1);

    public abstract List<Map.Entry<String, String>> entries();

    public abstract boolean contains(String var1);

    public abstract Set<String> names();

    public abstract SpdyHeaders add(String var1, Object var2);

    public abstract SpdyHeaders add(String var1, Iterable<?> var2);

    public abstract SpdyHeaders set(String var1, Object var2);

    public abstract SpdyHeaders set(String var1, Iterable<?> var2);

    public abstract SpdyHeaders remove(String var1);

    public abstract SpdyHeaders clear();

    public abstract boolean isEmpty();

    public static final class Spdy2HttpNames {
        public static final String METHOD = "method";
        public static final String SCHEME = "scheme";
        public static final String STATUS = "status";
        public static final String URL = "url";
        public static final String VERSION = "version";

        private Spdy2HttpNames() {
        }
    }

    public static final class HttpNames {
        public static final String HOST = ":host";
        public static final String METHOD = ":method";
        public static final String PATH = ":path";
        public static final String SCHEME = ":scheme";
        public static final String STATUS = ":status";
        public static final String VERSION = ":version";

        private HttpNames() {
        }
    }
}

