/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.nbt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.function.Supplier;
import net.md_5.bungee.nbt.NamedTag;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.nbt.exception.NBTFormatException;
import net.md_5.bungee.nbt.limit.NBTLimiter;
import net.md_5.bungee.nbt.type.ByteArrayTag;
import net.md_5.bungee.nbt.type.ByteTag;
import net.md_5.bungee.nbt.type.CompoundTag;
import net.md_5.bungee.nbt.type.DoubleTag;
import net.md_5.bungee.nbt.type.EndTag;
import net.md_5.bungee.nbt.type.FloatTag;
import net.md_5.bungee.nbt.type.IntArrayTag;
import net.md_5.bungee.nbt.type.IntTag;
import net.md_5.bungee.nbt.type.ListTag;
import net.md_5.bungee.nbt.type.LongArrayTag;
import net.md_5.bungee.nbt.type.LongTag;
import net.md_5.bungee.nbt.type.ShortTag;
import net.md_5.bungee.nbt.type.StringTag;

public interface Tag {
    public static final int OBJECT_HEADER = 8;
    public static final int ARRAY_HEADER = 12;
    public static final int STRING_SIZE = 28;
    public static final int OBJECT_REFERENCE = 4;
    public static final Supplier<? extends TypedTag>[] CONSTRUCTORS = new Supplier[]{EndTag::new, ByteTag::new, ShortTag::new, IntTag::new, LongTag::new, FloatTag::new, DoubleTag::new, ByteArrayTag::new, StringTag::new, ListTag::new, CompoundTag::new, IntArrayTag::new, LongArrayTag::new};
    public static final byte END = 0;
    public static final byte BYTE = 1;
    public static final byte SHORT = 2;
    public static final byte INT = 3;
    public static final byte LONG = 4;
    public static final byte FLOAT = 5;
    public static final byte DOUBLE = 6;
    public static final byte BYTE_ARRAY = 7;
    public static final byte STRING = 8;
    public static final byte LIST = 9;
    public static final byte COMPOUND = 10;
    public static final byte INT_ARRAY = 11;
    public static final byte LONG_ARRAY = 12;

    public void read(DataInput var1, NBTLimiter var2) throws IOException;

    public void write(DataOutput var1) throws IOException;

    public static TypedTag readById(byte id, DataInput input, NBTLimiter limiter) throws IOException {
        if (id < 0 || id > 12) {
            throw new NBTFormatException("Invalid tag id: " + id);
        }
        TypedTag tag = CONSTRUCTORS[id].get();
        tag.read(input, limiter);
        return tag;
    }

    public static NamedTag readNamedTag(DataInput input, NBTLimiter limiter) throws IOException {
        NamedTag namedTag = new NamedTag();
        namedTag.read(input, limiter);
        return namedTag;
    }

    public static byte[] toByteArray(TypedTag tag) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeByte(tag.getId());
        tag.write(dataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static TypedTag fromByteArray(byte[] data) throws IOException {
        return Tag.fromByteArray(data, NBTLimiter.unlimitedSize());
    }

    public static TypedTag fromByteArray(byte[] data, NBTLimiter limiter) throws IOException {
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(data));
        byte type = stream.readByte();
        return Tag.readById(type, stream, limiter);
    }
}

