/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.BungeeTitle;
import net.md_5.bungee.ConnectionThrottle;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.Metrics;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ReconnectHandler;
import net.md_5.bungee.api.Title;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;
import net.md_5.bungee.command.CommandBungee;
import net.md_5.bungee.command.CommandEnd;
import net.md_5.bungee.command.CommandIP;
import net.md_5.bungee.command.CommandPerms;
import net.md_5.bungee.command.CommandReload;
import net.md_5.bungee.command.ConsoleCommandCompleter;
import net.md_5.bungee.command.ConsoleCommandSender;
import net.md_5.bungee.compress.CompressFactory;
import net.md_5.bungee.conf.Configuration;
import net.md_5.bungee.conf.YamlConfig;
import net.md_5.bungee.jni.NativeCode;
import net.md_5.bungee.log.BungeeLogger;
import net.md_5.bungee.log.LoggingForwardHandler;
import net.md_5.bungee.log.LoggingOutputStream;
import net.md_5.bungee.module.ModuleManager;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.channel.BungeeChannelInitializer;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.query.RemoteQuery;
import net.md_5.bungee.scheduler.BungeeScheduler;
import net.md_5.bungee.util.CaseInsensitiveMap;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.slf4j.jul.JDK14LoggerFactory;

public class BungeeCord
extends ProxyServer {
    public volatile boolean isRunning;
    public final Configuration config = new Configuration();
    private Map<String, Format> messageFormats;
    public EventLoopGroup eventLoops;
    private final Timer saveThread = new Timer("Reconnect Saver");
    private final Timer metricsThread = new Timer("Metrics Thread");
    private final Collection<Channel> listeners = new HashSet<Channel>();
    private final Map<String, UserConnection> connections = new CaseInsensitiveMap<UserConnection>();
    private final Map<UUID, UserConnection> connectionsByOfflineUUID = new HashMap<UUID, UserConnection>();
    private final Map<UUID, UserConnection> connectionsByUUID = new HashMap<UUID, UserConnection>();
    private final ReadWriteLock connectionLock = new ReentrantReadWriteLock();
    private final ReentrantLock shutdownLock = new ReentrantLock();
    public final PluginManager pluginManager;
    private ReconnectHandler reconnectHandler;
    private ConfigurationAdapter configurationAdapter = new YamlConfig();
    private final Collection<String> pluginChannels = new HashSet<String>();
    private final File pluginsFolder = new File("plugins");
    private final BungeeScheduler scheduler = new BungeeScheduler();
    private final LineReader consoleReader;
    private final Logger logger;
    private ConnectionThrottle connectionThrottle;
    private final ModuleManager moduleManager = new ModuleManager();
    private final ProxyServer.Unsafe unsafe;

    public static BungeeCord getInstance() {
        return (BungeeCord)ProxyServer.getInstance();
    }

    public BungeeCord() throws IOException {
        this.registerChannel("BungeeCord");
        this.unsafe = new ProxyServer.Unsafe(){
            private BungeeChannelInitializer frontendChannelInitializer;
            private BungeeChannelInitializer backendChannelInitializer;
            private BungeeChannelInitializer serverInfoChannelInitializer;

            @Override
            @Generated
            public BungeeChannelInitializer getFrontendChannelInitializer() {
                return this.frontendChannelInitializer;
            }

            @Override
            @Generated
            public void setFrontendChannelInitializer(BungeeChannelInitializer frontendChannelInitializer) {
                this.frontendChannelInitializer = frontendChannelInitializer;
            }

            @Override
            @Generated
            public BungeeChannelInitializer getBackendChannelInitializer() {
                return this.backendChannelInitializer;
            }

            @Override
            @Generated
            public void setBackendChannelInitializer(BungeeChannelInitializer backendChannelInitializer) {
                this.backendChannelInitializer = backendChannelInitializer;
            }

            @Override
            @Generated
            public BungeeChannelInitializer getServerInfoChannelInitializer() {
                return this.serverInfoChannelInitializer;
            }

            @Override
            @Generated
            public void setServerInfoChannelInitializer(BungeeChannelInitializer serverInfoChannelInitializer) {
                this.serverInfoChannelInitializer = serverInfoChannelInitializer;
            }
        };
        Preconditions.checkState(new File(".").getAbsolutePath().indexOf(33) == -1, "Cannot use BungeeCord in directory with ! in path.");
        this.reloadMessages();
        System.setProperty("library.jansi.version", "BungeeCord");
        Terminal terminal = TerminalBuilder.builder().build();
        this.consoleReader = LineReaderBuilder.builder().terminal(terminal).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).completer(new ConsoleCommandCompleter(this)).build();
        JDK14LoggerFactory.LOGGER = this.logger = new BungeeLogger("BungeeCord", "proxy.log", this.consoleReader);
        Logger rootLogger = Logger.getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        rootLogger.addHandler(new LoggingForwardHandler(this.logger));
        System.setErr(new PrintStream(new LoggingOutputStream(this.logger, Level.SEVERE), true));
        System.setOut(new PrintStream(new LoggingOutputStream(this.logger, Level.INFO), true));
        this.pluginManager = new PluginManager(this);
        this.getPluginManager().registerCommand(null, new CommandReload());
        this.getPluginManager().registerCommand(null, new CommandEnd());
        this.getPluginManager().registerCommand(null, new CommandIP());
        this.getPluginManager().registerCommand(null, new CommandBungee());
        this.getPluginManager().registerCommand(null, new CommandPerms());
        if (!Boolean.getBoolean("net.md_5.bungee.native.disable")) {
            if (!NativeCode.hasDirectBuffers()) {
                this.logger.warning("Memory addresses are not available in direct buffers");
            }
            if (EncryptionUtil.nativeFactory.load()) {
                this.logger.info("Using mbed TLS based native cipher.");
            } else {
                this.logger.info("Using standard Java JCE cipher.");
            }
            if (CompressFactory.zlib.load()) {
                this.logger.info("Using zlib based native compressor.");
            } else {
                this.logger.info("Using standard Java compressor.");
            }
        }
    }

    public void start() throws Exception {
        System.setProperty("io.netty.selectorAutoRebuildThreshold", "0");
        if (System.getProperty("io.netty.leakDetectionLevel") == null && System.getProperty("io.netty.leakDetection.level") == null) {
            ResourceLeakDetector.setLevel(ResourceLeakDetector.Level.DISABLED);
        }
        if (System.getProperty("io.netty.allocator.type") == null) {
            System.setProperty("io.netty.allocator.type", "pooled");
        }
        this.eventLoops = PipelineUtils.newEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty IO Thread #%1$d").build());
        File moduleDirectory = new File("modules");
        this.moduleManager.load(this, moduleDirectory);
        this.pluginManager.detectPlugins(moduleDirectory);
        this.pluginsFolder.mkdir();
        this.pluginManager.detectPlugins(this.pluginsFolder);
        this.pluginManager.loadPlugins();
        this.config.load();
        if (this.config.isForgeSupport()) {
            this.registerChannel("FML");
            this.registerChannel("FML|HS");
            this.registerChannel("FORGE");
            this.getLogger().warning("MinecraftForge support is currently unmaintained and may have unresolved issues. Please use at your own risk.");
        }
        this.isRunning = true;
        this.pluginManager.enablePlugins();
        if (this.config.getThrottle() > 0) {
            this.connectionThrottle = new ConnectionThrottle(this.config.getThrottle(), this.config.getThrottleLimit());
        }
        this.startListeners();
        this.saveThread.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (BungeeCord.this.getReconnectHandler() != null) {
                    BungeeCord.this.getReconnectHandler().save();
                }
            }
        }, 0L, TimeUnit.MINUTES.toMillis(5L));
        this.metricsThread.scheduleAtFixedRate((TimerTask)new Metrics(), 0L, TimeUnit.MINUTES.toMillis(10L));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                BungeeCord.this.independentThreadStop(BungeeCord.this.getTranslation("restart", new Object[0]), false);
            }
        });
    }

    public void startListeners() {
        for (final ListenerInfo info : this.config.getListeners()) {
            if (info.isProxyProtocol()) {
                this.getLogger().log(Level.WARNING, "Using PROXY protocol for listener {0}, please ensure this listener is adequately firewalled.", info.getSocketAddress());
                if (this.connectionThrottle != null) {
                    this.connectionThrottle = null;
                    this.getLogger().log(Level.WARNING, "Since PROXY protocol is in use, internal connection throttle has been disabled.");
                }
            }
            ChannelFutureListener listener = new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        BungeeCord.this.listeners.add(future.channel());
                        BungeeCord.this.getLogger().log(Level.INFO, "Listening on {0}", info.getSocketAddress());
                    } else {
                        BungeeCord.this.getLogger().log(Level.WARNING, "Could not bind to host " + info.getSocketAddress(), future.cause());
                    }
                }
            };
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(PipelineUtils.getServerChannel(info.getSocketAddress()))).option(ChannelOption.SO_REUSEADDR, true)).childAttr(PipelineUtils.LISTENER, info).childHandler(this.unsafe().getFrontendChannelInitializer().getChannelInitializer()).group(this.eventLoops).localAddress(info.getSocketAddress())).bind().addListener((GenericFutureListener)listener);
            if (!info.isQueryEnabled()) continue;
            Preconditions.checkArgument(info.getSocketAddress() instanceof InetSocketAddress, "Can only create query listener on UDP address");
            ChannelFutureListener bindListener = new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        BungeeCord.this.listeners.add(future.channel());
                        BungeeCord.this.getLogger().log(Level.INFO, "Started query on {0}", future.channel().localAddress());
                    } else {
                        BungeeCord.this.getLogger().log(Level.WARNING, "Could not bind to host " + info.getSocketAddress(), future.cause());
                    }
                }
            };
            new RemoteQuery(this, info).start(PipelineUtils.getDatagramChannel(), new InetSocketAddress(info.getHost().getAddress(), info.getQueryPort()), this.eventLoops, bindListener);
        }
    }

    public void stopListeners() {
        for (Channel listener : this.listeners) {
            this.getLogger().log(Level.INFO, "Closing listener {0}", listener);
            try {
                listener.close().syncUninterruptibly();
            }
            catch (ChannelException ex) {
                this.getLogger().severe("Could not close listen thread");
            }
        }
        this.listeners.clear();
    }

    @Override
    public void stop() {
        this.stop(this.getTranslation("restart", new Object[0]));
    }

    @Override
    public void stop(final String reason) {
        new Thread("Shutdown Thread"){

            @Override
            public void run() {
                BungeeCord.this.independentThreadStop(reason, true);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void independentThreadStop(String reason, boolean callSystemExit) {
        this.shutdownLock.lock();
        if (!this.isRunning) {
            this.shutdownLock.unlock();
            return;
        }
        this.isRunning = false;
        this.stopListeners();
        this.getLogger().info("Closing pending connections");
        this.connectionLock.readLock().lock();
        try {
            this.getLogger().log(Level.INFO, "Disconnecting {0} connections", this.connections.size());
            for (UserConnection user : this.connections.values()) {
                user.disconnect(reason);
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.reconnectHandler != null) {
            this.getLogger().info("Saving reconnect locations");
            this.reconnectHandler.save();
            this.reconnectHandler.close();
        }
        this.saveThread.cancel();
        this.metricsThread.cancel();
        this.getLogger().info("Disabling plugins");
        for (Plugin plugin : Lists.reverse(new ArrayList<Plugin>(this.pluginManager.getPlugins()))) {
            try {
                plugin.onDisable();
                for (Handler handler : plugin.getLogger().getHandlers()) {
                    handler.close();
                }
            }
            catch (Throwable t) {
                this.getLogger().log(Level.SEVERE, "Exception disabling plugin " + plugin.getDescription().getName(), t);
            }
            this.getScheduler().cancel(plugin);
            plugin.getExecutorService().shutdownNow();
        }
        this.getLogger().info("Closing IO threads");
        this.eventLoops.shutdownGracefully();
        try {
            this.eventLoops.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getLogger().info("Thank you and goodbye");
        for (Iterator<Object> iterator : this.getLogger().getHandlers()) {
            ((Handler)((Object)iterator)).close();
        }
        this.shutdownLock.unlock();
        if (callSystemExit) {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(DefinedPacket packet) {
        this.connectionLock.readLock().lock();
        try {
            for (UserConnection con : this.connections.values()) {
                con.unsafe().sendPacket(packet);
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public String getName() {
        return "BungeeCord";
    }

    @Override
    public String getVersion() {
        return BungeeCord.class.getPackage().getImplementationVersion() == null ? "unknown" : BungeeCord.class.getPackage().getImplementationVersion();
    }

    public final void reloadMessages() {
        ResourceBundle baseBundle;
        HashMap<String, Format> cachedFormats = new HashMap<String, Format>();
        File file = new File("messages.properties");
        if (file.isFile()) {
            try (FileReader rd = new FileReader(file);){
                this.cacheResourceBundle(cachedFormats, new PropertyResourceBundle(rd));
            }
            catch (IOException ex) {
                this.getLogger().log(Level.SEVERE, "Could not load custom messages.properties", ex);
            }
        }
        try {
            baseBundle = ResourceBundle.getBundle("messages");
        }
        catch (MissingResourceException ex) {
            baseBundle = ResourceBundle.getBundle("messages", Locale.ENGLISH);
        }
        this.cacheResourceBundle(cachedFormats, baseBundle);
        this.messageFormats = Collections.unmodifiableMap(cachedFormats);
    }

    private void cacheResourceBundle(Map<String, Format> map, ResourceBundle resourceBundle) {
        Enumeration<String> keys = resourceBundle.getKeys();
        while (keys.hasMoreElements()) {
            map.computeIfAbsent(keys.nextElement(), key -> new MessageFormat(resourceBundle.getString((String)key)));
        }
    }

    @Override
    public String getTranslation(String name, Object ... args) {
        Format format = this.messageFormats.get(name);
        return format != null ? format.format(args) : "<translation '" + name + "' missing>";
    }

    @Override
    public Collection<ProxiedPlayer> getPlayers() {
        this.connectionLock.readLock().lock();
        try {
            Collection<ProxiedPlayer> collection = Collections.unmodifiableCollection(new HashSet<UserConnection>(this.connections.values()));
            return collection;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public int getOnlineCount() {
        return this.connections.size();
    }

    @Override
    public ProxiedPlayer getPlayer(String name) {
        this.connectionLock.readLock().lock();
        try {
            ProxiedPlayer proxiedPlayer = this.connections.get(name);
            return proxiedPlayer;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    public UserConnection getPlayerByOfflineUUID(UUID uuid) {
        if (uuid.version() != 3) {
            return null;
        }
        this.connectionLock.readLock().lock();
        try {
            UserConnection userConnection = this.connectionsByOfflineUUID.get(uuid);
            return userConnection;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public ProxiedPlayer getPlayer(UUID uuid) {
        this.connectionLock.readLock().lock();
        try {
            ProxiedPlayer proxiedPlayer = this.connectionsByUUID.get(uuid);
            return proxiedPlayer;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public Map<String, ServerInfo> getServers() {
        return this.config.getServers();
    }

    @Override
    public ServerInfo getServerInfo(String name) {
        return this.getServers().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerChannel(String channel) {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            this.pluginChannels.add(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterChannel(String channel) {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            this.pluginChannels.remove(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getChannels() {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            return Collections.unmodifiableCollection(this.pluginChannels);
        }
    }

    public PluginMessage registerChannels(int protocolVersion) {
        if (protocolVersion >= 393) {
            return new PluginMessage("minecraft:register", String.join((CharSequence)"\u0000", Iterables.transform(this.pluginChannels, PluginMessage.MODERNISE)).getBytes(StandardCharsets.UTF_8), false);
        }
        return new PluginMessage("REGISTER", String.join((CharSequence)"\u0000", this.pluginChannels).getBytes(StandardCharsets.UTF_8), false);
    }

    @Override
    public int getProtocolVersion() {
        return ProtocolConstants.SUPPORTED_VERSION_IDS.get(ProtocolConstants.SUPPORTED_VERSION_IDS.size() - 1);
    }

    @Override
    public String getGameVersion() {
        return ProtocolConstants.SUPPORTED_VERSIONS.get(0) + "-" + ProtocolConstants.SUPPORTED_VERSIONS.get(ProtocolConstants.SUPPORTED_VERSIONS.size() - 1);
    }

    @Override
    public ServerInfo constructServerInfo(String name, InetSocketAddress address, String motd, boolean restricted) {
        return this.constructServerInfo(name, (SocketAddress)address, motd, restricted);
    }

    @Override
    public ServerInfo constructServerInfo(String name, SocketAddress address, String motd, boolean restricted) {
        return new BungeeServerInfo(name, address, motd, restricted);
    }

    @Override
    public CommandSender getConsole() {
        return ConsoleCommandSender.getInstance();
    }

    @Override
    public void broadcast(String message) {
        this.broadcast(TextComponent.fromLegacy(message));
    }

    @Override
    public void broadcast(BaseComponent ... message) {
        this.getConsole().sendMessage(message);
        for (ProxiedPlayer player : this.getPlayers()) {
            player.sendMessage(message);
        }
    }

    @Override
    public void broadcast(BaseComponent message) {
        this.getConsole().sendMessage(message);
        for (ProxiedPlayer player : this.getPlayers()) {
            player.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConnection(UserConnection con) {
        UUID offlineId = con.getPendingConnection().getOfflineId();
        if (offlineId != null && offlineId.version() != 3) {
            throw new IllegalArgumentException("Offline UUID must be a name-based UUID");
        }
        this.connectionLock.writeLock().lock();
        try {
            if (this.connections.containsKey(con.getName()) || this.connectionsByUUID.containsKey(con.getUniqueId()) || this.connectionsByOfflineUUID.containsKey(offlineId)) {
                boolean bl = false;
                return bl;
            }
            this.connections.put(con.getName(), con);
            this.connectionsByUUID.put(con.getUniqueId(), con);
            this.connectionsByOfflineUUID.put(offlineId, con);
        }
        finally {
            this.connectionLock.writeLock().unlock();
        }
        return true;
    }

    public void removeConnection(UserConnection con) {
        this.connectionLock.writeLock().lock();
        try {
            if (this.connections.get(con.getName()) == con) {
                this.connections.remove(con.getName());
                this.connectionsByUUID.remove(con.getUniqueId());
                this.connectionsByOfflineUUID.remove(con.getPendingConnection().getOfflineId());
            }
        }
        finally {
            this.connectionLock.writeLock().unlock();
        }
    }

    @Override
    public Collection<String> getDisabledCommands() {
        return this.config.getDisabledCommands();
    }

    @Override
    public Collection<ProxiedPlayer> matchPlayer(final String partialName) {
        Preconditions.checkNotNull(partialName, "partialName");
        ProxiedPlayer exactMatch = this.getPlayer(partialName);
        if (exactMatch != null) {
            return Collections.singleton(exactMatch);
        }
        return Sets.newHashSet(Iterables.filter(this.getPlayers(), new Predicate<ProxiedPlayer>(){

            @Override
            public boolean apply(ProxiedPlayer input) {
                return input == null ? false : input.getName().toLowerCase(Locale.ROOT).startsWith(partialName.toLowerCase(Locale.ROOT));
            }
        }));
    }

    @Override
    public Title createTitle() {
        return new BungeeTitle();
    }

    @Override
    public ProxyServer.Unsafe unsafe() {
        return this.unsafe;
    }

    @Override
    @Generated
    public Configuration getConfig() {
        return this.config;
    }

    @Override
    @Generated
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    @Generated
    public ReconnectHandler getReconnectHandler() {
        return this.reconnectHandler;
    }

    @Override
    @Generated
    public void setReconnectHandler(ReconnectHandler reconnectHandler) {
        this.reconnectHandler = reconnectHandler;
    }

    @Override
    @Generated
    public ConfigurationAdapter getConfigurationAdapter() {
        return this.configurationAdapter;
    }

    @Override
    @Generated
    public void setConfigurationAdapter(ConfigurationAdapter configurationAdapter) {
        this.configurationAdapter = configurationAdapter;
    }

    @Override
    @Generated
    public File getPluginsFolder() {
        return this.pluginsFolder;
    }

    @Override
    @Generated
    public BungeeScheduler getScheduler() {
        return this.scheduler;
    }

    @Generated
    public LineReader getConsoleReader() {
        return this.consoleReader;
    }

    @Override
    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public ConnectionThrottle getConnectionThrottle() {
        return this.connectionThrottle;
    }
}

