/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.UUID;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.data.PlayerPublicKey;
import net.md_5.bungee.protocol.data.Property;

public class PlayerListItem
extends DefinedPacket {
    private Action action;
    private Item[] items;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.action = Action.values()[DefinedPacket.readVarInt(buf)];
        this.items = new Item[DefinedPacket.readVarInt(buf)];
        block6: for (int i = 0; i < this.items.length; ++i) {
            Item item = this.items[i] = new Item();
            item.setUuid(DefinedPacket.readUUID(buf));
            switch (this.action) {
                case ADD_PLAYER: {
                    item.username = DefinedPacket.readString(buf);
                    item.properties = DefinedPacket.readProperties(buf);
                    item.gamemode = DefinedPacket.readVarInt(buf);
                    item.ping = DefinedPacket.readVarInt(buf);
                    if (buf.readBoolean()) {
                        item.displayName = DefinedPacket.readBaseComponent(buf, protocolVersion);
                    }
                    if (protocolVersion < 759) continue block6;
                    item.publicKey = PlayerListItem.readPublicKey(buf);
                    continue block6;
                }
                case UPDATE_GAMEMODE: {
                    item.gamemode = DefinedPacket.readVarInt(buf);
                    continue block6;
                }
                case UPDATE_LATENCY: {
                    item.ping = DefinedPacket.readVarInt(buf);
                    continue block6;
                }
                case UPDATE_DISPLAY_NAME: {
                    if (!buf.readBoolean()) continue block6;
                    item.displayName = DefinedPacket.readBaseComponent(buf, protocolVersion);
                }
            }
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        DefinedPacket.writeVarInt(this.action.ordinal(), buf);
        DefinedPacket.writeVarInt(this.items.length, buf);
        block6: for (Item item : this.items) {
            DefinedPacket.writeUUID(item.uuid, buf);
            switch (this.action) {
                case ADD_PLAYER: {
                    DefinedPacket.writeString(item.username, buf);
                    DefinedPacket.writeProperties(item.properties, buf);
                    DefinedPacket.writeVarInt(item.gamemode, buf);
                    DefinedPacket.writeVarInt(item.ping, buf);
                    buf.writeBoolean(item.displayName != null);
                    if (item.displayName != null) {
                        DefinedPacket.writeBaseComponent(item.displayName, buf, protocolVersion);
                    }
                    if (protocolVersion < 759) continue block6;
                    PlayerListItem.writePublicKey(item.publicKey, buf);
                    continue block6;
                }
                case UPDATE_GAMEMODE: {
                    DefinedPacket.writeVarInt(item.gamemode, buf);
                    continue block6;
                }
                case UPDATE_LATENCY: {
                    DefinedPacket.writeVarInt(item.ping, buf);
                    continue block6;
                }
                case UPDATE_DISPLAY_NAME: {
                    buf.writeBoolean(item.displayName != null);
                    if (item.displayName == null) continue block6;
                    DefinedPacket.writeBaseComponent(item.displayName, buf, protocolVersion);
                }
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @Generated
    public Action getAction() {
        return this.action;
    }

    @Generated
    public Item[] getItems() {
        return this.items;
    }

    @Generated
    public void setAction(Action action) {
        this.action = action;
    }

    @Generated
    public void setItems(Item[] items) {
        this.items = items;
    }

    @Override
    @Generated
    public String toString() {
        return "PlayerListItem(action=" + (Object)((Object)this.getAction()) + ", items=" + Arrays.deepToString(this.getItems()) + ")";
    }

    @Generated
    public PlayerListItem() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerListItem)) {
            return false;
        }
        PlayerListItem other = (PlayerListItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        return Arrays.deepEquals(this.getItems(), other.getItems());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PlayerListItem;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getItems());
        return result;
    }

    public static enum Action {
        ADD_PLAYER,
        UPDATE_GAMEMODE,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME,
        REMOVE_PLAYER;

    }

    public static class Item {
        UUID uuid;
        String username;
        Property[] properties;
        UUID chatSessionId;
        PlayerPublicKey publicKey;
        Boolean listed;
        Integer gamemode;
        Integer ping;
        BaseComponent displayName;
        Integer listOrder;
        Boolean showHat;

        @Generated
        public Item() {
        }

        @Generated
        public UUID getUuid() {
            return this.uuid;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public Property[] getProperties() {
            return this.properties;
        }

        @Generated
        public UUID getChatSessionId() {
            return this.chatSessionId;
        }

        @Generated
        public PlayerPublicKey getPublicKey() {
            return this.publicKey;
        }

        @Generated
        public Boolean getListed() {
            return this.listed;
        }

        @Generated
        public Integer getGamemode() {
            return this.gamemode;
        }

        @Generated
        public Integer getPing() {
            return this.ping;
        }

        @Generated
        public BaseComponent getDisplayName() {
            return this.displayName;
        }

        @Generated
        public Integer getListOrder() {
            return this.listOrder;
        }

        @Generated
        public Boolean getShowHat() {
            return this.showHat;
        }

        @Generated
        public void setUuid(UUID uuid) {
            this.uuid = uuid;
        }

        @Generated
        public void setUsername(String username) {
            this.username = username;
        }

        @Generated
        public void setProperties(Property[] properties) {
            this.properties = properties;
        }

        @Generated
        public void setChatSessionId(UUID chatSessionId) {
            this.chatSessionId = chatSessionId;
        }

        @Generated
        public void setPublicKey(PlayerPublicKey publicKey) {
            this.publicKey = publicKey;
        }

        @Generated
        public void setListed(Boolean listed) {
            this.listed = listed;
        }

        @Generated
        public void setGamemode(Integer gamemode) {
            this.gamemode = gamemode;
        }

        @Generated
        public void setPing(Integer ping) {
            this.ping = ping;
        }

        @Generated
        public void setDisplayName(BaseComponent displayName) {
            this.displayName = displayName;
        }

        @Generated
        public void setListOrder(Integer listOrder) {
            this.listOrder = listOrder;
        }

        @Generated
        public void setShowHat(Boolean showHat) {
            this.showHat = showHat;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$listed = this.getListed();
            Boolean other$listed = other.getListed();
            if (this$listed == null ? other$listed != null : !((Object)this$listed).equals(other$listed)) {
                return false;
            }
            Integer this$gamemode = this.getGamemode();
            Integer other$gamemode = other.getGamemode();
            if (this$gamemode == null ? other$gamemode != null : !((Object)this$gamemode).equals(other$gamemode)) {
                return false;
            }
            Integer this$ping = this.getPing();
            Integer other$ping = other.getPing();
            if (this$ping == null ? other$ping != null : !((Object)this$ping).equals(other$ping)) {
                return false;
            }
            Integer this$listOrder = this.getListOrder();
            Integer other$listOrder = other.getListOrder();
            if (this$listOrder == null ? other$listOrder != null : !((Object)this$listOrder).equals(other$listOrder)) {
                return false;
            }
            Boolean this$showHat = this.getShowHat();
            Boolean other$showHat = other.getShowHat();
            if (this$showHat == null ? other$showHat != null : !((Object)this$showHat).equals(other$showHat)) {
                return false;
            }
            UUID this$uuid = this.getUuid();
            UUID other$uuid = other.getUuid();
            if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getProperties(), other.getProperties())) {
                return false;
            }
            UUID this$chatSessionId = this.getChatSessionId();
            UUID other$chatSessionId = other.getChatSessionId();
            if (this$chatSessionId == null ? other$chatSessionId != null : !((Object)this$chatSessionId).equals(other$chatSessionId)) {
                return false;
            }
            PlayerPublicKey this$publicKey = this.getPublicKey();
            PlayerPublicKey other$publicKey = other.getPublicKey();
            if (this$publicKey == null ? other$publicKey != null : !((Object)this$publicKey).equals(other$publicKey)) {
                return false;
            }
            BaseComponent this$displayName = this.getDisplayName();
            BaseComponent other$displayName = other.getDisplayName();
            return !(this$displayName == null ? other$displayName != null : !((Object)this$displayName).equals(other$displayName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Item;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $listed = this.getListed();
            result = result * 59 + ($listed == null ? 43 : ((Object)$listed).hashCode());
            Integer $gamemode = this.getGamemode();
            result = result * 59 + ($gamemode == null ? 43 : ((Object)$gamemode).hashCode());
            Integer $ping = this.getPing();
            result = result * 59 + ($ping == null ? 43 : ((Object)$ping).hashCode());
            Integer $listOrder = this.getListOrder();
            result = result * 59 + ($listOrder == null ? 43 : ((Object)$listOrder).hashCode());
            Boolean $showHat = this.getShowHat();
            result = result * 59 + ($showHat == null ? 43 : ((Object)$showHat).hashCode());
            UUID $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getProperties());
            UUID $chatSessionId = this.getChatSessionId();
            result = result * 59 + ($chatSessionId == null ? 43 : ((Object)$chatSessionId).hashCode());
            PlayerPublicKey $publicKey = this.getPublicKey();
            result = result * 59 + ($publicKey == null ? 43 : ((Object)$publicKey).hashCode());
            BaseComponent $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : ((Object)$displayName).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PlayerListItem.Item(uuid=" + this.getUuid() + ", username=" + this.getUsername() + ", properties=" + Arrays.deepToString(this.getProperties()) + ", chatSessionId=" + this.getChatSessionId() + ", publicKey=" + this.getPublicKey() + ", listed=" + this.getListed() + ", gamemode=" + this.getGamemode() + ", ping=" + this.getPing() + ", displayName=" + this.getDisplayName() + ", listOrder=" + this.getListOrder() + ", showHat=" + this.getShowHat() + ")";
        }
    }
}

