/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.chat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.Set;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentStyle;
import net.md_5.bungee.api.chat.ItemTag;
import net.md_5.bungee.api.chat.KeybindComponent;
import net.md_5.bungee.api.chat.ObjectComponent;
import net.md_5.bungee.api.chat.ScoreComponent;
import net.md_5.bungee.api.chat.SelectorComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Entity;
import net.md_5.bungee.api.chat.hover.content.EntitySerializer;
import net.md_5.bungee.api.chat.hover.content.Item;
import net.md_5.bungee.api.chat.hover.content.ItemSerializer;
import net.md_5.bungee.api.chat.hover.content.Text;
import net.md_5.bungee.api.chat.hover.content.TextSerializer;
import net.md_5.bungee.api.dialog.Dialog;
import net.md_5.bungee.api.dialog.action.Action;
import net.md_5.bungee.api.dialog.chat.ShowDialogClickEvent;
import net.md_5.bungee.chat.ChatVersion;
import net.md_5.bungee.chat.ComponentStyleSerializer;
import net.md_5.bungee.chat.KeybindComponentSerializer;
import net.md_5.bungee.chat.ObjectComponentSerializer;
import net.md_5.bungee.chat.ScoreComponentSerializer;
import net.md_5.bungee.chat.SelectorComponentSerializer;
import net.md_5.bungee.chat.TextComponentSerializer;
import net.md_5.bungee.chat.TranslatableComponentSerializer;
import net.md_5.bungee.serializer.dialog.DialogActionSerializer;
import net.md_5.bungee.serializer.dialog.DialogSerializer;
import net.md_5.bungee.serializer.dialog.ShowDialogClickEventSerializer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class VersionedComponentSerializer
implements JsonDeserializer<BaseComponent> {
    @ApiStatus.Internal
    private final Gson gson;
    @ApiStatus.Internal
    private final ChatVersion version;
    @ApiStatus.Internal
    private final DialogSerializer dialogSerializer;
    private static final VersionedComponentSerializer v1_16 = new VersionedComponentSerializer(ChatVersion.V1_16);
    private static final VersionedComponentSerializer v1_21_5 = new VersionedComponentSerializer(ChatVersion.V1_21_5);
    @ApiStatus.Internal
    public static final ThreadLocal<Set<BaseComponent>> serializedComponents = new ThreadLocal();

    public VersionedComponentSerializer(ChatVersion version) {
        this.version = version;
        this.dialogSerializer = new DialogSerializer(this);
        this.gson = new GsonBuilder().registerTypeAdapter((Type)((Object)BaseComponent.class), this).registerTypeAdapter((Type)((Object)TextComponent.class), new TextComponentSerializer(this)).registerTypeAdapter((Type)((Object)TranslatableComponent.class), new TranslatableComponentSerializer(this)).registerTypeAdapter((Type)((Object)KeybindComponent.class), new KeybindComponentSerializer(this)).registerTypeAdapter((Type)((Object)ScoreComponent.class), new ScoreComponentSerializer(this)).registerTypeAdapter((Type)((Object)SelectorComponent.class), new SelectorComponentSerializer(this)).registerTypeAdapter((Type)((Object)ObjectComponent.class), new ObjectComponentSerializer(this)).registerTypeAdapter((Type)((Object)ComponentStyle.class), new ComponentStyleSerializer()).registerTypeAdapter((Type)((Object)Entity.class), new EntitySerializer(this)).registerTypeAdapter((Type)((Object)Text.class), new TextSerializer()).registerTypeAdapter((Type)((Object)Item.class), new ItemSerializer()).registerTypeAdapter((Type)((Object)ItemTag.class), new ItemTag.Serializer()).registerTypeAdapter((Type)((Object)Dialog.class), this.dialogSerializer).registerTypeAdapter((Type)((Object)ShowDialogClickEvent.class), new ShowDialogClickEventSerializer()).registerTypeAdapter((Type)((Object)Action.class), new DialogActionSerializer()).create();
    }

    public static VersionedComponentSerializer forVersion(ChatVersion version) {
        switch (version) {
            case V1_16: {
                return v1_16;
            }
            case V1_21_5: {
                return v1_21_5;
            }
        }
        throw new IllegalArgumentException("Unknown version " + (Object)((Object)version));
    }

    @Deprecated
    @ApiStatus.Internal
    public static VersionedComponentSerializer getDefault() {
        return v1_16;
    }

    public BaseComponent[] parse(String json) {
        JsonElement jsonElement = JsonParser.parseString(json);
        if (jsonElement.isJsonArray()) {
            return this.gson.fromJson(jsonElement, BaseComponent[].class);
        }
        return new BaseComponent[]{this.gson.fromJson(jsonElement, BaseComponent.class)};
    }

    public BaseComponent deserialize(String json) {
        JsonElement jsonElement = JsonParser.parseString(json);
        return this.deserialize(jsonElement);
    }

    public BaseComponent deserialize(JsonElement jsonElement) {
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)jsonElement;
            if (primitive.isString()) {
                return new TextComponent(primitive.getAsString());
            }
        } else if (jsonElement instanceof JsonArray) {
            BaseComponent[] array = this.gson.fromJson(jsonElement, BaseComponent[].class);
            return TextComponent.fromArray(array);
        }
        return this.gson.fromJson(jsonElement, BaseComponent.class);
    }

    public ComponentStyle deserializeStyle(String json) {
        JsonElement jsonElement = JsonParser.parseString(json);
        return this.deserializeStyle(jsonElement);
    }

    public ComponentStyle deserializeStyle(JsonElement jsonElement) {
        return this.gson.fromJson(jsonElement, ComponentStyle.class);
    }

    public JsonElement toJson(BaseComponent component) {
        return this.gson.toJsonTree(component);
    }

    public JsonElement toJson(ComponentStyle style) {
        return this.gson.toJsonTree(style);
    }

    @Deprecated
    public String toString(Object object) {
        return this.gson.toJson(object);
    }

    @Deprecated
    public String toString(Content content) {
        return this.gson.toJson(content);
    }

    public String toString(BaseComponent component) {
        return this.gson.toJson(component);
    }

    public String toString(BaseComponent ... components) {
        if (components.length == 1) {
            return this.gson.toJson(components[0]);
        }
        return this.gson.toJson(new TextComponent(components));
    }

    public String toString(ComponentStyle style) {
        return this.gson.toJson(style);
    }

    @Override
    public BaseComponent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonPrimitive()) {
            return new TextComponent(json.getAsString());
        }
        if (json.isJsonArray()) {
            JsonArray arr = json.getAsJsonArray();
            BaseComponent[] components = new BaseComponent[arr.size()];
            for (int i = 0; i < arr.size(); ++i) {
                components[i] = this.deserialize(arr.get(i), (Type)((Object)BaseComponent.class), context);
            }
            return TextComponent.fromArray(components);
        }
        JsonObject object = json.getAsJsonObject();
        if (object.has("translate")) {
            return (BaseComponent)context.deserialize(json, (Type)((Object)TranslatableComponent.class));
        }
        if (object.has("keybind")) {
            return (BaseComponent)context.deserialize(json, (Type)((Object)KeybindComponent.class));
        }
        if (object.has("score")) {
            return (BaseComponent)context.deserialize(json, (Type)((Object)ScoreComponent.class));
        }
        if (object.has("selector")) {
            return (BaseComponent)context.deserialize(json, (Type)((Object)SelectorComponent.class));
        }
        if (object.has("player") || object.has("sprite")) {
            return (BaseComponent)context.deserialize(json, (Type)((Object)ObjectComponent.class));
        }
        return (BaseComponent)context.deserialize(json, (Type)((Object)TextComponent.class));
    }

    @Generated
    public Gson getGson() {
        return this.gson;
    }

    @Generated
    public ChatVersion getVersion() {
        return this.version;
    }

    @Generated
    public DialogSerializer getDialogSerializer() {
        return this.dialogSerializer;
    }
}

