/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.uring.AbstractIoUringBufferRingAllocator;
import io.netty.util.internal.ObjectUtil;

public final class IoUringFixedBufferRingAllocator
extends AbstractIoUringBufferRingAllocator {
    private final int bufferSize;

    public IoUringFixedBufferRingAllocator(ByteBufAllocator allocator, boolean largeAllocation, int bufferSize) {
        super(allocator, largeAllocation);
        this.bufferSize = ObjectUtil.checkPositive(bufferSize, "bufferSize");
    }

    public IoUringFixedBufferRingAllocator(ByteBufAllocator allocator, int bufferSize) {
        this(allocator, false, bufferSize);
    }

    public IoUringFixedBufferRingAllocator(int bufferSize) {
        this(ByteBufAllocator.DEFAULT, bufferSize);
    }

    @Override
    protected int nextBufferSize() {
        return this.bufferSize;
    }
}

