/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.representer;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.SafeRepresenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Representer
extends SafeRepresenter {
    public Representer() {
        this.representers.put(null, new RepresentJavaBean(this));
    }

    protected final MappingNode representJavaBean(Set<Property> properties, Object javaBean) {
        ArrayList<NodeTuple> value = new ArrayList<NodeTuple>(properties.size());
        Tag customTag = (Tag)this.classTags.get(javaBean.getClass());
        Tag tag = customTag != null ? customTag : new Tag(javaBean.getClass());
        MappingNode node = new MappingNode(tag, value, null);
        this.representedObjects.put(javaBean, node);
        boolean bestStyle = true;
        for (Property property : properties) {
            Node nodeValue;
            NodeTuple nodeTuple;
            Tag customPropertyTag;
            Object memberValue = property.get(javaBean);
            Tag tag2 = customPropertyTag = memberValue == null ? null : (Tag)this.classTags.get(memberValue.getClass());
            Object object = memberValue;
            memberValue = property;
            Representer representer = this;
            ScalarNode scalarNode = (ScalarNode)representer.representData(((Property)memberValue).getName());
            boolean bl = representer.representedObjects.containsKey(object);
            Node node2 = representer.representData(object);
            if (object != null && !bl) {
                NodeId nodeId = node2.getNodeId();
                if (tag2 == null) {
                    if (nodeId == NodeId.scalar) {
                        if (object instanceof Enum) {
                            node2.setTag(Tag.STR);
                        }
                    } else {
                        if (nodeId == NodeId.mapping && ((Property)memberValue).getType() == object.getClass() && !(object instanceof Map) && !node2.getTag().equals(Tag.SET)) {
                            node2.setTag(Tag.MAP);
                        }
                        representer.checkGlobalTag((Property)memberValue, node2, object);
                    }
                }
            }
            if ((nodeTuple = new NodeTuple(scalarNode, node2)) == null) continue;
            if (((ScalarNode)nodeTuple.getKeyNode()).getStyle() != null) {
                bestStyle = false;
            }
            if (!((nodeValue = nodeTuple.getValueNode()) instanceof ScalarNode) || ((ScalarNode)nodeValue).getStyle() != null) {
                bestStyle = false;
            }
            value.add(nodeTuple);
        }
        if (this.defaultFlowStyle != DumperOptions.FlowStyle.AUTO) {
            node.setFlowStyle(this.defaultFlowStyle.getStyleBoolean());
        } else {
            node.setFlowStyle(bestStyle);
        }
        return node;
    }

    private void checkGlobalTag(Property property, Node node, Object object) {
        Class<?>[] arguments = property.getActualTypeArguments();
        if (arguments != null) {
            Node keyNode;
            Object member;
            Object iter;
            List<Object> memberList;
            if (node.getNodeId() == NodeId.sequence) {
                Class<?> t = arguments[0];
                SequenceNode snode = (SequenceNode)node;
                memberList = object.getClass().isArray() ? Arrays.asList((Object[])object) : (List<Object>)object;
                iter = memberList.iterator();
                for (Node childNode : snode.getValue()) {
                    Object member2 = iter.next();
                    if (member2 == null || !t.equals(member2.getClass()) || childNode.getNodeId() != NodeId.mapping) continue;
                    childNode.setTag(Tag.MAP);
                }
                return;
            }
            if (iter instanceof Set) {
                Node childNode;
                void t = childNode[0];
                childNode = (MappingNode)((Object)memberList);
                Iterator<NodeTuple> iter2 = ((MappingNode)childNode).getValue().iterator();
                iter = (Set)iter;
                Iterator i$ = iter.iterator();
                while (i$.hasNext()) {
                    member = i$.next();
                    NodeTuple nodeTuple = iter2.next();
                    keyNode = nodeTuple.getKeyNode();
                    if (!t.equals(member.getClass()) || keyNode.getNodeId() != NodeId.mapping) continue;
                    keyNode.setTag(Tag.MAP);
                }
                return;
            }
            if (keyNode instanceof Map) {
                MappingNode mappingNode;
                void keyType = member[0];
                void valueType = member[1];
                mappingNode = mappingNode;
                for (NodeTuple tuple : mappingNode.getValue()) {
                    Representer.resetTag((Class<? extends Object>)keyType, tuple.getKeyNode());
                    Representer.resetTag((Class<? extends Object>)valueType, tuple.getValueNode());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void resetTag(Class<? extends Object> type, Node node) {
        Tag tag = node.getTag();
        if (tag.matches(type)) {
            void var1_1;
            Class<? extends Object> clazz;
            if (Enum.class.isAssignableFrom(clazz)) {
                node.setTag(Tag.STR);
                return;
            }
            var1_1.setTag(Tag.MAP);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final Set<Property> getProperties(Class<? extends Object> type) throws IntrospectionException {
        void var1_1;
        return this.getPropertyUtils().getProperties((Class<? extends Object>)var1_1);
    }

    public final class RepresentJavaBean
    implements Represent {
        private /* synthetic */ Representer this$0;

        protected RepresentJavaBean(Representer representer) {
            this.this$0 = representer;
        }

        /*
         * WARNING - void declaration
         */
        public final Node representData(Object data) {
            try {
                return this.this$0.representJavaBean(this.this$0.getProperties(data.getClass()), data);
            }
            catch (IntrospectionException e) {
                void var1_2;
                throw new YAMLException((Throwable)var1_2);
            }
        }
    }
}

