/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.representer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRepresenter {
    protected final Map<Class<?>, Represent> representers = new HashMap();
    protected Represent nullRepresenter;
    protected final Map<Class<?>, Represent> multiRepresenters = new LinkedHashMap();
    protected Character defaultScalarStyle;
    protected DumperOptions.FlowStyle defaultFlowStyle = DumperOptions.FlowStyle.AUTO;
    protected final Map<Object, Node> representedObjects = new IdentityHashMap<Object, Node>(this){};
    private Object objectToRepresent;
    private PropertyUtils propertyUtils;
    private boolean explicitPropertyUtils = false;

    /*
     * WARNING - void declaration
     */
    public final Node represent(Object data) {
        void var1_1;
        Node node = this.representData(data);
        this.representedObjects.clear();
        this.objectToRepresent = null;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected final Node representData(Object data) {
        void var1_1;
        Node node;
        this.objectToRepresent = data;
        if (this.representedObjects.containsKey(this.objectToRepresent)) {
            data = this.representedObjects.get(this.objectToRepresent);
            return data;
        }
        if (data == null) {
            data = this.nullRepresenter.representData(null);
            return data;
        }
        Class<?> clazz = data.getClass();
        if (this.representers.containsKey(clazz)) {
            Represent represent = this.representers.get(clazz);
            node = represent.representData(data);
        } else {
            Represent represent;
            void var2_2;
            for (Class<?> repr : this.multiRepresenters.keySet()) {
                if (!repr.isInstance(node)) continue;
                clazz = this.multiRepresenters.get(repr);
                node = clazz.representData(node);
                return node;
            }
            if (var2_2.isArray()) {
                throw new YAMLException("Arrays of primitives are not fully supported.");
            }
            if (this.multiRepresenters.containsKey(null)) {
                represent = this.multiRepresenters.get(null);
                node = represent.representData(node);
            } else {
                represent = this.representers.get(null);
                node = represent.representData(node);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected final Node representScalar(Tag tag, String value, Character style) {
        void var3_3;
        void var2_2;
        ScalarNode scalarNode;
        if (style == null) {
            style = this.defaultScalarStyle;
        }
        scalarNode = new ScalarNode((Tag)((Object)scalarNode), (String)var2_2, null, null, (Character)var3_3);
        return scalarNode;
    }

    /*
     * WARNING - void declaration
     */
    protected final Node representScalar(Tag tag, String value) {
        void var2_2;
        void var1_1;
        return this.representScalar((Tag)var1_1, (String)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    protected final Node representSequence(Tag tag, Iterable<? extends Object> sequence, Boolean flowStyle) {
        void var1_1;
        int size = 10;
        if (sequence instanceof List) {
            size = ((List)sequence).size();
        }
        ArrayList<Node> value = new ArrayList<Node>(size);
        SequenceNode node = new SequenceNode(tag, value, null);
        this.representedObjects.put(this.objectToRepresent, node);
        boolean bestStyle = true;
        for (Object object : sequence) {
            Node node2 = this.representData(object);
            if (!(node2 instanceof ScalarNode) || ((ScalarNode)node2).getStyle() != null) {
                bestStyle = false;
            }
            value.add(node2);
        }
        if (this.defaultFlowStyle != DumperOptions.FlowStyle.AUTO) {
            node.setFlowStyle(this.defaultFlowStyle.getStyleBoolean());
        } else {
            node.setFlowStyle(bestStyle);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected final Node representMapping(Tag tag, Map<? extends Object, Object> mapping, Boolean flowStyle) {
        void var1_1;
        ArrayList<NodeTuple> value = new ArrayList<NodeTuple>(mapping.size());
        MappingNode node = new MappingNode(tag, value, null);
        this.representedObjects.put(this.objectToRepresent, node);
        boolean bestStyle = true;
        for (Map.Entry<? extends Object, Object> entry : mapping.entrySet()) {
            Node nodeKey = this.representData(entry.getKey());
            Node nodeValue = this.representData(entry.getValue());
            if (!(nodeKey instanceof ScalarNode) || ((ScalarNode)nodeKey).getStyle() != null) {
                bestStyle = false;
            }
            if (!(nodeValue instanceof ScalarNode) || ((ScalarNode)nodeValue).getStyle() != null) {
                bestStyle = false;
            }
            value.add(new NodeTuple(nodeKey, nodeValue));
        }
        if (this.defaultFlowStyle != DumperOptions.FlowStyle.AUTO) {
            node.setFlowStyle(this.defaultFlowStyle.getStyleBoolean());
        } else {
            node.setFlowStyle(bestStyle);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDefaultScalarStyle(DumperOptions.ScalarStyle defaultStyle) {
        void var1_1;
        this.defaultScalarStyle = var1_1.getChar();
    }

    /*
     * WARNING - void declaration
     */
    public final void setDefaultFlowStyle(DumperOptions.FlowStyle defaultFlowStyle) {
        void var1_1;
        this.defaultFlowStyle = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPropertyUtils(PropertyUtils propertyUtils) {
        void var1_1;
        this.propertyUtils = var1_1;
        this.explicitPropertyUtils = true;
    }

    public final PropertyUtils getPropertyUtils() {
        if (this.propertyUtils == null) {
            this.propertyUtils = new PropertyUtils();
        }
        return this.propertyUtils;
    }

    public final boolean isExplicitPropertyUtils() {
        return this.explicitPropertyUtils;
    }
}

