/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.constructor;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseConstructor {
    protected final Map<NodeId, Construct> yamlClassConstructors = new EnumMap<NodeId, Construct>(NodeId.class);
    protected final Map<Tag, Construct> yamlConstructors = new HashMap<Tag, Construct>();
    private Map<String, Construct> yamlMultiConstructors = new HashMap<String, Construct>();
    private Composer composer;
    private final Map<Node, Object> constructedObjects = new HashMap<Node, Object>();
    private final Set<Node> recursiveObjects = new HashSet<Node>();
    private final ArrayList<RecursiveTuple<Map<Object, Object>, RecursiveTuple<Object, Object>>> maps2fill = new ArrayList();
    private final ArrayList<RecursiveTuple<Set<Object>, Object>> sets2fill = new ArrayList();
    protected Tag rootTag = null;
    private PropertyUtils propertyUtils;
    private boolean explicitPropertyUtils = false;

    /*
     * WARNING - void declaration
     */
    public final void setComposer(Composer composer) {
        void var1_1;
        this.composer = var1_1;
    }

    public final Object getSingleData(Class<?> type) {
        Node node = this.composer.getSingleNode();
        if (node != null) {
            Object object;
            BaseConstructor baseConstructor;
            if (Object.class != type) {
                node.setTag(new Tag((Class<? extends Object>)((Object)baseConstructor)));
            } else if (this.rootTag != null) {
                node.setTag(this.rootTag);
            }
            baseConstructor = this;
            object = baseConstructor.constructObject((Node)object);
            BaseConstructor baseConstructor2 = baseConstructor;
            if (!baseConstructor2.maps2fill.isEmpty()) {
                for (RecursiveTuple<Map<Object, Object>, RecursiveTuple<Object, Object>> recursiveTuple : baseConstructor2.maps2fill) {
                    RecursiveTuple<Object, Object> recursiveTuple2 = recursiveTuple._2();
                    recursiveTuple._1().put(recursiveTuple2._1(), recursiveTuple2._2());
                }
                baseConstructor2.maps2fill.clear();
            }
            if (!baseConstructor2.sets2fill.isEmpty()) {
                for (RecursiveTuple<Object, Object> recursiveTuple : baseConstructor2.sets2fill) {
                    ((Set)recursiveTuple._1()).add(recursiveTuple._2());
                }
                baseConstructor2.sets2fill.clear();
            }
            baseConstructor.constructedObjects.clear();
            baseConstructor.recursiveObjects.clear();
            return object;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected final Object constructObject(Node node) {
        Construct construct;
        BaseConstructor baseConstructor;
        Node node2;
        block8: {
            if (this.constructedObjects.containsKey(node)) {
                return this.constructedObjects.get(node);
            }
            if (this.recursiveObjects.contains(node)) {
                throw new ConstructorException(null, null, "found unconstructable recursive node", node.getStartMark());
            }
            this.recursiveObjects.add(node);
            node2 = node;
            baseConstructor = this;
            if (node2.useClassConstructor()) {
                construct = baseConstructor.yamlClassConstructors.get((Object)node2.getNodeId());
            } else {
                Construct construct2 = baseConstructor.yamlConstructors.get(node2.getTag());
                if (construct2 == null) {
                    for (String string : baseConstructor.yamlMultiConstructors.keySet()) {
                        if (!node2.getTag().startsWith(string)) continue;
                        construct = baseConstructor.yamlMultiConstructors.get(string);
                        break block8;
                    }
                    construct = baseConstructor.yamlConstructors.get(null);
                } else {
                    construct = construct2;
                }
            }
        }
        Construct constructor = construct;
        Object data = construct.construct(node);
        this.constructedObjects.put(node, data);
        this.recursiveObjects.remove(node);
        if (node.isTwoStepsConstruction()) {
            void var1_1;
            baseConstructor.construct2ndStep((Node)var1_1, data);
        }
        return node2;
    }

    protected static List<Object> createDefaultList(int initSize) {
        int n;
        return new ArrayList<Object>(n);
    }

    /*
     * WARNING - void declaration
     */
    protected static <T> T[] createArray(Class<T> type, int size) {
        void var1_1;
        return (Object[])Array.newInstance(type.getComponentType(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected final List<? extends Object> constructSequence(SequenceNode node) {
        void var2_3;
        void var1_1;
        List result;
        if (List.class.isAssignableFrom(node.getType()) && !node.getType().isInterface()) {
            try {
                result = (List)node.getType().newInstance();
            }
            catch (Exception e) {
                void var1_2;
                throw new YAMLException((Throwable)var1_2);
            }
        } else {
            result = BaseConstructor.createDefaultList(var1_1.getValue().size());
        }
        this.constructSequenceStep2((SequenceNode)var1_1, result);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    protected final Set<? extends Object> constructSet(SequenceNode node) {
        void var2_3;
        void var1_1;
        LinkedHashSet<Object> result22;
        if (!node.getType().isInterface()) {
            try {
                result22 = (LinkedHashSet<Object>)node.getType().newInstance();
            }
            catch (Exception e) {
                void var1_2;
                throw new YAMLException((Throwable)var1_2);
            }
        } else {
            int result22 = var1_1.getValue().size();
            result22 = new LinkedHashSet<Object>(result22);
        }
        this.constructSequenceStep2((SequenceNode)var1_1, result22);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    protected final Object constructArray(SequenceNode node) {
        void var1_1;
        return this.constructArrayStep2(node, BaseConstructor.createArray(node.getType(), var1_1.getValue().size()));
    }

    /*
     * WARNING - void declaration
     */
    protected final void constructSequenceStep2(SequenceNode node, Collection<Object> collection) {
        for (Node child : node.getValue()) {
            void var3_3;
            collection.add(this.constructObject((Node)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final Object constructArrayStep2(SequenceNode node, Object array) {
        void var2_2;
        int index = 0;
        for (Node child : node.getValue()) {
            Array.set(array, index++, this.constructObject(child));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected final Set<Object> constructSet(MappingNode node) {
        void var2_2;
        void var1_1;
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        this.constructSet2ndStep((MappingNode)var1_1, set);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected final Map<Object, Object> constructMapping(MappingNode node) {
        void var2_2;
        void var1_1;
        LinkedHashMap<Object, Object> mapping = new LinkedHashMap<Object, Object>();
        this.constructMapping2ndStep((MappingNode)var1_1, mapping);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void constructMapping2ndStep(MappingNode node, Map<Object, Object> mapping) {
        List<NodeTuple> list = node.getValue();
        for (NodeTuple tuple : list) {
            void e2;
            Node keyNode = tuple.getKeyNode();
            Node valueNode = tuple.getValueNode();
            Object key = this.constructObject(keyNode);
            if (key != null) {
                try {
                    key.hashCode();
                }
                catch (Exception e2) {
                    throw new ConstructorException("while constructing a mapping", node.getStartMark(), "found unacceptable key " + key, tuple.getKeyNode().getStartMark(), e2);
                }
            }
            Object value = this.constructObject((Node)e2);
            if (keyNode.isTwoStepsConstruction()) {
                this.maps2fill.add(0, new RecursiveTuple<Map<Object, Object>, RecursiveTuple<Object, Object>>(mapping, new RecursiveTuple<Object, Object>(key, value)));
                continue;
            }
            mapping.put(key, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void constructSet2ndStep(MappingNode node, Set<Object> set) {
        List<NodeTuple> list = node.getValue();
        for (NodeTuple tuple : list) {
            void var2_2;
            Node keyNode = tuple.getKeyNode();
            Object key = this.constructObject(keyNode);
            if (key != null) {
                try {
                    key.hashCode();
                }
                catch (Exception e) {
                    void var2_3;
                    throw new ConstructorException("while constructing a Set", node.getStartMark(), "found unacceptable key " + key, tuple.getKeyNode().getStartMark(), (Throwable)var2_3);
                }
            }
            if (keyNode.isTwoStepsConstruction()) {
                this.sets2fill.add(0, new RecursiveTuple<void, Object>(var2_2, key));
                continue;
            }
            var2_2.add(key);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setPropertyUtils(PropertyUtils propertyUtils) {
        void var1_1;
        this.propertyUtils = var1_1;
        this.explicitPropertyUtils = true;
    }

    public final PropertyUtils getPropertyUtils() {
        if (this.propertyUtils == null) {
            this.propertyUtils = new PropertyUtils();
        }
        return this.propertyUtils;
    }

    public final boolean isExplicitPropertyUtils() {
        return this.explicitPropertyUtils;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RecursiveTuple<T, K> {
        private final T _1;
        private final K _2;

        /*
         * WARNING - void declaration
         */
        public RecursiveTuple(T _1, K _2) {
            void var2_2;
            void var1_1;
            this._1 = var1_1;
            this._2 = var2_2;
        }

        public final K _2() {
            return this._2;
        }

        public final T _1() {
            return this._1;
        }
    }
}

