/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class RankedSequence<T>
implements Iterable<T> {
    private static final long serialVersionUID = 1L;
    private static final AtomicReferenceFieldUpdater<RankedSequence, Content> CONTENT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(RankedSequence.class, Content.class, "content");
    volatile Content content;

    RankedSequence() {
    }

    RankedSequence(RankedSequence<T> sequence) {
        if (null != sequence) {
            this.content = sequence.content;
        }
    }

    public void insert(T element, int rank) {
        Content n;
        Content o;
        while (!CONTENT_UPDATER.compareAndSet(this, o, n = null != (o = this.content) ? o.insert(element, rank) : new Content(element, rank))) {
        }
    }

    public T peek() {
        Content snapshot = this.content;
        return (T)(null != snapshot ? snapshot.objs[0] : null);
    }

    public boolean contains(Object element) {
        Content snapshot = this.content;
        return null != snapshot && snapshot.indexOf(element) >= 0;
    }

    public boolean containsThis(Object element) {
        Content snapshot = this.content;
        return null != snapshot && snapshot.indexOfThis(element) >= 0;
    }

    public T remove(Object element) {
        int index;
        Content n;
        Content o;
        do {
            if (null != (o = this.content) && (index = o.indexOf(element)) >= 0) continue;
            return null;
        } while (!CONTENT_UPDATER.compareAndSet(this, o, n = o.remove(index)));
        return (T)o.objs[index];
    }

    public boolean removeThis(T element) {
        int index;
        Content n;
        Content o;
        do {
            if (null != (o = this.content) && (index = o.indexOfThis(element)) >= 0) continue;
            return false;
        } while (!CONTENT_UPDATER.compareAndSet(this, o, n = o.remove(index)));
        return true;
    }

    public Iterable<T> snapshot() {
        Content snapshot = this.content;
        return null != snapshot ? Arrays.asList(snapshot.objs) : Collections.EMPTY_SET;
    }

    public void clear() {
        this.content = null;
    }

    public boolean isEmpty() {
        return null == this.content;
    }

    public int size() {
        Content snapshot = this.content;
        return null != snapshot ? snapshot.objs.length : 0;
    }

    public Itr iterator() {
        return new Itr();
    }

    static long rank2uid(int rank, int uniq) {
        return (long)(~rank) << 32 | 0xFFFFFFFFL & (long)uniq;
    }

    static int uid2rank(long uid) {
        return (int)((uid ^ 0xFFFFFFFFFFFFFFFFL) >>> 32);
    }

    static int safeBinarySearch(long[] uids, long uid) {
        if (uid < uids[0]) {
            return 0;
        }
        int min = 0;
        int max = uids.length - 1;
        while (min < max) {
            int m = min + max >>> 1;
            if (uid <= uids[m]) {
                max = m;
                continue;
            }
            min = m + 1;
        }
        if (min == uids.length - 1 && uids[min] < uid) {
            ++min;
        }
        return min;
    }

    final class Itr
    implements Iterator<T> {
        private Content snapshot;
        private T nextObj;
        private long nextUID = Long.MIN_VALUE;
        private int index = -1;

        Itr() {
        }

        @Override
        public boolean hasNext() {
            if (null != this.nextObj) {
                return true;
            }
            Content newSnapshot = RankedSequence.this.content;
            if (this.snapshot != newSnapshot) {
                this.index = null != newSnapshot ? RankedSequence.safeBinarySearch(newSnapshot.uids, this.nextUID) : -1;
                this.snapshot = newSnapshot;
            }
            if (this.index >= 0 && this.index < this.snapshot.objs.length) {
                this.nextObj = this.snapshot.objs[this.index];
                this.nextUID = this.snapshot.uids[this.index];
                return true;
            }
            return false;
        }

        public boolean hasNext(int rank) {
            if (null != this.nextObj) {
                return RankedSequence.uid2rank(this.nextUID) >= rank;
            }
            Content newSnapshot = RankedSequence.this.content;
            if (this.snapshot != newSnapshot) {
                this.index = null != newSnapshot ? RankedSequence.safeBinarySearch(newSnapshot.uids, this.nextUID) : -1;
                this.snapshot = newSnapshot;
            }
            if (this.index >= 0 && this.index < this.snapshot.uids.length) {
                return RankedSequence.uid2rank(this.snapshot.uids[this.index]) >= rank;
            }
            return false;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                ++this.nextUID;
                ++this.index;
                Object element = this.nextObj;
                this.nextObj = null;
                return element;
            }
            throw new NoSuchElementException();
        }

        public int rank() {
            return RankedSequence.uid2rank(this.nextUID);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static final class Content {
        final Object[] objs;
        final long[] uids;
        final int uniq;

        Content(Object element, int rank) {
            this.objs = new Object[]{element};
            this.uids = new long[]{RankedSequence.rank2uid(rank, 0)};
            this.uniq = 1;
        }

        Content(Object[] objs, long[] uids, int uniq) {
            this.objs = objs;
            this.uids = uids;
            this.uniq = uniq;
        }

        public int indexOf(Object element) {
            if (null == element) {
                return this.indexOfThis(null);
            }
            for (int i = 0; i < this.objs.length; ++i) {
                if (!element.equals(this.objs[i])) continue;
                return i;
            }
            return -1;
        }

        public int indexOfThis(Object element) {
            for (int i = 0; i < this.objs.length; ++i) {
                if (element != this.objs[i]) continue;
                return i;
            }
            return -1;
        }

        public Content insert(Object element, int rank) {
            int size = this.objs.length + 1;
            Object[] newObjs = new Object[size];
            long[] newUIDs = new long[size];
            long uid = RankedSequence.rank2uid(rank, this.uniq);
            int index = RankedSequence.safeBinarySearch(this.uids, uid);
            if (index > 0) {
                System.arraycopy(this.objs, 0, newObjs, 0, index);
                System.arraycopy(this.uids, 0, newUIDs, 0, index);
            }
            newObjs[index] = element;
            newUIDs[index] = uid;
            int destPos = index + 1;
            int len = size - destPos;
            if (len > 0) {
                System.arraycopy(this.objs, index, newObjs, destPos, len);
                System.arraycopy(this.uids, index, newUIDs, destPos, len);
            }
            return new Content(newObjs, newUIDs, this.uniq + 1);
        }

        public Content remove(int index) {
            if (this.objs.length == 1) {
                return null;
            }
            int size = this.objs.length - 1;
            Object[] newObjs = new Object[size];
            long[] newUIDs = new long[size];
            if (index > 0) {
                System.arraycopy(this.objs, 0, newObjs, 0, index);
                System.arraycopy(this.uids, 0, newUIDs, 0, index);
            }
            int srcPos = index + 1;
            int len = size - index;
            if (len > 0) {
                System.arraycopy(this.objs, srcPos, newObjs, index, len);
                System.arraycopy(this.uids, srcPos, newUIDs, index, len);
            }
            return new Content(newObjs, newUIDs, this.uniq);
        }
    }
}

