/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;
import lombok.Generated;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.PluginMessage;

public class ServerConnection
implements Server {
    private final ChannelWrapper ch;
    private final BungeeServerInfo info;
    private boolean isObsolete;
    private final boolean forgeServer = false;
    private final Queue<KeepAliveData> keepAlives = new ArrayDeque<KeepAliveData>();
    private final Queue<DefinedPacket> packetQueue = new ArrayDeque<DefinedPacket>();
    private final Connection.Unsafe unsafe = new Connection.Unsafe(){

        @Override
        public void sendPacket(DefinedPacket packet) {
            ServerConnection.this.ch.write(packet);
        }

        @Override
        public void sendPacketQueued(DefinedPacket packet) {
            if (ServerConnection.this.ch.getEncodeVersion() >= 764) {
                ServerConnection.this.sendPacketQueued(packet);
            } else {
                this.sendPacket(packet);
            }
        }
    };

    public void sendPacketQueued(DefinedPacket packet) {
        this.ch.scheduleIfNecessary(() -> {
            if (this.ch.isClosed()) {
                return;
            }
            Protocol encodeProtocol = this.ch.getEncodeProtocol();
            if (!encodeProtocol.TO_SERVER.hasPacket(packet.getClass(), this.ch.getEncodeVersion())) {
                Preconditions.checkState(this.packetQueue.size() <= 4096, "too many queued packets");
                this.packetQueue.add(packet);
            } else {
                this.unsafe().sendPacket(packet);
            }
        });
    }

    public void sendQueuedPackets() {
        this.ch.scheduleIfNecessary(() -> {
            DefinedPacket packet;
            if (this.ch.isClosed()) {
                return;
            }
            while ((packet = this.packetQueue.poll()) != null) {
                this.unsafe().sendPacket(packet);
            }
        });
    }

    @Override
    public void sendData(String channel, byte[] data) {
        this.sendPacketQueued(new PluginMessage(channel, data, false));
    }

    @Override
    public void disconnect(String reason) {
        this.disconnect(new BaseComponent[0]);
    }

    @Override
    public void disconnect(BaseComponent ... reason) {
        Preconditions.checkArgument(reason.length == 0, "Server cannot have disconnect reason");
        this.isObsolete = true;
        this.ch.close();
    }

    @Override
    public void disconnect(BaseComponent reason) {
        this.disconnect(new BaseComponent[0]);
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.getSocketAddress();
    }

    @Override
    public SocketAddress getSocketAddress() {
        return this.getInfo().getAddress();
    }

    @Override
    public boolean isConnected() {
        return !this.ch.isClosed();
    }

    @Override
    public Connection.Unsafe unsafe() {
        return this.unsafe;
    }

    @Generated
    public ServerConnection(ChannelWrapper ch, BungeeServerInfo info) {
        this.ch = ch;
        this.info = info;
    }

    @Generated
    public ChannelWrapper getCh() {
        return this.ch;
    }

    @Override
    @Generated
    public BungeeServerInfo getInfo() {
        return this.info;
    }

    @Generated
    public boolean isObsolete() {
        return this.isObsolete;
    }

    @Generated
    public void setObsolete(boolean isObsolete) {
        this.isObsolete = isObsolete;
    }

    @Generated
    public boolean isForgeServer() {
        return this.forgeServer;
    }

    @Generated
    public Queue<KeepAliveData> getKeepAlives() {
        return this.keepAlives;
    }

    public static class KeepAliveData {
        private final long id;
        private final long time;

        @Generated
        public KeepAliveData(long id, long time) {
            this.id = id;
            this.time = time;
        }

        @Generated
        public long getId() {
            return this.id;
        }

        @Generated
        public long getTime() {
            return this.time;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeepAliveData)) {
                return false;
            }
            KeepAliveData other = (KeepAliveData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            return this.getTime() == other.getTime();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof KeepAliveData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $id = this.getId();
            result = result * 59 + (int)($id >>> 32 ^ $id);
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            return result;
        }

        @Generated
        public String toString() {
            return "ServerConnection.KeepAliveData(id=" + this.getId() + ", time=" + this.getTime() + ")";
        }
    }
}

