/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.config;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.tablist.GlobalPingTabList;
import net.md_5.bungee.tablist.GlobalTabList;
import net.md_5.bungee.tablist.ServerUniqueTabList;

public class Configuration {
    private int timeout = 30000;
    private String uuid = UUID.randomUUID().toString();
    private Collection<ListenerInfo> listeners;
    private Map<String, ServerInfo> servers;
    private boolean onlineMode = true;
    private int sleepTime = 2;

    public void load() {
        ConfigurationAdapter adapter = ProxyServer.getInstance().getConfigurationAdapter();
        adapter.load();
        this.timeout = adapter.getInt("timeout", this.timeout);
        this.uuid = adapter.getString("stats", this.uuid);
        this.onlineMode = adapter.getBoolean("online_mode", this.onlineMode);
        this.sleepTime = adapter.getInt("sleep_time", this.sleepTime);
        DefaultTabList tab = DefaultTabList.valueOf(adapter.getString("tab_list", "GLOBAL_PING"));
        if (tab == null) {
            tab = DefaultTabList.GLOBAL_PING;
        }
        switch (tab) {
            case GLOBAL: {
                ProxyServer.getInstance().setTabListHandler(new GlobalTabList());
                break;
            }
            case GLOBAL_PING: {
                ProxyServer.getInstance().setTabListHandler(new GlobalPingTabList());
                break;
            }
            case SERVER: {
                ProxyServer.getInstance().setTabListHandler(new ServerUniqueTabList());
            }
        }
        this.listeners = adapter.getListeners();
        Preconditions.checkArgument(this.listeners != null && !this.listeners.isEmpty(), "No listeners defined.");
        this.servers = adapter.getServers();
        Preconditions.checkArgument(this.servers != null && !this.servers.isEmpty(), "No servers defined");
        for (ListenerInfo listener : this.listeners) {
            Preconditions.checkArgument(this.servers.containsKey(listener.getDefaultServer()));
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Collection<ListenerInfo> getListeners() {
        return this.listeners;
    }

    public Map<String, ServerInfo> getServers() {
        return this.servers;
    }

    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    private static enum DefaultTabList {
        GLOBAL,
        GLOBAL_PING,
        SERVER;

    }
}

