/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;

public class ConciseFormatter
extends Formatter {
    private final DateFormat date = new SimpleDateFormat(System.getProperty("net.md_5.bungee.log-date-format", "HH:mm:ss"));
    private final boolean coloured;

    @Override
    public String format(LogRecord record) {
        StringBuilder formatted = new StringBuilder();
        formatted.append(this.date.format(record.getMillis()));
        formatted.append(" [");
        this.appendLevel(formatted, record.getLevel());
        formatted.append("] ");
        formatted.append(this.formatMessage(record));
        formatted.append('\n');
        if (record.getThrown() != null) {
            StringWriter writer = new StringWriter();
            record.getThrown().printStackTrace(new PrintWriter(writer));
            formatted.append(writer);
        }
        return formatted.toString();
    }

    private void appendLevel(StringBuilder builder, Level level) {
        if (!this.coloured) {
            builder.append(level.getLocalizedName());
            return;
        }
        ChatColor color = level == Level.INFO ? ChatColor.BLUE : (level == Level.WARNING ? ChatColor.YELLOW : (level == Level.SEVERE ? ChatColor.RED : ChatColor.AQUA));
        builder.append(color).append(level.getLocalizedName()).append(ChatColor.RESET);
    }

    @Generated
    public ConciseFormatter(boolean coloured) {
        this.coloured = coloured;
    }
}

