/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.dialog;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.dialog.Dialog;
import net.md_5.bungee.api.dialog.DialogBase;
import net.md_5.bungee.api.dialog.action.DialogClickAction;

public final class MultiActionDialog
implements Dialog {
    @NonNull
    private DialogBase base;
    @NonNull
    private List<DialogClickAction> actions;
    private Integer columns;
    @SerializedName(value="on_cancel")
    private ClickEvent onCancel;

    public MultiActionDialog(@NonNull DialogBase base, DialogClickAction ... actions) {
        this(base, Arrays.asList(actions), 2, null);
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        if (actions == null) {
            throw new NullPointerException("actions is marked non-null but is null");
        }
    }

    public MultiActionDialog(@NonNull DialogBase base, @NonNull List<DialogClickAction> actions, Integer columns, ClickEvent onCancel) {
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        if (actions == null) {
            throw new NullPointerException("actions is marked non-null but is null");
        }
        Preconditions.checkArgument(!actions.isEmpty(), "At least one action must be provided");
        this.base = base;
        this.actions = actions;
        this.columns(columns);
        this.onCancel = onCancel;
    }

    public MultiActionDialog columns(Integer columns) {
        Preconditions.checkArgument(columns == null || columns > 0, "At least one column is required");
        this.columns = columns;
        return this;
    }

    @Override
    @NonNull
    @Generated
    public DialogBase getBase() {
        return this.base;
    }

    @NonNull
    @Generated
    public List<DialogClickAction> actions() {
        return this.actions;
    }

    @Generated
    public Integer columns() {
        return this.columns;
    }

    @Generated
    public ClickEvent onCancel() {
        return this.onCancel;
    }

    @Override
    @Generated
    public void setBase(@NonNull DialogBase base) {
        if (base == null) {
            throw new NullPointerException("base is marked non-null but is null");
        }
        this.base = base;
    }

    @Generated
    public MultiActionDialog actions(@NonNull List<DialogClickAction> actions) {
        if (actions == null) {
            throw new NullPointerException("actions is marked non-null but is null");
        }
        this.actions = actions;
        return this;
    }

    @Generated
    public MultiActionDialog onCancel(ClickEvent onCancel) {
        this.onCancel = onCancel;
        return this;
    }

    @Generated
    public String toString() {
        return "MultiActionDialog(base=" + this.getBase() + ", actions=" + this.actions() + ", columns=" + this.columns() + ", onCancel=" + this.onCancel() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiActionDialog)) {
            return false;
        }
        MultiActionDialog other = (MultiActionDialog)o;
        Integer this$columns = this.columns();
        Integer other$columns = other.columns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        DialogBase this$base = this.getBase();
        DialogBase other$base = other.getBase();
        if (this$base == null ? other$base != null : !((Object)this$base).equals(other$base)) {
            return false;
        }
        List<DialogClickAction> this$actions = this.actions();
        List<DialogClickAction> other$actions = other.actions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        ClickEvent this$onCancel = this.onCancel();
        ClickEvent other$onCancel = other.onCancel();
        return !(this$onCancel == null ? other$onCancel != null : !((Object)this$onCancel).equals(other$onCancel));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $columns = this.columns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        DialogBase $base = this.getBase();
        result = result * 59 + ($base == null ? 43 : ((Object)$base).hashCode());
        List<DialogClickAction> $actions = this.actions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        ClickEvent $onCancel = this.onCancel();
        result = result * 59 + ($onCancel == null ? 43 : ((Object)$onCancel).hashCode());
        return result;
    }
}

