/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Locale;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Either;
import net.md_5.bungee.protocol.NumberFormat;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ScoreboardObjective
extends DefinedPacket {
    private String name;
    private Either<String, BaseComponent> value;
    private HealthDisplay type;
    private byte action;
    private NumberFormat numberFormat;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.name = ScoreboardObjective.readString(buf);
        this.action = buf.readByte();
        if (this.action == 0 || this.action == 2) {
            if (protocolVersion >= 393) {
                this.value = ScoreboardObjective.readEitherBaseComponent(buf, protocolVersion, false);
                this.type = HealthDisplay.values()[ScoreboardObjective.readVarInt(buf)];
            } else {
                this.value = ScoreboardObjective.readEitherBaseComponent(buf, protocolVersion, true);
                this.type = HealthDisplay.fromString(ScoreboardObjective.readString(buf));
            }
            if (protocolVersion >= 765) {
                this.numberFormat = (NumberFormat)this.readNullable(b -> ScoreboardObjective.readNumberFormat(b, protocolVersion), buf);
            }
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        ScoreboardObjective.writeString(this.name, buf);
        buf.writeByte(this.action);
        if (this.action == 0 || this.action == 2) {
            ScoreboardObjective.writeEitherBaseComponent(this.value, buf, protocolVersion);
            if (protocolVersion >= 393) {
                ScoreboardObjective.writeVarInt(this.type.ordinal(), buf);
            } else {
                ScoreboardObjective.writeString(this.type.toString(), buf);
            }
            if (protocolVersion >= 765) {
                this.writeNullable(this.numberFormat, (s2, b) -> DefinedPacket.writeNumberFormat(s2, b, protocolVersion), buf);
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Either<String, BaseComponent> getValue() {
        return this.value;
    }

    @Generated
    public HealthDisplay getType() {
        return this.type;
    }

    @Generated
    public byte getAction() {
        return this.action;
    }

    @Generated
    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setValue(Either<String, BaseComponent> value) {
        this.value = value;
    }

    @Generated
    public void setType(HealthDisplay type) {
        this.type = type;
    }

    @Generated
    public void setAction(byte action) {
        this.action = action;
    }

    @Generated
    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    @Override
    @Generated
    public String toString() {
        return "ScoreboardObjective(name=" + this.getName() + ", value=" + this.getValue() + ", type=" + (Object)((Object)this.getType()) + ", action=" + this.getAction() + ", numberFormat=" + this.getNumberFormat() + ")";
    }

    @Generated
    public ScoreboardObjective() {
    }

    @Generated
    public ScoreboardObjective(String name, Either<String, BaseComponent> value, HealthDisplay type, byte action, NumberFormat numberFormat) {
        this.name = name;
        this.value = value;
        this.type = type;
        this.action = action;
        this.numberFormat = numberFormat;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScoreboardObjective)) {
            return false;
        }
        ScoreboardObjective other = (ScoreboardObjective)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAction() != other.getAction()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Either<String, BaseComponent> this$value = this.getValue();
        Either<String, BaseComponent> other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        HealthDisplay this$type = this.getType();
        HealthDisplay other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        NumberFormat this$numberFormat = this.getNumberFormat();
        NumberFormat other$numberFormat = other.getNumberFormat();
        return !(this$numberFormat == null ? other$numberFormat != null : !((Object)this$numberFormat).equals(other$numberFormat));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScoreboardObjective;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAction();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Either<String, BaseComponent> $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        HealthDisplay $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        NumberFormat $numberFormat = this.getNumberFormat();
        result = result * 59 + ($numberFormat == null ? 43 : ((Object)$numberFormat).hashCode());
        return result;
    }

    public static enum HealthDisplay {
        INTEGER,
        HEARTS;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static HealthDisplay fromString(String s2) {
            return HealthDisplay.valueOf(s2.toUpperCase(Locale.ROOT));
        }
    }
}

