/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.WriteTimeoutException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.logging.Level;
import lombok.Generated;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.PingHandler;
import net.md_5.bungee.connection.UpstreamBridge;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.OverflowPacketException;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.util.PacketLimiter;
import net.md_5.bungee.util.QuietException;

public class HandlerBoss
extends ChannelInboundHandlerAdapter {
    private PacketLimiter limiter;
    private ChannelWrapper channel;
    private PacketHandler handler;
    private boolean healthCheck;

    public void setHandler(PacketHandler handler) {
        Preconditions.checkArgument(handler != null, "handler");
        this.handler = handler;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.handler != null) {
            this.channel = new ChannelWrapper(ctx);
            this.handler.connected(this.channel);
            if (!(this.handler instanceof InitialHandler) && !(this.handler instanceof PingHandler)) {
                ProxyServer.getInstance().getLogger().log(Level.INFO, "{0} has connected", this.handler);
            }
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.handler != null) {
            this.channel.markClosed();
            this.handler.disconnected(this.channel);
            if (!(this.handler instanceof InitialHandler) && !(this.handler instanceof PingHandler)) {
                ProxyServer.getInstance().getLogger().log(Level.INFO, "{0} has disconnected", this.handler);
            }
        }
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (this.handler != null) {
            this.handler.writabilityChanged(this.channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        block17: {
            if (msg instanceof HAProxyMessage) {
                HAProxyMessage proxy = (HAProxyMessage)msg;
                try {
                    if (proxy.sourceAddress() != null) {
                        InetSocketAddress newAddress = new InetSocketAddress(proxy.sourceAddress(), proxy.sourcePort());
                        ProxyServer.getInstance().getLogger().log(Level.FINE, "Set remote address via PROXY {0} -> {1}", new Object[]{this.channel.getRemoteAddress(), newAddress});
                        this.channel.setRemoteAddress(newAddress);
                    } else {
                        this.healthCheck = true;
                    }
                }
                finally {
                    proxy.release();
                }
                return;
            }
            PacketWrapper packet = (PacketWrapper)msg;
            try {
                Protocol nextProtocol;
                if (this.limiter != null && !this.limiter.incrementAndCheck(packet.buf.readableBytes())) {
                    this.channel.close(this.handler instanceof UpstreamBridge ? new Kick(TextComponent.fromLegacy(ProxyServer.getInstance().getTranslation("packet_limit_kick", this.limiter.getCounter(), this.limiter.getDataCounter()))) : null);
                    ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} exceeded packet limit ({1} packets and {2} bytes per second)", new Object[]{this.handler, this.limiter.getCounter(), this.limiter.getDataCounter()});
                    return;
                }
                if (packet.packet != null && (nextProtocol = packet.packet.nextProtocol()) != null) {
                    this.channel.setDecodeProtocol(nextProtocol);
                }
                if (this.handler == null) break block17;
                boolean sendPacket = this.handler.shouldHandle(packet);
                if (sendPacket && packet.packet != null) {
                    try {
                        packet.packet.handle(this.handler);
                    }
                    catch (CancelSendSignal ex) {
                        sendPacket = false;
                    }
                }
                if (sendPacket) {
                    this.handler.handle(packet);
                }
            }
            finally {
                packet.trySingleRelease();
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx.channel().isActive()) {
            boolean logExceptions;
            boolean bl = logExceptions = !(this.handler instanceof PingHandler) && !this.healthCheck;
            if (logExceptions) {
                if (cause instanceof ReadTimeoutException) {
                    ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} - read timed out", this.handler);
                } else if (cause instanceof WriteTimeoutException) {
                    ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} - write timed out", this.handler);
                } else if (cause instanceof DecoderException) {
                    if (cause instanceof CorruptedFrameException) {
                        ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} - corrupted frame: {1}", new Object[]{this.handler, cause.getMessage()});
                    } else if (cause.getCause() instanceof BadPacketException) {
                        ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} - bad packet, are mods in use!? {1}", new Object[]{this.handler, cause.getCause().getMessage()});
                    } else if (cause.getCause() instanceof OverflowPacketException) {
                        ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} - overflow in packet detected! {1}", new Object[]{this.handler, cause.getCause().getMessage()});
                    } else {
                        ProxyServer.getInstance().getLogger().log(Level.WARNING, this.handler + " - could not decode packet!", cause);
                    }
                } else if (cause instanceof IOException || cause instanceof IllegalStateException && this.handler instanceof InitialHandler) {
                    ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} - {1}: {2}", new Object[]{this.handler, cause.getClass().getSimpleName(), cause.getMessage()});
                } else if (cause instanceof QuietException) {
                    ProxyServer.getInstance().getLogger().log(Level.SEVERE, "{0} - encountered exception: {1}", new Object[]{this.handler, cause});
                } else {
                    ProxyServer.getInstance().getLogger().log(Level.SEVERE, this.handler + " - encountered exception", cause);
                }
            }
            if (this.handler != null) {
                try {
                    this.handler.exception(cause);
                }
                catch (Exception ex) {
                    ProxyServer.getInstance().getLogger().log(Level.SEVERE, this.handler + " - exception processing exception", ex);
                }
            }
            ctx.close();
        }
    }

    @Generated
    public void setLimiter(PacketLimiter limiter) {
        this.limiter = limiter;
    }
}

