/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.nbt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import se.llbit.nbt.ErrorTag;
import se.llbit.nbt.SpecificTag;

public class ByteTag
extends SpecificTag {
    public final int value;

    public static SpecificTag read(DataInputStream in) {
        try {
            return new ByteTag(in.readByte());
        }
        catch (IOException e) {
            return new ErrorTag("IOException while reading TAG_Byte:\n" + e.getMessage());
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeByte(this.getData());
    }

    public ByteTag(int value) {
        this.value = value;
    }

    public int getData() {
        return this.value;
    }

    @Override
    public String extraInfo() {
        return ": " + this.getData();
    }

    public String type() {
        return "TAG_Byte";
    }

    @Override
    public String tagName() {
        return "TAG_Byte";
    }

    @Override
    public int tagType() {
        return 1;
    }

    @Override
    public boolean boolValue() {
        return this.getData() != 0;
    }

    @Override
    public boolean boolValue(boolean defaultValue) {
        return this.getData() != 0;
    }

    @Override
    public int byteValue() {
        return this.getData();
    }

    @Override
    public int byteValue(int defaultValue) {
        return this.getData();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ByteTag && ((ByteTag)obj).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }
}

