/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.event;

import lombok.Generated;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.event.TargetedEvent;
import net.md_5.bungee.api.plugin.Cancellable;

public class ChatEvent
extends TargetedEvent
implements Cancellable {
    private boolean cancelled;
    private String message;

    public ChatEvent(Connection sender, Connection receiver, String message) {
        super(sender, receiver);
        this.message = message;
    }

    public boolean isCommand() {
        return this.message.length() > 0 && this.message.charAt(0) == '/';
    }

    public boolean isProxyCommand() {
        if (!this.isCommand()) {
            return false;
        }
        int index = this.message.indexOf(" ");
        String commandName = index == -1 ? this.message.substring(1) : this.message.substring(1, index);
        CommandSender sender = this.getSender() instanceof CommandSender ? (CommandSender)((Object)this.getSender()) : null;
        return ProxyServer.getInstance().getPluginManager().isExecutableCommand(commandName, sender);
    }

    @Override
    @Generated
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Override
    @Generated
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    @Generated
    public String toString() {
        return "ChatEvent(super=" + super.toString() + ", cancelled=" + this.isCancelled() + ", message=" + this.getMessage() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatEvent)) {
            return false;
        }
        ChatEvent other = (ChatEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isCancelled() != other.isCancelled()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChatEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isCancelled() ? 79 : 97);
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }
}

