/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.unix.Buffer;
import io.netty.channel.uring.CmsgHdr;
import io.netty.channel.uring.Native;
import java.nio.ByteBuffer;

final class MsgHdr {
    private MsgHdr() {
    }

    static void set(ByteBuffer memory, ByteBuffer sockAddrMemory, int addressSize, ByteBuffer iovMemory, int iovLength, ByteBuffer msgControl, int cmsgHdrDataOffset, short segmentSize) {
        long msgControlAddr;
        int memoryPosition = memory.position();
        memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_NAMELEN, addressSize);
        int msgControlLen = 0;
        if (segmentSize > 0) {
            msgControlLen = Native.CMSG_LEN;
            CmsgHdr.write(msgControl, cmsgHdrDataOffset, Native.CMSG_LEN, Native.SOL_UDP, Native.UDP_SEGMENT, segmentSize);
            msgControlAddr = Buffer.memoryAddress(msgControl) + (long)msgControl.position();
        } else {
            msgControlAddr = 0L;
        }
        if (Native.SIZEOF_SIZE_T == 4) {
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_NAME, (int)Buffer.memoryAddress(sockAddrMemory));
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOV, (int)Buffer.memoryAddress(iovMemory));
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOVLEN, iovLength);
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROL, (int)msgControlAddr);
            memory.putInt(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROLLEN, msgControlLen);
        } else {
            assert (Native.SIZEOF_SIZE_T == 8);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_NAME, Buffer.memoryAddress(sockAddrMemory));
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOV, Buffer.memoryAddress(iovMemory));
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_IOVLEN, iovLength);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROL, msgControlAddr);
            memory.putLong(memoryPosition + Native.MSGHDR_OFFSETOF_MSG_CONTROLLEN, msgControlLen);
        }
    }
}

