/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.jni;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import net.md_5.bungee.jni.NativeCodeException;
import net.md_5.bungee.jni.cipher.BungeeCipher;

public final class NativeCode<T> {
    private final String name;
    private final Supplier<? extends T> javaImpl;
    private final Supplier<? extends T> nativeImpl;
    private final boolean enableNativeFlag;
    private final boolean extendedSupportCheck;
    private boolean loaded;

    public NativeCode(String name, Supplier<? extends T> javaImpl, Supplier<? extends T> nativeImpl) {
        this(name, javaImpl, nativeImpl, false);
    }

    public NativeCode(String name, Supplier<? extends T> javaImpl, Supplier<? extends T> nativeImpl, boolean extendedSupportCheck) {
        this.name = name;
        this.javaImpl = javaImpl;
        this.nativeImpl = nativeImpl;
        this.enableNativeFlag = Boolean.parseBoolean(System.getProperty("net.md_5.bungee.jni." + name + ".enable", "true"));
        this.extendedSupportCheck = extendedSupportCheck;
    }

    public T newInstance() {
        return this.loaded ? this.nativeImpl.get() : this.javaImpl.get();
    }

    public boolean load() {
        if (this.enableNativeFlag && !this.loaded && NativeCode.isSupported()) {
            String name = this.name + (NativeCode.isAarch64() ? "-arm" : "");
            String fullName = "bungeecord-" + name;
            try {
                System.loadLibrary(fullName);
                this.loaded = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!this.loaded) {
                try (InputStream soFile2 = BungeeCipher.class.getClassLoader().getResourceAsStream(name + ".so");){
                    File temp = File.createTempFile(fullName, ".so");
                    temp.deleteOnExit();
                    try (FileOutputStream outputStream = new FileOutputStream(temp);){
                        ByteStreams.copy(soFile2, outputStream);
                    }
                    System.load(temp.getPath());
                    if (this.extendedSupportCheck) {
                        this.nativeImpl.get();
                    }
                    this.loaded = true;
                }
                catch (IOException soFile2) {
                }
                catch (UnsatisfiedLinkError ex) {
                    System.out.println("Could not load native library: " + ex.getMessage());
                }
                catch (NativeCodeException ex) {
                    System.out.println("Native library " + name + " is incompatible: " + ex.getMessage());
                }
            }
        }
        return this.loaded;
    }

    public static boolean isSupported() {
        return "Linux".equals(System.getProperty("os.name")) && (NativeCode.isAmd64() || NativeCode.isAarch64());
    }

    private static boolean isAmd64() {
        return "amd64".equals(System.getProperty("os.arch"));
    }

    private static boolean isAarch64() {
        return "aarch64".equals(System.getProperty("os.arch"));
    }
}

