/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import lombok.Generated;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.score.Objective;
import net.md_5.bungee.api.score.Score;
import net.md_5.bungee.api.score.Scoreboard;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.connection.DownstreamBridge;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.forge.ForgeServerHandler;
import net.md_5.bungee.forge.ForgeUtils;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Either;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.BossBar;
import net.md_5.bungee.protocol.packet.CookieRequest;
import net.md_5.bungee.protocol.packet.CookieResponse;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.EntityStatus;
import net.md_5.bungee.protocol.packet.GameState;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.LoginPayloadRequest;
import net.md_5.bungee.protocol.packet.LoginPayloadResponse;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.Respawn;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import net.md_5.bungee.protocol.packet.ScoreboardScoreReset;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.protocol.packet.StartConfiguration;
import net.md_5.bungee.protocol.packet.Team;
import net.md_5.bungee.protocol.packet.ViewDistance;
import net.md_5.bungee.util.AddressUtil;
import net.md_5.bungee.util.BufUtil;
import net.md_5.bungee.util.QuietException;

public class ServerConnector
extends PacketHandler {
    private final ProxyServer bungee;
    private ChannelWrapper ch;
    private final UserConnection user;
    private final BungeeServerInfo target;
    private State thisState = State.LOGIN_SUCCESS;
    private ForgeServerHandler handshakeHandler;
    private boolean obsolete;

    @Override
    public void exception(Throwable t2) throws Exception {
        if (this.obsolete) {
            return;
        }
        String message = ChatColor.RED + "Exception Connecting: " + Util.exception(t2);
        if (this.user.getServer() == null) {
            this.user.disconnect(message);
        } else {
            this.user.sendMessage(message);
        }
    }

    @Override
    public void connected(ChannelWrapper channel) throws Exception {
        channel.setVersion(this.user.getPendingConnection().getVersion());
        this.ch = channel;
        this.handshakeHandler = new ForgeServerHandler(this.user, this.ch, this.target);
        Handshake originalHandshake = this.user.getPendingConnection().getHandshake();
        Handshake copiedHandshake = new Handshake(originalHandshake.getProtocolVersion(), originalHandshake.getHost(), originalHandshake.getPort(), 2);
        if (BungeeCord.getInstance().config.isIpForward() && this.user.getSocketAddress() instanceof InetSocketAddress) {
            String newHost = copiedHandshake.getHost() + "\u0000" + AddressUtil.sanitizeAddress(this.user.getAddress()) + "\u0000" + this.user.getUUID();
            LoginResult profile = this.user.getPendingConnection().getLoginProfile();
            if (profile != null && profile.getProperties() != null && profile.getProperties().length > 0) {
                newHost = newHost + "\u0000" + LoginResult.GSON.toJson(profile.getProperties());
            }
            copiedHandshake.setHost(newHost);
        } else if (!this.user.getExtraDataInHandshake().isEmpty()) {
            copiedHandshake.setHost(copiedHandshake.getHost() + this.user.getExtraDataInHandshake());
        }
        channel.write(copiedHandshake);
        channel.setProtocol(Protocol.LOGIN);
        channel.write(new LoginRequest(this.user.getName(), null, this.user.getRewriteId()));
    }

    @Override
    public void disconnected(ChannelWrapper channel) throws Exception {
        this.user.getPendingConnects().remove(this.target);
        if (this.user.getServer() == null && !this.obsolete && this.user.getPendingConnects().isEmpty() && this.thisState == State.LOGIN_SUCCESS) {
            this.user.disconnect("Unexpected disconnect during server login, did you forget to enable BungeeCord / IP forwarding on your server?");
        }
    }

    @Override
    public void handle(PacketWrapper packet) throws Exception {
        if (packet.packet == null) {
            throw new QuietException("Unexpected packet received during server login process!\n" + BufUtil.dump(packet.buf, 16));
        }
    }

    @Override
    public void handle(LoginSuccess loginSuccess) throws Exception {
        Preconditions.checkState(this.thisState == State.LOGIN_SUCCESS, "Not expecting LOGIN_SUCCESS");
        if (this.user.getPendingConnection().getVersion() >= 764) {
            ServerConnection server = new ServerConnection(this.ch, this.target);
            this.cutThrough(server);
        } else {
            this.ch.setProtocol(Protocol.GAME);
            this.thisState = State.LOGIN;
        }
        if (this.user.getServer() != null && this.user.getForgeClientHandler().isHandshakeComplete() && this.user.getServer().isForgeServer()) {
            this.user.getForgeClientHandler().resetHandshake();
        }
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public void handle(SetCompression setCompression) throws Exception {
        this.ch.setCompressionThreshold(setCompression.getThreshold());
    }

    @Override
    public void handle(CookieRequest cookieRequest) throws Exception {
        this.user.retrieveCookie(cookieRequest.getCookie()).thenAccept(cookie -> this.ch.write(new CookieResponse(cookieRequest.getCookie(), (byte[])cookie)));
    }

    @Override
    public void handle(Login login) throws Exception {
        Preconditions.checkState(this.thisState == State.LOGIN, "Not expecting LOGIN");
        ServerConnection server = new ServerConnection(this.ch, this.target);
        ServerConnector.handleLogin(this.bungee, this.ch, this.user, this.target, this.handshakeHandler, server, login);
        this.cutThrough(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleLogin(ProxyServer bungee, ChannelWrapper ch, UserConnection user, BungeeServerInfo target, ForgeServerHandler handshakeHandler, ServerConnection server, Login login) throws Exception {
        Set<String> registeredChannels;
        Queue<DefinedPacket> packetQueue;
        ServerConnectedEvent event = new ServerConnectedEvent(user, server);
        bungee.getPluginManager().callEvent(event);
        ch.write(BungeeCord.getInstance().registerChannels(user.getPendingConnection().getVersion()));
        Queue<DefinedPacket> queue = packetQueue = target.getPacketQueue();
        synchronized (queue) {
            while (!packetQueue.isEmpty()) {
                ch.write(packetQueue.poll());
            }
        }
        PluginMessage brandMessage = user.getPendingConnection().getBrandMessage();
        if (brandMessage != null) {
            ch.write(brandMessage);
        }
        if (!(registeredChannels = user.getPendingConnection().getRegisteredChannels()).isEmpty()) {
            ch.write(new PluginMessage(user.getPendingConnection().getVersion() >= 393 ? "minecraft:register" : "REGISTER", Joiner.on("\u0000").join(registeredChannels).getBytes(StandardCharsets.UTF_8), false));
        }
        if (user.getSettings() != null) {
            ch.write(user.getSettings());
        }
        if (user.getForgeClientHandler().getClientModList() == null && !user.getForgeClientHandler().isHandshakeComplete()) {
            user.getForgeClientHandler().setHandshakeComplete();
        }
        if (user.getServer() == null || user.getPendingConnection().getVersion() >= 735) {
            user.setClientEntityId(login.getEntityId());
            user.setServerEntityId(login.getEntityId());
            Login modLogin = new Login(login.getEntityId(), login.isHardcore(), login.getGameMode(), login.getPreviousGameMode(), login.getWorldNames(), login.getDimensions(), login.getDimension(), login.getWorldName(), login.getSeed(), login.getDifficulty(), (byte)user.getPendingConnection().getListener().getTabListSize(), login.getLevelType(), login.getViewDistance(), login.getSimulationDistance(), login.isReducedDebugInfo(), login.isNormalRespawn(), login.isLimitedCrafting(), login.isDebug(), login.isFlat(), login.getDeathLocation(), login.getPortalCooldown(), login.getSeaLevel(), login.isSecureProfile());
            user.unsafe().sendPacket(modLogin);
            if (user.getDimension() != null) {
                user.getTabListHandler().onServerChange();
                user.getServerSentScoreboard().clear();
                for (UUID bossbar : user.getSentBossBars()) {
                    user.unsafe().sendPacket(new BossBar(bossbar, 1));
                }
                user.getSentBossBars().clear();
                user.unsafe().sendPacket(new Respawn(login.getDimension(), login.getWorldName(), login.getSeed(), login.getDifficulty(), login.getGameMode(), login.getPreviousGameMode(), login.getLevelType(), login.isDebug(), login.isFlat(), 0, login.getDeathLocation(), login.getPortalCooldown(), login.getSeaLevel()));
            } else {
                user.unsafe().sendPacket(BungeeCord.getInstance().registerChannels(user.getPendingConnection().getVersion()));
                ByteBuf brand = ByteBufAllocator.DEFAULT.heapBuffer();
                DefinedPacket.writeString(bungee.getName() + " (" + bungee.getVersion() + ")", brand);
                user.unsafe().sendPacket(new PluginMessage(user.getPendingConnection().getVersion() >= 393 ? "minecraft:brand" : "MC|Brand", DefinedPacket.toArray(brand), handshakeHandler != null && handshakeHandler.isServerForge()));
                brand.release();
            }
            user.setDimension(login.getDimension());
        } else {
            user.getServer().setObsolete(true);
            user.getTabListHandler().onServerChange();
            Scoreboard serverScoreboard = user.getServerSentScoreboard();
            for (Objective objective : serverScoreboard.getObjectives()) {
                user.unsafe().sendPacket(new ScoreboardObjective(objective.getName(), user.getPendingConnection().getVersion() >= 393 ? Either.right(user.getChatSerializer().deserialize(objective.getValue())) : Either.left(objective.getValue()), ScoreboardObjective.HealthDisplay.fromString(objective.getType()), 1, null));
            }
            for (Score score : serverScoreboard.getScores()) {
                if (user.getPendingConnection().getVersion() >= 765) {
                    user.unsafe().sendPacket(new ScoreboardScoreReset(score.getItemName(), null));
                    continue;
                }
                user.unsafe().sendPacket(new ScoreboardScore(score.getItemName(), 1, score.getScoreName(), score.getValue(), null, null));
            }
            for (net.md_5.bungee.api.score.Team team : serverScoreboard.getTeams()) {
                user.unsafe().sendPacket(new Team(team.getName()));
            }
            serverScoreboard.clear();
            for (UUID bossbar : user.getSentBossBars()) {
                user.unsafe().sendPacket(new BossBar(bossbar, 1));
            }
            user.getSentBossBars().clear();
            user.unsafe().sendPacket(new EntityStatus(user.getClientEntityId(), login.isReducedDebugInfo() ? (byte)22 : 23));
            if (user.getPendingConnection().getVersion() >= 573) {
                user.unsafe().sendPacket(new GameState(11, login.isNormalRespawn() ? 0.0f : 1.0f));
            }
            user.setDimensionChange(true);
            if (login.getDimension() == user.getDimension()) {
                user.unsafe().sendPacket(new Respawn((Integer)login.getDimension() >= 0 ? -1 : 0, login.getWorldName(), login.getSeed(), login.getDifficulty(), login.getGameMode(), login.getPreviousGameMode(), login.getLevelType(), login.isDebug(), login.isFlat(), 0, login.getDeathLocation(), login.getPortalCooldown(), login.getSeaLevel()));
            }
            user.setServerEntityId(login.getEntityId());
            user.unsafe().sendPacket(new Respawn(login.getDimension(), login.getWorldName(), login.getSeed(), login.getDifficulty(), login.getGameMode(), login.getPreviousGameMode(), login.getLevelType(), login.isDebug(), login.isFlat(), 0, login.getDeathLocation(), login.getPortalCooldown(), login.getSeaLevel()));
            if (user.getPendingConnection().getVersion() >= 477) {
                user.unsafe().sendPacket(new ViewDistance(login.getViewDistance()));
            }
            user.setDimension(login.getDimension());
        }
    }

    private void cutThrough(ServerConnection server) {
        if (!this.user.isActive()) {
            server.disconnect("Quitting");
            this.bungee.getLogger().log(Level.WARNING, "[{0}] No client connected for pending server!", this.user);
            return;
        }
        if (this.user.getPendingConnection().getVersion() >= 764) {
            if (this.user.getServer() != null) {
                if (this.user.getCh().getEncodeProtocol() != Protocol.CONFIGURATION) {
                    this.user.unsafe().sendPacket(new StartConfiguration());
                }
            } else {
                LoginResult loginProfile = this.user.getPendingConnection().getLoginProfile();
                this.user.unsafe().sendPacket(new LoginSuccess(this.user.getRewriteId(), this.user.getName(), loginProfile == null ? null : loginProfile.getProperties()));
                this.user.getCh().setEncodeProtocol(Protocol.CONFIGURATION);
            }
        }
        if (this.user.getServer() != null) {
            this.user.getServer().disconnect("Quitting");
        }
        this.target.addPlayer(this.user);
        this.user.getPendingConnects().remove(this.target);
        this.user.setServerJoinQueue(null);
        this.user.setDimensionChange(false);
        BungeeServerInfo from = this.user.getServer() == null ? null : this.user.getServer().getInfo();
        this.user.setServer(server);
        this.ch.getHandle().pipeline().get(HandlerBoss.class).setHandler(new DownstreamBridge(this.bungee, this.user, server));
        this.bungee.getPluginManager().callEvent(new ServerSwitchEvent(this.user, from));
        this.thisState = State.FINISHED;
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public void handle(EncryptionRequest encryptionRequest) throws Exception {
        throw new QuietException("Server is online mode!");
    }

    @Override
    public void handle(Kick kick) throws Exception {
        ServerInfo def = this.user.updateAndGetNextServer(this.target);
        ServerKickEvent event = new ServerKickEvent((ProxiedPlayer)this.user, (ServerInfo)this.target, new BaseComponent[]{kick.getMessage()}, def, ServerKickEvent.State.CONNECTING);
        if (event.getKickReason().toLowerCase(Locale.ROOT).contains("outdated") && def != null) {
            event.setCancelled(true);
        }
        this.bungee.getPluginManager().callEvent(event);
        if (event.isCancelled() && event.getCancelServer() != null) {
            this.obsolete = true;
            this.user.connect(event.getCancelServer(), ServerConnectEvent.Reason.KICK_REDIRECT);
            throw CancelSendSignal.INSTANCE;
        }
        String message = this.bungee.getTranslation("connect_kick", this.target.getName(), event.getKickReason());
        if (this.user.isDimensionChange()) {
            this.user.disconnect(message);
        } else {
            this.user.sendMessage(message);
        }
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public void handle(PluginMessage pluginMessage) throws Exception {
        if (BungeeCord.getInstance().config.isForgeSupport()) {
            if (pluginMessage.getTag().equals("REGISTER")) {
                Set<String> channels = ForgeUtils.readRegisteredChannels(pluginMessage);
                boolean isForgeServer = false;
                for (String channel : channels) {
                    if (!channel.equals("FML|HS")) continue;
                    if (this.user.getServer() != null && this.user.getForgeClientHandler().isHandshakeComplete()) {
                        this.user.getForgeClientHandler().resetHandshake();
                    }
                    isForgeServer = true;
                    break;
                }
                if (isForgeServer && !this.handshakeHandler.isServerForge()) {
                    this.handshakeHandler.setServerAsForgeServer();
                    this.user.setForgeServerHandler(this.handshakeHandler);
                }
            }
            if (pluginMessage.getTag().equals("FML|HS") || pluginMessage.getTag().equals("FORGE")) {
                this.handshakeHandler.handle(pluginMessage);
                throw CancelSendSignal.INSTANCE;
            }
        }
        this.user.unsafe().sendPacket(pluginMessage);
    }

    @Override
    public void handle(LoginPayloadRequest loginPayloadRequest) {
        this.ch.write(new LoginPayloadResponse(loginPayloadRequest.getId(), null));
    }

    @Override
    public String toString() {
        return "[" + this.user.getName() + "] <-> ServerConnector [" + this.target.getName() + "]";
    }

    @Generated
    public ServerConnector(ProxyServer bungee, UserConnection user, BungeeServerInfo target) {
        this.bungee = bungee;
        this.user = user;
        this.target = target;
    }

    @Generated
    public ForgeServerHandler getHandshakeHandler() {
        return this.handshakeHandler;
    }

    private static enum State {
        LOGIN_SUCCESS,
        LOGIN,
        FINISHED;

    }
}

