/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.jni.zlib;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.zip.DataFormatException;
import lombok.Generated;
import net.md_5.bungee.jni.NativeCodeException;
import net.md_5.bungee.jni.zlib.BungeeZlib;
import net.md_5.bungee.jni.zlib.NativeCompressImpl;

public class NativeZlib
implements BungeeZlib {
    private final NativeCompressImpl nativeCompress = new NativeCompressImpl();
    private boolean compress;
    private long ctx;

    public NativeZlib() {
        if (!this.nativeCompress.checkSupported()) {
            throw new NativeCodeException("This CPU does not support the required SSE 4.2 and/or PCLMUL extensions!");
        }
    }

    @Override
    public void init(boolean compress, int level) {
        this.free();
        this.compress = compress;
        this.ctx = this.nativeCompress.init(compress, level);
    }

    @Override
    public void free() {
        if (this.ctx != 0L) {
            this.nativeCompress.end(this.ctx, this.compress);
            this.ctx = 0L;
        }
        this.nativeCompress.consumed = 0;
        this.nativeCompress.finished = false;
    }

    @Override
    public void process(ByteBuf in, ByteBuf out) throws DataFormatException {
        Preconditions.checkState(this.ctx != 0L, "Invalid pointer to compress!");
        while (!this.nativeCompress.finished && (this.compress || in.isReadable())) {
            int processed;
            if (this.compress) {
                out.ensureWritable(8192);
            } else {
                Preconditions.checkArgument(out.isWritable(), "Output buffer overrun");
            }
            try {
                processed = this.nativeCompress.process(this.ctx, in.memoryAddress() + (long)in.readerIndex(), in.readableBytes(), out.memoryAddress() + (long)out.writerIndex(), out.writableBytes(), this.compress);
            }
            catch (NativeCodeException exception) {
                throw (DataFormatException)new DataFormatException("Failed to decompress via Zlib!").initCause(exception);
            }
            in.readerIndex(in.readerIndex() + this.nativeCompress.consumed);
            out.writerIndex(out.writerIndex() + processed);
        }
        this.nativeCompress.reset(this.ctx, this.compress);
        this.nativeCompress.consumed = 0;
        this.nativeCompress.finished = false;
    }

    @Override
    public boolean allowComposite() {
        return false;
    }

    @Generated
    public NativeCompressImpl getNativeCompress() {
        return this.nativeCompress;
    }
}

