/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import lombok.Generated;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.OverflowPacketException;

public class LoginPayloadRequest
extends DefinedPacket {
    private int id;
    private String channel;
    private byte[] data;

    @Override
    public void read(ByteBuf buf) {
        this.id = LoginPayloadRequest.readVarInt(buf);
        this.channel = LoginPayloadRequest.readString(buf);
        int len = buf.readableBytes();
        if (len > 0x100000) {
            throw new OverflowPacketException("Payload may not be larger than 1048576 bytes");
        }
        this.data = new byte[len];
        buf.readBytes(this.data);
    }

    @Override
    public void write(ByteBuf buf) {
        LoginPayloadRequest.writeVarInt(this.id, buf);
        LoginPayloadRequest.writeString(this.channel, buf);
        buf.writeBytes(this.data);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getChannel() {
        return this.channel;
    }

    @Generated
    public byte[] getData() {
        return this.data;
    }

    @Generated
    public void setId(int id) {
        this.id = id;
    }

    @Generated
    public void setChannel(String channel) {
        this.channel = channel;
    }

    @Generated
    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    @Generated
    public String toString() {
        return "LoginPayloadRequest(id=" + this.getId() + ", channel=" + this.getChannel() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    @Generated
    public LoginPayloadRequest() {
    }

    @Generated
    public LoginPayloadRequest(int id, String channel, byte[] data) {
        this.id = id;
        this.channel = channel;
        this.data = data;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginPayloadRequest)) {
            return false;
        }
        LoginPayloadRequest other = (LoginPayloadRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LoginPayloadRequest;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }
}

