/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.nodes;

import java.util.List;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.nodes.CollectionNode;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MappingNode
extends CollectionNode {
    private List<NodeTuple> value;
    private boolean merged = false;

    /*
     * WARNING - void declaration
     */
    public MappingNode(Tag tag, boolean resolved, List<NodeTuple> value, Mark startMark, Mark endMark, Boolean flowStyle) {
        super((Tag)var1_1, startMark, null, flowStyle);
        void var2_2;
        void var3_3;
        void var1_1;
        if (value == null) {
            throw new NullPointerException("value in a Node is required.");
        }
        this.value = var3_3;
        this.resolved = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public MappingNode(Tag tag, List<NodeTuple> value, Boolean flowStyle) {
        this((Tag)var1_1, true, (List<NodeTuple>)var2_2, null, null, (Boolean)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Override
    public final NodeId getNodeId() {
        return NodeId.mapping;
    }

    public final List<NodeTuple> getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public final void setValue(List<NodeTuple> merge) {
        void var1_1;
        this.value = var1_1;
    }

    public final void setOnlyKeyType(Class<? extends Object> keyType) {
        for (NodeTuple nodeTuple : this.value) {
            nodeTuple.getKeyNode().setType(keyType);
        }
    }

    public final void setTypes(Class<? extends Object> keyType, Class<? extends Object> valueType) {
        for (NodeTuple nodes : this.value) {
            nodes.getValueNode().setType(valueType);
            nodes.getKeyNode().setType(keyType);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder buf = new StringBuilder();
        MappingNode mappingNode = this;
        for (NodeTuple node : mappingNode.value) {
            buf.append("{ key=");
            buf.append(node.getKeyNode());
            buf.append("; value=");
            if (node.getValueNode() instanceof CollectionNode) {
                buf.append(System.identityHashCode(node.getValueNode()));
            } else {
                void var3_3;
                buf.append(var3_3.toString());
            }
            buf.append(" }");
        }
        String values = buf.toString();
        return "<" + this.getClass().getName() + " (tag=" + this.getTag() + ", values=" + (String)var1_1 + ")>";
    }

    public final void setMerged(boolean merged) {
        this.merged = true;
    }

    public final boolean isMerged() {
        return this.merged;
    }
}

