/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.config;

import com.google.common.io.ByteStreams;
import java.security.BasicPermission;
import java.security.Permission;
import java.util.StringTokenizer;

public final class ProviderConfigurationPermission
extends BasicPermission {
    private final String actions;
    private final int permissionMask;

    public ProviderConfigurationPermission(String string, String string2) {
        super(string, string2);
        this.actions = string2;
        this.permissionMask = ProviderConfigurationPermission.calculateMask(string2);
    }

    private static int calculateMask(String object) {
        object = new StringTokenizer(ByteStreams.toLowerCase((String)object), " ,");
        int n = 0;
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string = ((StringTokenizer)object).nextToken();
            if (string.equals("threadlocalecimplicitlyca")) {
                n |= 1;
                continue;
            }
            if (string.equals("ecimplicitlyca")) {
                n |= 2;
                continue;
            }
            if (string.equals("threadlocaldhdefaultparams")) {
                n |= 4;
                continue;
            }
            if (string.equals("dhdefaultparams")) {
                n |= 8;
                continue;
            }
            if (!string.equals("all")) continue;
            n |= 0xF;
        }
        if (n == 0) {
            throw new IllegalArgumentException("unknown permissions passed to mask");
        }
        return n;
    }

    public final String getActions() {
        return this.actions;
    }

    public final boolean implies(Permission permission) {
        if (!(permission instanceof ProviderConfigurationPermission)) {
            return false;
        }
        if (!this.getName().equals(permission.getName())) {
            return false;
        }
        permission = (ProviderConfigurationPermission)permission;
        return (this.permissionMask & ((ProviderConfigurationPermission)permission).permissionMask) == ((ProviderConfigurationPermission)permission).permissionMask;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ProviderConfigurationPermission) {
            object = (ProviderConfigurationPermission)object;
            return this.permissionMask == ((ProviderConfigurationPermission)object).permissionMask && this.getName().equals(((Permission)object).getName());
        }
        return false;
    }

    public final int hashCode() {
        return this.getName().hashCode() + this.permissionMask;
    }
}

