/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.Logger;
import net.md_5.bungee.Permission;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.command.CommandSender;
import net.md_5.bungee.command.ConsoleCommandSender;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class Configuration {
    private transient File reconnect = new File("locations.yml");
    private transient Map<String, String> reconnectLocations;
    private transient File file = new File("config.yml");
    private transient Yaml yaml;
    private transient Map<String, Object> config;
    public String bindHost = "0.0.0.0:25577";
    public String motd = "BungeeCord Proxy Instance";
    public String defaultServerName = "default";
    public int maxPlayers = 1;
    public int timeout = 15000;
    public Map<String, String> servers = new HashMap<String, String>(){
        {
            this.put(Configuration.this.defaultServerName, "127.0.0.1:1338");
            this.put("pvp", "127.0.0.1:1337");
        }
    };
    public Map<String, String> forcedServers = new HashMap<String, String>(){
        {
            this.put("pvp.md-5.net", "pvp");
        }
    };
    public List<String> admins = new ArrayList<String>(){
        {
            this.add("Insert Admins Here");
        }
    };
    public List<String> moderators = new ArrayList<String>(){
        {
            this.add("Insert Moderators Here");
        }
    };
    public List<String> disabledCommands = new ArrayList<String>(){
        {
            this.add("glist");
        }
    };
    public int logNumLines = 16384;
    public String statsUuid = UUID.randomUUID().toString();

    /*
     * WARNING - void declaration
     */
    public void load() {
        try {
            this.file.createNewFile();
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            this.yaml = new Yaml(options);
            FileInputStream is = new FileInputStream(this.file);
            Throwable throwable = null;
            try {
                this.config = (Map)this.yaml.load(is);
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        ((InputStream)is).close();
                    }
                    throw throwable4;
                }
            }
            ((InputStream)is).close();
            if (this.config == null) {
                this.config = new LinkedHashMap<String, Object>();
            }
            Logger.$().info("-------------- Loading configuration ----------------");
            for (Field field : this.getClass().getDeclaredFields()) {
                if (Modifier.isTransient(field.getModifiers())) continue;
                String name = Util.normalize(field.getName());
                try {
                    Object def = field.get(this);
                    Object value = this.get(name, def);
                    field.set(this, value);
                    Logger.$().info(name + ": " + value);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.$().severe("Could not get config node: " + name);
                }
            }
            Logger.$().info("-----------------------------------------------------");
            if (this.servers.get(this.defaultServerName) == null) {
                throw new IllegalArgumentException("Server '" + this.defaultServerName + "' not defined");
            }
            for (String server : this.forcedServers.values()) {
                void var2_6;
                if (this.servers.containsKey(server)) continue;
                throw new IllegalArgumentException("Forced server " + (String)var2_6 + " is not defined in servers");
            }
            this.reconnect.createNewFile();
            FileInputStream recon = new FileInputStream(this.reconnect);
            Throwable throwable5 = null;
            try {
                this.reconnectLocations = (Map)this.yaml.load(recon);
            }
            catch (Throwable throwable6) {
                try {
                    Throwable throwable7 = throwable6;
                    throwable5 = throwable6;
                    throw throwable7;
                }
                catch (Throwable throwable8) {
                    if (throwable5 != null) {
                        try {
                            recon.close();
                        }
                        catch (Throwable x2) {
                            throwable5.addSuppressed(x2);
                        }
                    } else {
                        void x2;
                        x2.close();
                    }
                    throw throwable8;
                }
            }
            recon.close();
            if (this.reconnectLocations == null) {
                this.reconnectLocations = new LinkedHashMap<String, String>();
            }
            return;
        }
        catch (IOException ex) {
            void var1_3;
            Logger.$().severe("Could not load config!");
            var1_3.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T> T get(String path, T def) {
        void var1_1;
        if (!this.config.containsKey(path)) {
            void var2_2;
            this.config.put(path, var2_2);
            this.save(this.file, this.config);
        }
        return (T)this.config.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void save(File fileToSave, Map toSave) {
        try {
            Object object;
            FileWriter wr = new FileWriter(fileToSave);
            Throwable throwable = null;
            try {
                FileWriter fileWriter = wr;
                void var5_9 = object;
                object = this.yaml;
                ArrayList<void> arrayList = new ArrayList<void>(1);
                arrayList.add(var5_9);
                ((Yaml)object).dumpAll(arrayList.iterator(), fileWriter);
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (throwable != null) {
                        try {
                            wr.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        void x2;
                        x2.close();
                    }
                    throw throwable3;
                }
            }
            wr.close();
        }
        catch (IOException ex) {
            void var3_6;
            void var1_1;
            Logger.$().severe("Could not save config file " + var1_1);
            var3_6.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getServer(String user, String requestedHost) {
        void var2_2;
        String server = this.forcedServers.get(requestedHost);
        if (server == null) {
            void var1_1;
            server = this.reconnectLocations.get(var1_1);
        }
        if (server == null) {
            server = this.servers.get(this.defaultServerName);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void setServer(UserConnection user, String server) {
        void var2_2;
        void var1_1;
        this.reconnectLocations.put(var1_1.username, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public InetSocketAddress getServer(String name) {
        String server = this.servers.get(name == null ? this.defaultServerName : name);
        if (server != null) {
            void var1_1;
            return Util.getAddr((String)var1_1);
        }
        return this.getServer(null);
    }

    public void saveHosts() {
        this.save(this.reconnect, this.reconnectLocations);
        Logger.$().info("Saved reconnect locations to " + this.reconnect);
    }

    /*
     * WARNING - void declaration
     */
    public Permission getPermission(CommandSender sender) {
        void var2_2;
        void var1_1;
        Permission permission = Permission.DEFAULT;
        if (this.admins.contains(sender.getName()) || sender instanceof ConsoleCommandSender) {
            permission = Permission.ADMIN;
        } else if (this.moderators.contains(var1_1.getName())) {
            permission = Permission.MODERATOR;
        }
        return var2_2;
    }
}

