/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.reader;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.reader.ReaderException;
import org.yaml.snakeyaml.scanner.Constant;

public final class StreamReader {
    public static final Pattern NON_PRINTABLE = Pattern.compile("[^\t\n\r -~\u0085\u00a0-\ud7ff\ue000-\ufffd]");
    private String name = "'reader'";
    private final Reader stream;
    private int pointer = 0;
    private boolean eof = true;
    private String buffer = "";
    private int index = 0;
    private int line = 0;
    private int column = 0;
    private char[] data;

    /*
     * WARNING - void declaration
     */
    public StreamReader(Reader reader) {
        void var1_1;
        this.stream = var1_1;
        this.eof = false;
        this.data = new char[1024];
        this.update();
    }

    public static boolean isPrintable(char c) {
        char c2;
        return c >= ' ' && c <= '~' || c == '\n' || c == '\r' || c == '\t' || c == '\u0085' || c >= '\u00a0' && c <= '\ud7ff' || c >= '\ue000' && c2 <= '\ufffd';
    }

    public final Mark getMark() {
        return new Mark(this.name, this.index, this.line, this.column, this.buffer, this.pointer);
    }

    public final void forward() {
        this.forward(1);
    }

    public final void forward(int length) {
        if (this.pointer + length + 1 >= this.buffer.length()) {
            this.update();
        }
        int n = 0;
        for (int i = 0; i < length; ++i) {
            char ch = this.buffer.charAt(this.pointer);
            ++this.pointer;
            ++this.index;
            if (Constant.LINEBR.has(ch) || ch == '\r' && this.buffer.charAt(this.pointer) != '\n') {
                ++this.line;
                this.column = 0;
                continue;
            }
            if (n == 65279) continue;
            ++this.column;
        }
    }

    public final char peek() {
        return this.buffer.charAt(this.pointer);
    }

    /*
     * WARNING - void declaration
     */
    public final char peek(int index) {
        void var1_1;
        if (this.pointer + index + 1 > this.buffer.length()) {
            this.update();
        }
        return this.buffer.charAt(this.pointer + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final String prefix(int length) {
        void var1_1;
        if (this.pointer + length >= this.buffer.length()) {
            this.update();
        }
        if (this.pointer + length > this.buffer.length()) {
            return this.buffer.substring(this.pointer);
        }
        return this.buffer.substring(this.pointer, this.pointer + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final String prefixForward(int length) {
        void var2_2;
        void var1_1;
        String prefix = this.prefix(length);
        this.pointer += length;
        this.index += length;
        this.column += var1_1;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void update() {
        if (!this.eof) {
            this.buffer = this.buffer.substring(this.pointer);
            this.pointer = 0;
            try {
                int converted = this.stream.read(this.data);
                if (converted > 0) {
                    int n = converted;
                    boolean bl = false;
                    char[] cArray = this.data;
                    StreamReader streamReader = this;
                    for (int i = 0; i < n; ++i) {
                        char c = cArray[i];
                        if (StreamReader.isPrintable(c)) continue;
                        converted = streamReader.index + streamReader.buffer.length() - streamReader.pointer + i;
                        throw new ReaderException(streamReader.name, converted, c, "special characters are not allowed");
                    }
                } else {
                    this.eof = true;
                    this.buffer = this.buffer + "\u0000";
                    return;
                }
                this.buffer = new StringBuilder(this.buffer.length() + converted).append(this.buffer).append(this.data, 0, converted).toString();
            }
            catch (IOException ioe) {
                void var1_2;
                throw new YAMLException((Throwable)var1_2);
            }
        }
    }

    public final int getColumn() {
        return this.column;
    }

    public final int getIndex() {
        return this.index;
    }

    public final int getLine() {
        return this.line;
    }
}

