/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.introspector;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.FieldProperty;
import org.yaml.snakeyaml.introspector.GenericProperty;
import org.yaml.snakeyaml.introspector.MethodProperty;
import org.yaml.snakeyaml.introspector.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyUtils {
    private final Map<Class<?>, Map<String, Property>> propertiesCache = new HashMap();
    private final Map<Class<?>, Set<Property>> readableProperties = new HashMap();
    private BeanAccess beanAccess = BeanAccess.DEFAULT;
    private boolean allowReadOnlyProperties = false;
    private boolean skipMissingProperties = false;

    /*
     * WARNING - void declaration
     */
    private Map<String, Property> getPropertiesMap(Class<?> type, BeanAccess bAccess) throws IntrospectionException {
        void var3_3;
        void var1_1;
        if (this.propertiesCache.containsKey(type)) {
            return this.propertiesCache.get(type);
        }
        LinkedHashMap<String, GenericProperty> properties = new LinkedHashMap<String, GenericProperty>();
        boolean inaccessableFieldsExist = false;
        switch (bAccess) {
            case FIELD: {
                Class<?> c;
                for (c = type; c != null; c = c.getSuperclass()) {
                    for (Field field : c.getDeclaredFields()) {
                        int modifiers = field.getModifiers();
                        if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || properties.containsKey(field.getName())) continue;
                        properties.put(field.getName(), new FieldProperty(field));
                    }
                }
                break;
            }
            default: {
                Class<?> c;
                for (PropertyDescriptor property : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
                    Method readMethod = property.getReadMethod();
                    if (readMethod != null && readMethod.getName().equals("getClass")) continue;
                    properties.put(property.getName(), new MethodProperty(property));
                }
                for (c = type; c != null; c = c.getSuperclass()) {
                    for (Field field : c.getDeclaredFields()) {
                        int modifiers = field.getModifiers();
                        if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                        if (Modifier.isPublic(modifiers)) {
                            properties.put(field.getName(), new FieldProperty(field));
                            continue;
                        }
                        inaccessableFieldsExist = true;
                    }
                }
            }
        }
        if (properties.isEmpty() && inaccessableFieldsExist) {
            throw new YAMLException("No JavaBean properties found in " + type.getName());
        }
        this.propertiesCache.put((Class<?>)var1_1, (Map<String, Property>)properties);
        return var3_3;
    }

    public final Set<Property> getProperties(Class<? extends Object> type) throws IntrospectionException {
        PropertyUtils propertyUtils;
        Object object = this.beanAccess;
        void var2_3 = propertyUtils;
        propertyUtils = this;
        if (propertyUtils.readableProperties.containsKey(var2_3)) {
            return propertyUtils.readableProperties.get(var2_3);
        }
        Object object2 = object;
        Object object3 = var2_3;
        object = propertyUtils;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        object3 = super.getPropertiesMap((Class<?>)object3, (BeanAccess)((Object)object2)).values();
        object3 = object3.iterator();
        while (object3.hasNext()) {
            object2 = (Property)object3.next();
            if (!((Property)object2).isReadable() || !((PropertyUtils)object).allowReadOnlyProperties && !((Property)object2).isWritable()) continue;
            treeSet.add(object2);
        }
        object = treeSet;
        propertyUtils.readableProperties.put((Class<?>)var2_3, (Set<Property>)object);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public final Property getProperty(Class<? extends Object> type, String name) throws IntrospectionException {
        Object object;
        void var2_2;
        BeanAccess beanAccess = this.beanAccess;
        void var3_4 = var2_2;
        var2_2 = object;
        object = this;
        object = ((PropertyUtils)object).getPropertiesMap((Class<?>)var2_2, beanAccess);
        if ((object = object.get(var3_4)) == null || !((Property)object).isWritable()) {
            throw new YAMLException("Unable to find property '" + (String)var3_4 + "' on class: " + var2_2.getName());
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public final void setAllowReadOnlyProperties(boolean allowReadOnlyProperties) {
        if (this.allowReadOnlyProperties != allowReadOnlyProperties) {
            void var1_1;
            this.allowReadOnlyProperties = var1_1;
            this.readableProperties.clear();
        }
    }
}

