/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.composer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.composer.ComposerException;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.NodeEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.parser.Parser;
import org.yaml.snakeyaml.resolver.Resolver;

public final class Composer {
    private final Parser parser;
    private final Resolver resolver;
    private final Map<String, Node> anchors;
    private final Set<Node> recursiveNodes;

    /*
     * WARNING - void declaration
     */
    public Composer(Parser parser, Resolver resolver) {
        void var2_2;
        void var1_1;
        this.parser = var1_1;
        this.resolver = var2_2;
        this.anchors = new HashMap<String, Node>();
        this.recursiveNodes = new HashSet<Node>();
    }

    /*
     * WARNING - void declaration
     */
    public final Node getSingleNode() {
        void var1_1;
        Node node;
        this.parser.getEvent();
        Object document = null;
        if (!this.parser.checkEvent(Event.ID.StreamEnd)) {
            document = this;
            ((Composer)document).parser.getEvent();
            node = ((Composer)document).composeNode(null);
            ((Composer)document).parser.getEvent();
            ((Composer)document).anchors.clear();
            ((Composer)document).recursiveNodes.clear();
            document = node;
        }
        if (!this.parser.checkEvent(Event.ID.StreamEnd)) {
            Event event = this.parser.getEvent();
            throw new ComposerException("expected a single document in the stream", ((Node)document).getStartMark(), "but found another document", ((Event)((Object)node)).getStartMark());
        }
        this.parser.getEvent();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Node composeNode(Node parent) {
        void var2_3;
        void var1_1;
        Object node;
        this.recursiveNodes.add(parent);
        if (this.parser.checkEvent(Event.ID.Alias)) {
            AliasEvent event = (AliasEvent)this.parser.getEvent();
            String anchor = event.getAnchor();
            if (!this.anchors.containsKey(anchor)) {
                throw new ComposerException(null, null, "found undefined alias " + anchor, event.getStartMark());
            }
            Node result = this.anchors.get(anchor);
            if (this.recursiveNodes.remove(result)) {
                result.setTwoStepsConstruction(true);
            }
            return result;
        }
        Object event = (NodeEvent)this.parser.peekEvent();
        String anchor = ((NodeEvent)event).getAnchor();
        if (anchor != null && this.anchors.containsKey(anchor)) {
            throw new ComposerException("found duplicate anchor " + anchor + "; first occurence", this.anchors.get(anchor).getStartMark(), "second occurence", ((Event)event).getStartMark());
        }
        if (this.parser.checkEvent(Event.ID.Scalar)) {
            event = this;
            Object object = (ScalarEvent)((Composer)event).parser.getEvent();
            Object object2 = ((ScalarEvent)object).getTag();
            boolean bl = false;
            if (object2 == null || ((String)object2).equals("!")) {
                object2 = ((Composer)event).resolver.resolve(NodeId.scalar, ((ScalarEvent)object).getValue(), ((ScalarEvent)object).getImplicit().canOmitTagInPlainScalar());
                bl = true;
            } else {
                object2 = new Tag((String)object2);
            }
            object = new ScalarNode((Tag)object2, bl, ((ScalarEvent)object).getValue(), ((Event)object).getStartMark(), ((Event)object).getEndMark(), ((ScalarEvent)object).getStyle());
            if (anchor != null) {
                ((Composer)event).anchors.put(anchor, (Node)object);
            }
            node = object;
        } else {
            void var3_5;
            node = this.parser.checkEvent(Event.ID.SequenceStart) ? this.composeSequenceNode(anchor) : this.composeMappingNode((String)var3_5);
        }
        this.recursiveNodes.remove(var1_1);
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private Node composeSequenceNode(String anchor) {
        void var2_2;
        void var1_1;
        void var3_3;
        Tag nodeTag;
        SequenceStartEvent startEvent = (SequenceStartEvent)this.parser.getEvent();
        String tag = startEvent.getTag();
        boolean resolved = false;
        if (tag == null || tag.equals("!")) {
            nodeTag = this.resolver.resolve(NodeId.sequence, null, startEvent.getImplicit());
            resolved = true;
        } else {
            nodeTag = new Tag((String)((Object)nodeTag));
        }
        ArrayList<Node> children = new ArrayList<Node>();
        SequenceNode node = new SequenceNode((Tag)var3_3, resolved, children, startEvent.getStartMark(), null, startEvent.getFlowStyle());
        if (anchor != null) {
            this.anchors.put(anchor, node);
        }
        while (!this.parser.checkEvent(Event.ID.SequenceEnd)) {
            children.add(this.composeNode(node));
        }
        Event endEvent = this.parser.getEvent();
        node.setEndMark(var1_1.getEndMark());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Node composeMappingNode(String anchor) {
        void var2_2;
        void var1_1;
        Tag nodeTag;
        MappingStartEvent startEvent = (MappingStartEvent)this.parser.getEvent();
        String tag = startEvent.getTag();
        boolean resolved = false;
        if (tag == null || tag.equals("!")) {
            nodeTag = this.resolver.resolve(NodeId.mapping, null, startEvent.getImplicit());
            resolved = true;
        } else {
            nodeTag = new Tag((String)((Object)nodeTag));
        }
        ArrayList<NodeTuple> children = new ArrayList<NodeTuple>();
        MappingNode node = new MappingNode(nodeTag, resolved, children, startEvent.getStartMark(), null, startEvent.getFlowStyle());
        if (anchor != null) {
            this.anchors.put(anchor, node);
        }
        while (!this.parser.checkEvent(Event.ID.MappingEnd)) {
            void var3_3;
            Node itemKey = this.composeNode(node);
            if (itemKey.getTag().equals(Tag.MERGE)) {
                node.setMerged(true);
            } else if (itemKey.getTag().equals(Tag.VALUE)) {
                itemKey.setTag(Tag.STR);
            }
            Node itemValue = this.composeNode(node);
            children.add(new NodeTuple(itemKey, (Node)var3_3));
        }
        Event endEvent = this.parser.getEvent();
        node.setEndMark(var1_1.getEndMark());
        return var2_2;
    }
}

