/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;

public final class BufferedBlockCipher {
    private byte[] buf;
    private int bufOff;
    private BlockCipher cipher;
    private boolean partialBlockOkay;
    private boolean pgpCFB;

    protected BufferedBlockCipher() {
    }

    public BufferedBlockCipher(BlockCipher object) {
        boolean bl;
        BufferedBlockCipher bufferedBlockCipher;
        this.cipher = object;
        this.buf = new byte[object.getBlockSize()];
        this.bufOff = 0;
        object = object.getAlgorithmName();
        int n = ((String)object).indexOf(47) + 1;
        boolean bl2 = this.pgpCFB = n > 0 && ((String)object).startsWith("PGP", n);
        if (this.pgpCFB) {
            bufferedBlockCipher = this;
            bl = true;
        } else {
            bufferedBlockCipher = this;
            bl = n > 0 && (((String)object).startsWith("CFB", n) || ((String)object).startsWith("OFB", n) || ((String)object).startsWith("OpenPGP", n) || ((String)object).startsWith("SIC", n) || ((String)object).startsWith("GCTR", n));
        }
        bufferedBlockCipher.partialBlockOkay = bl;
    }

    public final void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.reset();
        this.cipher.init(bl, cipherParameters);
    }

    public final int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public final int getOutputSize(int n) {
        return n + this.bufOff;
    }

    public final int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        n3 = this.getBlockSize();
        int n4 = n2;
        BufferedBlockCipher bufferedBlockCipher = this;
        int n5 = bufferedBlockCipher.pgpCFB ? n4 % bufferedBlockCipher.buf.length - (bufferedBlockCipher.cipher.getBlockSize() + 2) : (n4 += bufferedBlockCipher.bufOff) % bufferedBlockCipher.buf.length;
        if ((n5 = n4 - n5) > 0 && n5 + 0 > byArray2.length) {
            throw new DataLengthException("output buffer too short");
        }
        n5 = 0;
        n4 = this.buf.length - this.bufOff;
        if (n2 > n4) {
            System.arraycopy(byArray, n, this.buf, this.bufOff, n4);
            n5 = 0 + this.cipher.processBlock(this.buf, 0, byArray2, 0);
            this.bufOff = 0;
            n2 -= n4;
            n += n4;
            while (n2 > this.buf.length) {
                n5 += this.cipher.processBlock(byArray, n, byArray2, n5 + 0);
                n2 -= n3;
                n += n3;
            }
        }
        System.arraycopy(byArray, n, this.buf, this.bufOff, n2);
        this.bufOff += n2;
        if (this.bufOff == this.buf.length) {
            n5 += this.cipher.processBlock(this.buf, 0, byArray2, n5 + 0);
            this.bufOff = 0;
        }
        return n5;
    }

    public final int doFinal(byte[] byArray, int n) throws DataLengthException, IllegalStateException, InvalidCipherTextException {
        try {
            n = 0;
            if (0 + this.bufOff > byArray.length) {
                throw new DataLengthException("output buffer too short for doFinal()");
            }
            if (this.bufOff != 0) {
                if (!this.partialBlockOkay) {
                    throw new DataLengthException("data not block size aligned");
                }
                this.cipher.processBlock(this.buf, 0, this.buf, 0);
                n = this.bufOff;
                this.bufOff = 0;
                System.arraycopy(this.buf, 0, byArray, 0, n);
            }
            int n2 = n;
            return n2;
        }
        finally {
            this.reset();
        }
    }

    private void reset() {
        for (int i = 0; i < this.buf.length; ++i) {
            this.buf[i] = 0;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

