/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.plugin;

import java.io.InputStream;
import java.lang.reflect.Field;
import net.md_5.bungee.plugin.InvalidPluginException;
import org.yaml.snakeyaml.Yaml;

public class PluginDescription {
    private String name;
    private String main;
    private String version;
    private String author;

    private PluginDescription() {
    }

    public static PluginDescription load(InputStream is) {
        PluginDescription pluginDescription;
        PluginDescription ret = new Yaml().loadAs(is, PluginDescription.class);
        if (ret == null) {
            throw new InvalidPluginException("Could not load plugin description file.");
        }
        for (Field f : PluginDescription.class.getDeclaredFields()) {
            try {
                if (f.get(ret) != null) continue;
                throw new InvalidPluginException(f.getName() + " is not set properly in plugin description");
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {}
        }
        return pluginDescription;
    }

    public String getName() {
        return this.name;
    }

    public String getMain() {
        return this.main;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAuthor() {
        return this.author;
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) {
        void var1_1;
        this.name = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setMain(String main) {
        void var1_1;
        this.main = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setVersion(String version) {
        void var1_1;
        this.version = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setAuthor(String author) {
        void var1_1;
        this.author = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginDescription)) {
            return false;
        }
        PluginDescription other = (PluginDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$main = this.getMain();
        String other$main = other.getMain();
        if (this$main == null ? other$main != null : !this$main.equals(other$main)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(var3_3)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        return !(this$author == null ? other$author != null : !var2_2.equals(var1_1));
    }

    public boolean canEqual(Object other) {
        return other instanceof PluginDescription;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var2_3;
        void var1_2;
        String $name = this.getName();
        int result = 31 + ($name == null ? 0 : $name.hashCode());
        String $main = this.getMain();
        result = result * 31 + ($main == null ? 0 : $main.hashCode());
        String $version = this.getVersion();
        result = result * 31 + ($version == null ? 0 : $version.hashCode());
        String $author = this.getAuthor();
        var1_2 = var1_2 * 31 + ($author == null ? 0 : var2_3.hashCode());
        return (int)var1_2;
    }

    public String toString() {
        return "PluginDescription(name=" + this.getName() + ", main=" + this.getMain() + ", version=" + this.getVersion() + ", author=" + this.getAuthor() + ")";
    }
}

