/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.security.Key;
import javax.crypto.SecretKey;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.KickException;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.packet.Packet2Handshake;
import net.md_5.bungee.packet.PacketFCEncryptionResponse;
import net.md_5.bungee.packet.PacketFDEncryptionRequest;
import net.md_5.bungee.packet.PacketFFKick;
import net.md_5.bungee.packet.PacketInputStream;
import net.md_5.bungee.plugin.HandshakeEvent;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.io.CipherOutputStream;

public class InitialHandler
implements Runnable {
    private final Socket socket;
    private PacketInputStream in;
    private OutputStream out;

    /*
     * WARNING - void declaration
     */
    public InitialHandler(Socket socket) throws IOException {
        void var1_1;
        this.socket = socket;
        this.in = new PacketInputStream(socket.getInputStream());
        this.out = var1_1.getOutputStream();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        try {
            byte[] packet = this.in.readPacket();
            int id = Util.getId(packet);
            switch (id) {
                case 2: {
                    void var2_5;
                    Packet2Handshake handshake = new Packet2Handshake(packet);
                    HandshakeEvent event = new HandshakeEvent(handshake.username, this.socket.getInetAddress());
                    BungeeCord.instance.pluginManager.onHandshake(event);
                    if (event.isCancelled()) {
                        throw new KickException(event.getCancelReason());
                    }
                    PacketFDEncryptionRequest request = EncryptionUtil.encryptRequest();
                    this.out.write(request.getPacket());
                    PacketFCEncryptionResponse packetFCEncryptionResponse = new PacketFCEncryptionResponse(this.in.readPacket());
                    SecretKey shared = EncryptionUtil.getSecret(packetFCEncryptionResponse, request);
                    if (!EncryptionUtil.isAuthenticated(handshake.username, var2_5.serverId, shared)) {
                        throw new KickException("Not authenticated with minecraft.net");
                    }
                    this.out.write(new PacketFCEncryptionResponse().getPacket());
                    this.in = new PacketInputStream(new CipherInputStream(this.socket.getInputStream(), EncryptionUtil.getCipher(false, shared)));
                    this.out = new CipherOutputStream(this.socket.getOutputStream(), EncryptionUtil.getCipher(true, (Key)((Object)packetFCEncryptionResponse)));
                    int n = Util.getId(this.in.readPacket());
                    if (n != 205) {
                        throw new KickException("Unable to receive encrypted client status");
                    }
                    UserConnection userConnection = new UserConnection(this.socket, this.in, this.out, handshake);
                    userConnection.connect(BungeeCord.instance.config.getServer(handshake.username, handshake.host));
                    break;
                }
                case 254: {
                    throw new KickException(BungeeCord.instance.config.motd + '\u00a7' + BungeeCord.instance.connections.size() + '\u00a7' + BungeeCord.instance.config.maxPlayers);
                }
                default: {
                    void var2_4;
                    throw new IllegalArgumentException("Wasn't ready for packet id " + Util.hex((int)var2_4));
                }
            }
        }
        catch (KickException ex) {
            this.kick(ex.getMessage());
            return;
        }
        catch (Exception ex) {
            void var1_3;
            this.kick("[Proxy Error] " + Util.exception((Throwable)var1_3));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void kick(String message) {
        try {
            void var1_1;
            this.out.write(new PacketFFKick((String)var1_1).getPacket());
        }
        catch (IOException iOException) {
            try {
                this.out.flush();
                this.socket.close();
                return;
            }
            catch (IOException iOException2) {
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                this.out.flush();
                this.socket.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            this.out.flush();
            this.socket.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }
}

