/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.util;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ScoreComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.score.Score;

public final class ChatComponentTransformer {
    private static final ChatComponentTransformer INSTANCE = new ChatComponentTransformer();
    private static final Pattern SELECTOR_PATTERN = Pattern.compile("^@([pares])(?:\\[([^ ]*)\\])?$");

    public BaseComponent legacyHoverTransform(ProxiedPlayer player, BaseComponent next) {
        if (player.getPendingConnection().getVersion() < 735) {
            if (next.getHoverEvent() == null || next.getHoverEvent().isLegacy()) {
                return next;
            }
            next = next.duplicate();
            next.getHoverEvent().setLegacy(true);
            if (next.getHoverEvent().getContents().size() > 1) {
                Content exception = next.getHoverEvent().getContents().get(0);
                next.getHoverEvent().getContents().clear();
                next.getHoverEvent().getContents().add(exception);
            }
        } else if (player.getPendingConnection().getVersion() >= 1073742055) {
            if (next.getHoverEvent() != null && !next.getHoverEvent().isV1_21_5()) {
                next = next.duplicate();
                next.getHoverEvent().setV1_21_5(true);
            }
            if (next.getClickEvent() != null && !next.getClickEvent().isV1_21_5()) {
                next = next.duplicate();
                next.getClickEvent().setV1_21_5(true);
            }
        }
        return next;
    }

    public static ChatComponentTransformer getInstance() {
        return INSTANCE;
    }

    public BaseComponent transform(ProxiedPlayer player, BaseComponent components) {
        return this.transform(player, false, components);
    }

    public BaseComponent transform(ProxiedPlayer player, boolean transformHover, BaseComponent root) {
        if (root == null) {
            return new TextComponent("");
        }
        if (transformHover) {
            root = this.legacyHoverTransform(player, root);
        }
        if (root.getExtra() != null && !root.getExtra().isEmpty()) {
            List<BaseComponent> list = root.getExtra().stream().map(extra -> this.transform(player, transformHover, (BaseComponent)extra)).collect(Collectors.toList());
            root.setExtra(list);
        }
        if (root instanceof ScoreComponent) {
            this.transformScoreComponent(player, (ScoreComponent)root);
        }
        return root;
    }

    private void transformScoreComponent(ProxiedPlayer player, ScoreComponent component) {
        Score score;
        Preconditions.checkArgument(!this.isSelectorPattern(component.getName()), "Cannot transform entity selector patterns");
        if (component.getValue() != null && !component.getValue().isEmpty()) {
            return;
        }
        if (component.getName().equals("*")) {
            component.setName(player.getName());
        }
        if (player.getScoreboard().getObjective(component.getObjective()) != null && (score = player.getScoreboard().getScore(component.getName())) != null) {
            component.setValue(Integer.toString(score.getValue()));
        }
    }

    public boolean isSelectorPattern(String pattern) {
        return SELECTOR_PATTERN.matcher(pattern).matches();
    }

    private ChatComponentTransformer() {
    }
}

