/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ChatChain
extends DefinedPacket {
    private List<ChainLink> seen;
    private List<ChainLink> received;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.seen = ChatChain.readLinks(buf);
        if (buf.readBoolean()) {
            this.received = ChatChain.readLinks(buf);
        }
    }

    private static List<ChainLink> readLinks(ByteBuf buf) {
        int cnt = ChatChain.readVarInt(buf);
        Preconditions.checkArgument(cnt <= 5, "Too many entries");
        LinkedList<ChainLink> chain = new LinkedList<ChainLink>();
        for (int i = 0; i < cnt; ++i) {
            chain.add(new ChainLink(ChatChain.readUUID(buf), ChatChain.readArray(buf)));
        }
        return chain;
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        ChatChain.writeLinks(this.seen, buf);
        if (this.received != null) {
            buf.writeBoolean(true);
            ChatChain.writeLinks(this.received, buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    private static void writeLinks(List<ChainLink> links, ByteBuf buf) {
        ChatChain.writeVarInt(links.size(), buf);
        for (ChainLink link : links) {
            ChatChain.writeUUID(link.sender, buf);
            ChatChain.writeArray(link.signature, buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        throw new UnsupportedOperationException("Not supported.");
    }

    public List<ChainLink> getSeen() {
        return this.seen;
    }

    public List<ChainLink> getReceived() {
        return this.received;
    }

    public void setSeen(List<ChainLink> seen) {
        this.seen = seen;
    }

    public void setReceived(List<ChainLink> received) {
        this.received = received;
    }

    @Override
    public String toString() {
        return "ChatChain(seen=" + this.getSeen() + ", received=" + this.getReceived() + ")";
    }

    public ChatChain() {
    }

    public ChatChain(List<ChainLink> seen, List<ChainLink> received) {
        this.seen = seen;
        this.received = received;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatChain)) {
            return false;
        }
        ChatChain other = (ChatChain)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ChainLink> this$seen = this.getSeen();
        List<ChainLink> other$seen = other.getSeen();
        if (this$seen == null ? other$seen != null : !((Object)this$seen).equals(other$seen)) {
            return false;
        }
        List<ChainLink> this$received = this.getReceived();
        List<ChainLink> other$received = other.getReceived();
        return !(this$received == null ? other$received != null : !((Object)this$received).equals(other$received));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatChain;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ChainLink> $seen = this.getSeen();
        result = result * 59 + ($seen == null ? 43 : ((Object)$seen).hashCode());
        List<ChainLink> $received = this.getReceived();
        result = result * 59 + ($received == null ? 43 : ((Object)$received).hashCode());
        return result;
    }

    public static class ChainLink {
        private final UUID sender;
        private final byte[] signature;

        public ChainLink(UUID sender, byte[] signature) {
            this.sender = sender;
            this.signature = signature;
        }

        public UUID getSender() {
            return this.sender;
        }

        public byte[] getSignature() {
            return this.signature;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChainLink)) {
                return false;
            }
            ChainLink other = (ChainLink)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$sender = this.getSender();
            UUID other$sender = other.getSender();
            if (this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender)) {
                return false;
            }
            return Arrays.equals(this.getSignature(), other.getSignature());
        }

        protected boolean canEqual(Object other) {
            return other instanceof ChainLink;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $sender = this.getSender();
            result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
            result = result * 59 + Arrays.hashCode(this.getSignature());
            return result;
        }

        public String toString() {
            return "ChatChain.ChainLink(sender=" + this.getSender() + ", signature=" + Arrays.toString(this.getSignature()) + ")";
        }
    }
}

